/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.kroxylicious.test.codec;

import org.apache.kafka.common.message.AddOffsetsToTxnRequestData;
import org.apache.kafka.common.message.AddOffsetsToTxnResponseData;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.message.AddRaftVoterRequestData;
import org.apache.kafka.common.message.AddRaftVoterResponseData;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterClientQuotasRequestData;
import org.apache.kafka.common.message.AlterClientQuotasResponseData;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.AssignReplicasToDirsRequestData;
import org.apache.kafka.common.message.AssignReplicasToDirsResponseData;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.message.ConsumerGroupDescribeRequestData;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.ControlledShutdownRequestData;
import org.apache.kafka.common.message.ControlledShutdownResponseData;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.message.ControllerRegistrationResponseData;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreateDelegationTokenRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.message.DeleteShareGroupStateRequestData;
import org.apache.kafka.common.message.DeleteShareGroupStateResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.DescribeDelegationTokenRequestData;
import org.apache.kafka.common.message.DescribeDelegationTokenResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.DescribeLogDirsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.DescribeProducersRequestData;
import org.apache.kafka.common.message.DescribeProducersResponseData;
import org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsRequestData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeTransactionsRequestData;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.EndTxnRequestData;
import org.apache.kafka.common.message.EndTxnResponseData;
import org.apache.kafka.common.message.EnvelopeRequestData;
import org.apache.kafka.common.message.EnvelopeResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenRequestData;
import org.apache.kafka.common.message.ExpireDelegationTokenResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotRequestData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.message.GetTelemetrySubscriptionsRequestData;
import org.apache.kafka.common.message.GetTelemetrySubscriptionsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.message.InitProducerIdResponseData;
import org.apache.kafka.common.message.InitializeShareGroupStateRequestData;
import org.apache.kafka.common.message.InitializeShareGroupStateResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListClientMetricsResourcesRequestData;
import org.apache.kafka.common.message.ListClientMetricsResourcesResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.ListTransactionsRequestData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.message.PushTelemetryRequestData;
import org.apache.kafka.common.message.PushTelemetryResponseData;
import org.apache.kafka.common.message.ReadShareGroupStateRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateResponseData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryResponseData;
import org.apache.kafka.common.message.RemoveRaftVoterRequestData;
import org.apache.kafka.common.message.RemoveRaftVoterResponseData;
import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.message.ShareAcknowledgeRequestData;
import org.apache.kafka.common.message.ShareAcknowledgeResponseData;
import org.apache.kafka.common.message.ShareFetchRequestData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.message.ShareGroupDescribeRequestData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.message.UnregisterBrokerRequestData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.message.UpdateMetadataResponseData;
import org.apache.kafka.common.message.UpdateRaftVoterRequestData;
import org.apache.kafka.common.message.UpdateRaftVoterResponseData;
import org.apache.kafka.common.message.VoteRequestData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;
import org.apache.kafka.common.message.WriteShareGroupStateResponseData;
import org.apache.kafka.common.message.WriteTxnMarkersRequestData;
import org.apache.kafka.common.message.WriteTxnMarkersResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;

/**
* Decodes Kafka Readable into an ApiMessage
* <p>Note: this class is automatically generated from a template</p>
*/
public class BodyDecoder {

    /**
    * Creates a BodyDecoder
    */
    private BodyDecoder() {
    }

    /**
    * Decodes Kafka request Readable into an ApiMessage
    * @param apiKey the api key of the message
    * @param apiVersion the api version of the message
    * @param accessor the accessor for the message bytes
    * @return the ApiMessage
    * @throws IllegalArgumentException if an unhandled ApiKey is encountered
    */
    static ApiMessage decodeRequest(ApiKeys apiKey, short apiVersion, ByteBufAccessor accessor) {
        return switch (apiKey) {
            case ADD_OFFSETS_TO_TXN ->
                    new AddOffsetsToTxnRequestData(accessor, apiVersion);
            case ADD_PARTITIONS_TO_TXN ->
                    new AddPartitionsToTxnRequestData(accessor, apiVersion);
            case ADD_RAFT_VOTER ->
                    new AddRaftVoterRequestData(accessor, apiVersion);
            case ALLOCATE_PRODUCER_IDS ->
                    new AllocateProducerIdsRequestData(accessor, apiVersion);
            case ALTER_CLIENT_QUOTAS ->
                    new AlterClientQuotasRequestData(accessor, apiVersion);
            case ALTER_CONFIGS ->
                    new AlterConfigsRequestData(accessor, apiVersion);
            case ALTER_PARTITION_REASSIGNMENTS ->
                    new AlterPartitionReassignmentsRequestData(accessor, apiVersion);
            case ALTER_PARTITION ->
                    new AlterPartitionRequestData(accessor, apiVersion);
            case ALTER_REPLICA_LOG_DIRS ->
                    new AlterReplicaLogDirsRequestData(accessor, apiVersion);
            case ALTER_USER_SCRAM_CREDENTIALS ->
                    new AlterUserScramCredentialsRequestData(accessor, apiVersion);
            case API_VERSIONS ->
                    new ApiVersionsRequestData(accessor, apiVersion);
            case ASSIGN_REPLICAS_TO_DIRS ->
                    new AssignReplicasToDirsRequestData(accessor, apiVersion);
            case BEGIN_QUORUM_EPOCH ->
                    new BeginQuorumEpochRequestData(accessor, apiVersion);
            case BROKER_HEARTBEAT ->
                    new BrokerHeartbeatRequestData(accessor, apiVersion);
            case BROKER_REGISTRATION ->
                    new BrokerRegistrationRequestData(accessor, apiVersion);
            case CONSUMER_GROUP_DESCRIBE ->
                    new ConsumerGroupDescribeRequestData(accessor, apiVersion);
            case CONSUMER_GROUP_HEARTBEAT ->
                    new ConsumerGroupHeartbeatRequestData(accessor, apiVersion);
            case CONTROLLED_SHUTDOWN ->
                    new ControlledShutdownRequestData(accessor, apiVersion);
            case CONTROLLER_REGISTRATION ->
                    new ControllerRegistrationRequestData(accessor, apiVersion);
            case CREATE_ACLS ->
                    new CreateAclsRequestData(accessor, apiVersion);
            case CREATE_DELEGATION_TOKEN ->
                    new CreateDelegationTokenRequestData(accessor, apiVersion);
            case CREATE_PARTITIONS ->
                    new CreatePartitionsRequestData(accessor, apiVersion);
            case CREATE_TOPICS ->
                    new CreateTopicsRequestData(accessor, apiVersion);
            case DELETE_ACLS ->
                    new DeleteAclsRequestData(accessor, apiVersion);
            case DELETE_GROUPS ->
                    new DeleteGroupsRequestData(accessor, apiVersion);
            case DELETE_RECORDS ->
                    new DeleteRecordsRequestData(accessor, apiVersion);
            case DELETE_SHARE_GROUP_STATE ->
                    new DeleteShareGroupStateRequestData(accessor, apiVersion);
            case DELETE_TOPICS ->
                    new DeleteTopicsRequestData(accessor, apiVersion);
            case DESCRIBE_ACLS ->
                    new DescribeAclsRequestData(accessor, apiVersion);
            case DESCRIBE_CLIENT_QUOTAS ->
                    new DescribeClientQuotasRequestData(accessor, apiVersion);
            case DESCRIBE_CLUSTER ->
                    new DescribeClusterRequestData(accessor, apiVersion);
            case DESCRIBE_CONFIGS ->
                    new DescribeConfigsRequestData(accessor, apiVersion);
            case DESCRIBE_DELEGATION_TOKEN ->
                    new DescribeDelegationTokenRequestData(accessor, apiVersion);
            case DESCRIBE_GROUPS ->
                    new DescribeGroupsRequestData(accessor, apiVersion);
            case DESCRIBE_LOG_DIRS ->
                    new DescribeLogDirsRequestData(accessor, apiVersion);
            case DESCRIBE_PRODUCERS ->
                    new DescribeProducersRequestData(accessor, apiVersion);
            case DESCRIBE_QUORUM ->
                    new DescribeQuorumRequestData(accessor, apiVersion);
            case DESCRIBE_TOPIC_PARTITIONS ->
                    new DescribeTopicPartitionsRequestData(accessor, apiVersion);
            case DESCRIBE_TRANSACTIONS ->
                    new DescribeTransactionsRequestData(accessor, apiVersion);
            case DESCRIBE_USER_SCRAM_CREDENTIALS ->
                    new DescribeUserScramCredentialsRequestData(accessor, apiVersion);
            case ELECT_LEADERS ->
                    new ElectLeadersRequestData(accessor, apiVersion);
            case END_QUORUM_EPOCH ->
                    new EndQuorumEpochRequestData(accessor, apiVersion);
            case END_TXN ->
                    new EndTxnRequestData(accessor, apiVersion);
            case ENVELOPE ->
                    new EnvelopeRequestData(accessor, apiVersion);
            case EXPIRE_DELEGATION_TOKEN ->
                    new ExpireDelegationTokenRequestData(accessor, apiVersion);
            case FETCH ->
                    new FetchRequestData(accessor, apiVersion);
            case FETCH_SNAPSHOT ->
                    new FetchSnapshotRequestData(accessor, apiVersion);
            case FIND_COORDINATOR ->
                    new FindCoordinatorRequestData(accessor, apiVersion);
            case GET_TELEMETRY_SUBSCRIPTIONS ->
                    new GetTelemetrySubscriptionsRequestData(accessor, apiVersion);
            case HEARTBEAT ->
                    new HeartbeatRequestData(accessor, apiVersion);
            case INCREMENTAL_ALTER_CONFIGS ->
                    new IncrementalAlterConfigsRequestData(accessor, apiVersion);
            case INIT_PRODUCER_ID ->
                    new InitProducerIdRequestData(accessor, apiVersion);
            case INITIALIZE_SHARE_GROUP_STATE ->
                    new InitializeShareGroupStateRequestData(accessor, apiVersion);
            case JOIN_GROUP ->
                    new JoinGroupRequestData(accessor, apiVersion);
            case LEADER_AND_ISR ->
                    new LeaderAndIsrRequestData(accessor, apiVersion);
            case LEAVE_GROUP ->
                    new LeaveGroupRequestData(accessor, apiVersion);
            case LIST_CLIENT_METRICS_RESOURCES ->
                    new ListClientMetricsResourcesRequestData(accessor, apiVersion);
            case LIST_GROUPS ->
                    new ListGroupsRequestData(accessor, apiVersion);
            case LIST_OFFSETS ->
                    new ListOffsetsRequestData(accessor, apiVersion);
            case LIST_PARTITION_REASSIGNMENTS ->
                    new ListPartitionReassignmentsRequestData(accessor, apiVersion);
            case LIST_TRANSACTIONS ->
                    new ListTransactionsRequestData(accessor, apiVersion);
            case METADATA ->
                    new MetadataRequestData(accessor, apiVersion);
            case OFFSET_COMMIT ->
                    new OffsetCommitRequestData(accessor, apiVersion);
            case OFFSET_DELETE ->
                    new OffsetDeleteRequestData(accessor, apiVersion);
            case OFFSET_FETCH ->
                    new OffsetFetchRequestData(accessor, apiVersion);
            case OFFSET_FOR_LEADER_EPOCH ->
                    new OffsetForLeaderEpochRequestData(accessor, apiVersion);
            case PRODUCE ->
                    new ProduceRequestData(accessor, apiVersion);
            case PUSH_TELEMETRY ->
                    new PushTelemetryRequestData(accessor, apiVersion);
            case READ_SHARE_GROUP_STATE ->
                    new ReadShareGroupStateRequestData(accessor, apiVersion);
            case READ_SHARE_GROUP_STATE_SUMMARY ->
                    new ReadShareGroupStateSummaryRequestData(accessor, apiVersion);
            case REMOVE_RAFT_VOTER ->
                    new RemoveRaftVoterRequestData(accessor, apiVersion);
            case RENEW_DELEGATION_TOKEN ->
                    new RenewDelegationTokenRequestData(accessor, apiVersion);
            case SASL_AUTHENTICATE ->
                    new SaslAuthenticateRequestData(accessor, apiVersion);
            case SASL_HANDSHAKE ->
                    new SaslHandshakeRequestData(accessor, apiVersion);
            case SHARE_ACKNOWLEDGE ->
                    new ShareAcknowledgeRequestData(accessor, apiVersion);
            case SHARE_FETCH ->
                    new ShareFetchRequestData(accessor, apiVersion);
            case SHARE_GROUP_DESCRIBE ->
                    new ShareGroupDescribeRequestData(accessor, apiVersion);
            case SHARE_GROUP_HEARTBEAT ->
                    new ShareGroupHeartbeatRequestData(accessor, apiVersion);
            case STOP_REPLICA ->
                    new StopReplicaRequestData(accessor, apiVersion);
            case SYNC_GROUP ->
                    new SyncGroupRequestData(accessor, apiVersion);
            case TXN_OFFSET_COMMIT ->
                    new TxnOffsetCommitRequestData(accessor, apiVersion);
            case UNREGISTER_BROKER ->
                    new UnregisterBrokerRequestData(accessor, apiVersion);
            case UPDATE_FEATURES ->
                    new UpdateFeaturesRequestData(accessor, apiVersion);
            case UPDATE_METADATA ->
                    new UpdateMetadataRequestData(accessor, apiVersion);
            case UPDATE_RAFT_VOTER ->
                    new UpdateRaftVoterRequestData(accessor, apiVersion);
            case VOTE ->
                    new VoteRequestData(accessor, apiVersion);
            case WRITE_SHARE_GROUP_STATE ->
                    new WriteShareGroupStateRequestData(accessor, apiVersion);
            case WRITE_TXN_MARKERS ->
                    new WriteTxnMarkersRequestData(accessor, apiVersion);
            default -> throw new IllegalArgumentException("Unsupported RPC " + apiKey);
        };
    }

    /**
    * Decodes Kafka response Readable into an ApiMessage
    * @param apiKey the api key of the message
    * @param apiVersion the api version of the message
    * @param accessor the accessor for the message bytes
    * @return the ApiMessage
    * @throws IllegalArgumentException if an unhandled ApiKey is encountered
    */
    static ApiMessage decodeResponse(ApiKeys apiKey, short apiVersion, ByteBufAccessor accessor) {
        return switch (apiKey) {
            case ADD_OFFSETS_TO_TXN -> new AddOffsetsToTxnResponseData(accessor, apiVersion);
            case ADD_PARTITIONS_TO_TXN -> new AddPartitionsToTxnResponseData(accessor, apiVersion);
            case ADD_RAFT_VOTER -> new AddRaftVoterResponseData(accessor, apiVersion);
            case ALLOCATE_PRODUCER_IDS -> new AllocateProducerIdsResponseData(accessor, apiVersion);
            case ALTER_CLIENT_QUOTAS -> new AlterClientQuotasResponseData(accessor, apiVersion);
            case ALTER_CONFIGS -> new AlterConfigsResponseData(accessor, apiVersion);
            case ALTER_PARTITION_REASSIGNMENTS -> new AlterPartitionReassignmentsResponseData(accessor, apiVersion);
            case ALTER_PARTITION -> new AlterPartitionResponseData(accessor, apiVersion);
            case ALTER_REPLICA_LOG_DIRS -> new AlterReplicaLogDirsResponseData(accessor, apiVersion);
            case ALTER_USER_SCRAM_CREDENTIALS -> new AlterUserScramCredentialsResponseData(accessor, apiVersion);
            case API_VERSIONS -> {
                // KIP-511 when the client receives an unsupported version for the ApiVersionResponse, it fails back to version 0
                // Use the same algorithm as https://github.com/apache/kafka/blob/a41c10fd49841381b5207c184a385622094ed440/clients/src/main/java/org/apache/kafka/common/requests/ApiVersionsResponse.java#L90-L106
                int prev = accessor.readerIndex();
                try {
                    yield new ApiVersionsResponseData(accessor, apiVersion);
                }
                catch (RuntimeException e) {
                    accessor.readerIndex(prev);
                    if (apiVersion != 0) {
                        yield new ApiVersionsResponseData(accessor, (short) 0);
                    }
                    else {
                        throw e;
                    }
                }
            }
            case ASSIGN_REPLICAS_TO_DIRS -> new AssignReplicasToDirsResponseData(accessor, apiVersion);
            case BEGIN_QUORUM_EPOCH -> new BeginQuorumEpochResponseData(accessor, apiVersion);
            case BROKER_HEARTBEAT -> new BrokerHeartbeatResponseData(accessor, apiVersion);
            case BROKER_REGISTRATION -> new BrokerRegistrationResponseData(accessor, apiVersion);
            case CONSUMER_GROUP_DESCRIBE -> new ConsumerGroupDescribeResponseData(accessor, apiVersion);
            case CONSUMER_GROUP_HEARTBEAT -> new ConsumerGroupHeartbeatResponseData(accessor, apiVersion);
            case CONTROLLED_SHUTDOWN -> new ControlledShutdownResponseData(accessor, apiVersion);
            case CONTROLLER_REGISTRATION -> new ControllerRegistrationResponseData(accessor, apiVersion);
            case CREATE_ACLS -> new CreateAclsResponseData(accessor, apiVersion);
            case CREATE_DELEGATION_TOKEN -> new CreateDelegationTokenResponseData(accessor, apiVersion);
            case CREATE_PARTITIONS -> new CreatePartitionsResponseData(accessor, apiVersion);
            case CREATE_TOPICS -> new CreateTopicsResponseData(accessor, apiVersion);
            case DELETE_ACLS -> new DeleteAclsResponseData(accessor, apiVersion);
            case DELETE_GROUPS -> new DeleteGroupsResponseData(accessor, apiVersion);
            case DELETE_RECORDS -> new DeleteRecordsResponseData(accessor, apiVersion);
            case DELETE_SHARE_GROUP_STATE -> new DeleteShareGroupStateResponseData(accessor, apiVersion);
            case DELETE_TOPICS -> new DeleteTopicsResponseData(accessor, apiVersion);
            case DESCRIBE_ACLS -> new DescribeAclsResponseData(accessor, apiVersion);
            case DESCRIBE_CLIENT_QUOTAS -> new DescribeClientQuotasResponseData(accessor, apiVersion);
            case DESCRIBE_CLUSTER -> new DescribeClusterResponseData(accessor, apiVersion);
            case DESCRIBE_CONFIGS -> new DescribeConfigsResponseData(accessor, apiVersion);
            case DESCRIBE_DELEGATION_TOKEN -> new DescribeDelegationTokenResponseData(accessor, apiVersion);
            case DESCRIBE_GROUPS -> new DescribeGroupsResponseData(accessor, apiVersion);
            case DESCRIBE_LOG_DIRS -> new DescribeLogDirsResponseData(accessor, apiVersion);
            case DESCRIBE_PRODUCERS -> new DescribeProducersResponseData(accessor, apiVersion);
            case DESCRIBE_QUORUM -> new DescribeQuorumResponseData(accessor, apiVersion);
            case DESCRIBE_TOPIC_PARTITIONS -> new DescribeTopicPartitionsResponseData(accessor, apiVersion);
            case DESCRIBE_TRANSACTIONS -> new DescribeTransactionsResponseData(accessor, apiVersion);
            case DESCRIBE_USER_SCRAM_CREDENTIALS -> new DescribeUserScramCredentialsResponseData(accessor, apiVersion);
            case ELECT_LEADERS -> new ElectLeadersResponseData(accessor, apiVersion);
            case END_QUORUM_EPOCH -> new EndQuorumEpochResponseData(accessor, apiVersion);
            case END_TXN -> new EndTxnResponseData(accessor, apiVersion);
            case ENVELOPE -> new EnvelopeResponseData(accessor, apiVersion);
            case EXPIRE_DELEGATION_TOKEN -> new ExpireDelegationTokenResponseData(accessor, apiVersion);
            case FETCH -> new FetchResponseData(accessor, apiVersion);
            case FETCH_SNAPSHOT -> new FetchSnapshotResponseData(accessor, apiVersion);
            case FIND_COORDINATOR -> new FindCoordinatorResponseData(accessor, apiVersion);
            case GET_TELEMETRY_SUBSCRIPTIONS -> new GetTelemetrySubscriptionsResponseData(accessor, apiVersion);
            case HEARTBEAT -> new HeartbeatResponseData(accessor, apiVersion);
            case INCREMENTAL_ALTER_CONFIGS -> new IncrementalAlterConfigsResponseData(accessor, apiVersion);
            case INIT_PRODUCER_ID -> new InitProducerIdResponseData(accessor, apiVersion);
            case INITIALIZE_SHARE_GROUP_STATE -> new InitializeShareGroupStateResponseData(accessor, apiVersion);
            case JOIN_GROUP -> new JoinGroupResponseData(accessor, apiVersion);
            case LEADER_AND_ISR -> new LeaderAndIsrResponseData(accessor, apiVersion);
            case LEAVE_GROUP -> new LeaveGroupResponseData(accessor, apiVersion);
            case LIST_CLIENT_METRICS_RESOURCES -> new ListClientMetricsResourcesResponseData(accessor, apiVersion);
            case LIST_GROUPS -> new ListGroupsResponseData(accessor, apiVersion);
            case LIST_OFFSETS -> new ListOffsetsResponseData(accessor, apiVersion);
            case LIST_PARTITION_REASSIGNMENTS -> new ListPartitionReassignmentsResponseData(accessor, apiVersion);
            case LIST_TRANSACTIONS -> new ListTransactionsResponseData(accessor, apiVersion);
            case METADATA -> new MetadataResponseData(accessor, apiVersion);
            case OFFSET_COMMIT -> new OffsetCommitResponseData(accessor, apiVersion);
            case OFFSET_DELETE -> new OffsetDeleteResponseData(accessor, apiVersion);
            case OFFSET_FETCH -> new OffsetFetchResponseData(accessor, apiVersion);
            case OFFSET_FOR_LEADER_EPOCH -> new OffsetForLeaderEpochResponseData(accessor, apiVersion);
            case PRODUCE -> new ProduceResponseData(accessor, apiVersion);
            case PUSH_TELEMETRY -> new PushTelemetryResponseData(accessor, apiVersion);
            case READ_SHARE_GROUP_STATE -> new ReadShareGroupStateResponseData(accessor, apiVersion);
            case READ_SHARE_GROUP_STATE_SUMMARY -> new ReadShareGroupStateSummaryResponseData(accessor, apiVersion);
            case REMOVE_RAFT_VOTER -> new RemoveRaftVoterResponseData(accessor, apiVersion);
            case RENEW_DELEGATION_TOKEN -> new RenewDelegationTokenResponseData(accessor, apiVersion);
            case SASL_AUTHENTICATE -> new SaslAuthenticateResponseData(accessor, apiVersion);
            case SASL_HANDSHAKE -> new SaslHandshakeResponseData(accessor, apiVersion);
            case SHARE_ACKNOWLEDGE -> new ShareAcknowledgeResponseData(accessor, apiVersion);
            case SHARE_FETCH -> new ShareFetchResponseData(accessor, apiVersion);
            case SHARE_GROUP_DESCRIBE -> new ShareGroupDescribeResponseData(accessor, apiVersion);
            case SHARE_GROUP_HEARTBEAT -> new ShareGroupHeartbeatResponseData(accessor, apiVersion);
            case STOP_REPLICA -> new StopReplicaResponseData(accessor, apiVersion);
            case SYNC_GROUP -> new SyncGroupResponseData(accessor, apiVersion);
            case TXN_OFFSET_COMMIT -> new TxnOffsetCommitResponseData(accessor, apiVersion);
            case UNREGISTER_BROKER -> new UnregisterBrokerResponseData(accessor, apiVersion);
            case UPDATE_FEATURES -> new UpdateFeaturesResponseData(accessor, apiVersion);
            case UPDATE_METADATA -> new UpdateMetadataResponseData(accessor, apiVersion);
            case UPDATE_RAFT_VOTER -> new UpdateRaftVoterResponseData(accessor, apiVersion);
            case VOTE -> new VoteResponseData(accessor, apiVersion);
            case WRITE_SHARE_GROUP_STATE -> new WriteShareGroupStateResponseData(accessor, apiVersion);
            case WRITE_TXN_MARKERS -> new WriteTxnMarkersResponseData(accessor, apiVersion);
            default -> throw new IllegalArgumentException("Unsupported RPC " + apiKey);
        };
    }

}