
package io.kroxylicious.test;


import java.util.Collections;
import java.util.Map;
import java.util.HashMap;

import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;

import org.apache.kafka.common.message.AddOffsetsToTxnRequestData;
import org.apache.kafka.common.message.AddOffsetsToTxnResponseData;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.message.AddRaftVoterRequestData;
import org.apache.kafka.common.message.AddRaftVoterResponseData;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterClientQuotasRequestData;
import org.apache.kafka.common.message.AlterClientQuotasResponseData;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.AssignReplicasToDirsRequestData;
import org.apache.kafka.common.message.AssignReplicasToDirsResponseData;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.message.ConsumerGroupDescribeRequestData;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.ControlledShutdownRequestData;
import org.apache.kafka.common.message.ControlledShutdownResponseData;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.message.ControllerRegistrationResponseData;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreateDelegationTokenRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.message.DeleteShareGroupStateRequestData;
import org.apache.kafka.common.message.DeleteShareGroupStateResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.DescribeDelegationTokenRequestData;
import org.apache.kafka.common.message.DescribeDelegationTokenResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.DescribeLogDirsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.DescribeProducersRequestData;
import org.apache.kafka.common.message.DescribeProducersResponseData;
import org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsRequestData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeTransactionsRequestData;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.EndTxnRequestData;
import org.apache.kafka.common.message.EndTxnResponseData;
import org.apache.kafka.common.message.EnvelopeRequestData;
import org.apache.kafka.common.message.EnvelopeResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenRequestData;
import org.apache.kafka.common.message.ExpireDelegationTokenResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotRequestData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.message.GetTelemetrySubscriptionsRequestData;
import org.apache.kafka.common.message.GetTelemetrySubscriptionsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.message.InitProducerIdResponseData;
import org.apache.kafka.common.message.InitializeShareGroupStateRequestData;
import org.apache.kafka.common.message.InitializeShareGroupStateResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListClientMetricsResourcesRequestData;
import org.apache.kafka.common.message.ListClientMetricsResourcesResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.ListTransactionsRequestData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.message.PushTelemetryRequestData;
import org.apache.kafka.common.message.PushTelemetryResponseData;
import org.apache.kafka.common.message.ReadShareGroupStateRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateResponseData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryResponseData;
import org.apache.kafka.common.message.RemoveRaftVoterRequestData;
import org.apache.kafka.common.message.RemoveRaftVoterResponseData;
import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.message.ShareAcknowledgeRequestData;
import org.apache.kafka.common.message.ShareAcknowledgeResponseData;
import org.apache.kafka.common.message.ShareFetchRequestData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.message.ShareGroupDescribeRequestData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.message.UnregisterBrokerRequestData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.message.UpdateMetadataResponseData;
import org.apache.kafka.common.message.UpdateRaftVoterRequestData;
import org.apache.kafka.common.message.UpdateRaftVoterResponseData;
import org.apache.kafka.common.message.VoteRequestData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;
import org.apache.kafka.common.message.WriteShareGroupStateResponseData;
import org.apache.kafka.common.message.WriteTxnMarkersRequestData;
import org.apache.kafka.common.message.WriteTxnMarkersResponseData;


/**
* Enumerates all DataClasses
*/
public class DataClasses {

    /**
    * Create an empty DataClasses
    */
    private DataClasses() {

    }

    private static final Map<ApiKeys, Class<? extends ApiMessage>> requestClasses;
    private static final Map<ApiKeys, Class<? extends ApiMessage>> responseClasses;

    static {
        requestClasses = new HashMap<ApiKeys, Class<? extends ApiMessage>>();
        responseClasses = new HashMap<ApiKeys, Class<? extends ApiMessage>>();

        requestClasses.put(ApiKeys.ADD_OFFSETS_TO_TXN, AddOffsetsToTxnRequestData.class);
        responseClasses.put(ApiKeys.ADD_OFFSETS_TO_TXN, AddOffsetsToTxnResponseData.class);
        requestClasses.put(ApiKeys.ADD_PARTITIONS_TO_TXN, AddPartitionsToTxnRequestData.class);
        responseClasses.put(ApiKeys.ADD_PARTITIONS_TO_TXN, AddPartitionsToTxnResponseData.class);
        requestClasses.put(ApiKeys.ADD_RAFT_VOTER, AddRaftVoterRequestData.class);
        responseClasses.put(ApiKeys.ADD_RAFT_VOTER, AddRaftVoterResponseData.class);
        requestClasses.put(ApiKeys.ALLOCATE_PRODUCER_IDS, AllocateProducerIdsRequestData.class);
        responseClasses.put(ApiKeys.ALLOCATE_PRODUCER_IDS, AllocateProducerIdsResponseData.class);
        requestClasses.put(ApiKeys.ALTER_CLIENT_QUOTAS, AlterClientQuotasRequestData.class);
        responseClasses.put(ApiKeys.ALTER_CLIENT_QUOTAS, AlterClientQuotasResponseData.class);
        requestClasses.put(ApiKeys.ALTER_CONFIGS, AlterConfigsRequestData.class);
        responseClasses.put(ApiKeys.ALTER_CONFIGS, AlterConfigsResponseData.class);
        requestClasses.put(ApiKeys.ALTER_PARTITION_REASSIGNMENTS, AlterPartitionReassignmentsRequestData.class);
        responseClasses.put(ApiKeys.ALTER_PARTITION_REASSIGNMENTS, AlterPartitionReassignmentsResponseData.class);
        requestClasses.put(ApiKeys.ALTER_PARTITION, AlterPartitionRequestData.class);
        responseClasses.put(ApiKeys.ALTER_PARTITION, AlterPartitionResponseData.class);
        requestClasses.put(ApiKeys.ALTER_REPLICA_LOG_DIRS, AlterReplicaLogDirsRequestData.class);
        responseClasses.put(ApiKeys.ALTER_REPLICA_LOG_DIRS, AlterReplicaLogDirsResponseData.class);
        requestClasses.put(ApiKeys.ALTER_USER_SCRAM_CREDENTIALS, AlterUserScramCredentialsRequestData.class);
        responseClasses.put(ApiKeys.ALTER_USER_SCRAM_CREDENTIALS, AlterUserScramCredentialsResponseData.class);
        requestClasses.put(ApiKeys.API_VERSIONS, ApiVersionsRequestData.class);
        responseClasses.put(ApiKeys.API_VERSIONS, ApiVersionsResponseData.class);
        requestClasses.put(ApiKeys.ASSIGN_REPLICAS_TO_DIRS, AssignReplicasToDirsRequestData.class);
        responseClasses.put(ApiKeys.ASSIGN_REPLICAS_TO_DIRS, AssignReplicasToDirsResponseData.class);
        requestClasses.put(ApiKeys.BEGIN_QUORUM_EPOCH, BeginQuorumEpochRequestData.class);
        responseClasses.put(ApiKeys.BEGIN_QUORUM_EPOCH, BeginQuorumEpochResponseData.class);
        requestClasses.put(ApiKeys.BROKER_HEARTBEAT, BrokerHeartbeatRequestData.class);
        responseClasses.put(ApiKeys.BROKER_HEARTBEAT, BrokerHeartbeatResponseData.class);
        requestClasses.put(ApiKeys.BROKER_REGISTRATION, BrokerRegistrationRequestData.class);
        responseClasses.put(ApiKeys.BROKER_REGISTRATION, BrokerRegistrationResponseData.class);
        requestClasses.put(ApiKeys.CONSUMER_GROUP_DESCRIBE, ConsumerGroupDescribeRequestData.class);
        responseClasses.put(ApiKeys.CONSUMER_GROUP_DESCRIBE, ConsumerGroupDescribeResponseData.class);
        requestClasses.put(ApiKeys.CONSUMER_GROUP_HEARTBEAT, ConsumerGroupHeartbeatRequestData.class);
        responseClasses.put(ApiKeys.CONSUMER_GROUP_HEARTBEAT, ConsumerGroupHeartbeatResponseData.class);
        requestClasses.put(ApiKeys.CONTROLLED_SHUTDOWN, ControlledShutdownRequestData.class);
        responseClasses.put(ApiKeys.CONTROLLED_SHUTDOWN, ControlledShutdownResponseData.class);
        requestClasses.put(ApiKeys.CONTROLLER_REGISTRATION, ControllerRegistrationRequestData.class);
        responseClasses.put(ApiKeys.CONTROLLER_REGISTRATION, ControllerRegistrationResponseData.class);
        requestClasses.put(ApiKeys.CREATE_ACLS, CreateAclsRequestData.class);
        responseClasses.put(ApiKeys.CREATE_ACLS, CreateAclsResponseData.class);
        requestClasses.put(ApiKeys.CREATE_DELEGATION_TOKEN, CreateDelegationTokenRequestData.class);
        responseClasses.put(ApiKeys.CREATE_DELEGATION_TOKEN, CreateDelegationTokenResponseData.class);
        requestClasses.put(ApiKeys.CREATE_PARTITIONS, CreatePartitionsRequestData.class);
        responseClasses.put(ApiKeys.CREATE_PARTITIONS, CreatePartitionsResponseData.class);
        requestClasses.put(ApiKeys.CREATE_TOPICS, CreateTopicsRequestData.class);
        responseClasses.put(ApiKeys.CREATE_TOPICS, CreateTopicsResponseData.class);
        requestClasses.put(ApiKeys.DELETE_ACLS, DeleteAclsRequestData.class);
        responseClasses.put(ApiKeys.DELETE_ACLS, DeleteAclsResponseData.class);
        requestClasses.put(ApiKeys.DELETE_GROUPS, DeleteGroupsRequestData.class);
        responseClasses.put(ApiKeys.DELETE_GROUPS, DeleteGroupsResponseData.class);
        requestClasses.put(ApiKeys.DELETE_RECORDS, DeleteRecordsRequestData.class);
        responseClasses.put(ApiKeys.DELETE_RECORDS, DeleteRecordsResponseData.class);
        requestClasses.put(ApiKeys.DELETE_SHARE_GROUP_STATE, DeleteShareGroupStateRequestData.class);
        responseClasses.put(ApiKeys.DELETE_SHARE_GROUP_STATE, DeleteShareGroupStateResponseData.class);
        requestClasses.put(ApiKeys.DELETE_TOPICS, DeleteTopicsRequestData.class);
        responseClasses.put(ApiKeys.DELETE_TOPICS, DeleteTopicsResponseData.class);
        requestClasses.put(ApiKeys.DESCRIBE_ACLS, DescribeAclsRequestData.class);
        responseClasses.put(ApiKeys.DESCRIBE_ACLS, DescribeAclsResponseData.class);
        requestClasses.put(ApiKeys.DESCRIBE_CLIENT_QUOTAS, DescribeClientQuotasRequestData.class);
        responseClasses.put(ApiKeys.DESCRIBE_CLIENT_QUOTAS, DescribeClientQuotasResponseData.class);
        requestClasses.put(ApiKeys.DESCRIBE_CLUSTER, DescribeClusterRequestData.class);
        responseClasses.put(ApiKeys.DESCRIBE_CLUSTER, DescribeClusterResponseData.class);
        requestClasses.put(ApiKeys.DESCRIBE_CONFIGS, DescribeConfigsRequestData.class);
        responseClasses.put(ApiKeys.DESCRIBE_CONFIGS, DescribeConfigsResponseData.class);
        requestClasses.put(ApiKeys.DESCRIBE_DELEGATION_TOKEN, DescribeDelegationTokenRequestData.class);
        responseClasses.put(ApiKeys.DESCRIBE_DELEGATION_TOKEN, DescribeDelegationTokenResponseData.class);
        requestClasses.put(ApiKeys.DESCRIBE_GROUPS, DescribeGroupsRequestData.class);
        responseClasses.put(ApiKeys.DESCRIBE_GROUPS, DescribeGroupsResponseData.class);
        requestClasses.put(ApiKeys.DESCRIBE_LOG_DIRS, DescribeLogDirsRequestData.class);
        responseClasses.put(ApiKeys.DESCRIBE_LOG_DIRS, DescribeLogDirsResponseData.class);
        requestClasses.put(ApiKeys.DESCRIBE_PRODUCERS, DescribeProducersRequestData.class);
        responseClasses.put(ApiKeys.DESCRIBE_PRODUCERS, DescribeProducersResponseData.class);
        requestClasses.put(ApiKeys.DESCRIBE_QUORUM, DescribeQuorumRequestData.class);
        responseClasses.put(ApiKeys.DESCRIBE_QUORUM, DescribeQuorumResponseData.class);
        requestClasses.put(ApiKeys.DESCRIBE_TOPIC_PARTITIONS, DescribeTopicPartitionsRequestData.class);
        responseClasses.put(ApiKeys.DESCRIBE_TOPIC_PARTITIONS, DescribeTopicPartitionsResponseData.class);
        requestClasses.put(ApiKeys.DESCRIBE_TRANSACTIONS, DescribeTransactionsRequestData.class);
        responseClasses.put(ApiKeys.DESCRIBE_TRANSACTIONS, DescribeTransactionsResponseData.class);
        requestClasses.put(ApiKeys.DESCRIBE_USER_SCRAM_CREDENTIALS, DescribeUserScramCredentialsRequestData.class);
        responseClasses.put(ApiKeys.DESCRIBE_USER_SCRAM_CREDENTIALS, DescribeUserScramCredentialsResponseData.class);
        requestClasses.put(ApiKeys.ELECT_LEADERS, ElectLeadersRequestData.class);
        responseClasses.put(ApiKeys.ELECT_LEADERS, ElectLeadersResponseData.class);
        requestClasses.put(ApiKeys.END_QUORUM_EPOCH, EndQuorumEpochRequestData.class);
        responseClasses.put(ApiKeys.END_QUORUM_EPOCH, EndQuorumEpochResponseData.class);
        requestClasses.put(ApiKeys.END_TXN, EndTxnRequestData.class);
        responseClasses.put(ApiKeys.END_TXN, EndTxnResponseData.class);
        requestClasses.put(ApiKeys.ENVELOPE, EnvelopeRequestData.class);
        responseClasses.put(ApiKeys.ENVELOPE, EnvelopeResponseData.class);
        requestClasses.put(ApiKeys.EXPIRE_DELEGATION_TOKEN, ExpireDelegationTokenRequestData.class);
        responseClasses.put(ApiKeys.EXPIRE_DELEGATION_TOKEN, ExpireDelegationTokenResponseData.class);
        requestClasses.put(ApiKeys.FETCH, FetchRequestData.class);
        responseClasses.put(ApiKeys.FETCH, FetchResponseData.class);
        requestClasses.put(ApiKeys.FETCH_SNAPSHOT, FetchSnapshotRequestData.class);
        responseClasses.put(ApiKeys.FETCH_SNAPSHOT, FetchSnapshotResponseData.class);
        requestClasses.put(ApiKeys.FIND_COORDINATOR, FindCoordinatorRequestData.class);
        responseClasses.put(ApiKeys.FIND_COORDINATOR, FindCoordinatorResponseData.class);
        requestClasses.put(ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS, GetTelemetrySubscriptionsRequestData.class);
        responseClasses.put(ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS, GetTelemetrySubscriptionsResponseData.class);
        requestClasses.put(ApiKeys.HEARTBEAT, HeartbeatRequestData.class);
        responseClasses.put(ApiKeys.HEARTBEAT, HeartbeatResponseData.class);
        requestClasses.put(ApiKeys.INCREMENTAL_ALTER_CONFIGS, IncrementalAlterConfigsRequestData.class);
        responseClasses.put(ApiKeys.INCREMENTAL_ALTER_CONFIGS, IncrementalAlterConfigsResponseData.class);
        requestClasses.put(ApiKeys.INIT_PRODUCER_ID, InitProducerIdRequestData.class);
        responseClasses.put(ApiKeys.INIT_PRODUCER_ID, InitProducerIdResponseData.class);
        requestClasses.put(ApiKeys.INITIALIZE_SHARE_GROUP_STATE, InitializeShareGroupStateRequestData.class);
        responseClasses.put(ApiKeys.INITIALIZE_SHARE_GROUP_STATE, InitializeShareGroupStateResponseData.class);
        requestClasses.put(ApiKeys.JOIN_GROUP, JoinGroupRequestData.class);
        responseClasses.put(ApiKeys.JOIN_GROUP, JoinGroupResponseData.class);
        requestClasses.put(ApiKeys.LEADER_AND_ISR, LeaderAndIsrRequestData.class);
        responseClasses.put(ApiKeys.LEADER_AND_ISR, LeaderAndIsrResponseData.class);
        requestClasses.put(ApiKeys.LEAVE_GROUP, LeaveGroupRequestData.class);
        responseClasses.put(ApiKeys.LEAVE_GROUP, LeaveGroupResponseData.class);
        requestClasses.put(ApiKeys.LIST_CLIENT_METRICS_RESOURCES, ListClientMetricsResourcesRequestData.class);
        responseClasses.put(ApiKeys.LIST_CLIENT_METRICS_RESOURCES, ListClientMetricsResourcesResponseData.class);
        requestClasses.put(ApiKeys.LIST_GROUPS, ListGroupsRequestData.class);
        responseClasses.put(ApiKeys.LIST_GROUPS, ListGroupsResponseData.class);
        requestClasses.put(ApiKeys.LIST_OFFSETS, ListOffsetsRequestData.class);
        responseClasses.put(ApiKeys.LIST_OFFSETS, ListOffsetsResponseData.class);
        requestClasses.put(ApiKeys.LIST_PARTITION_REASSIGNMENTS, ListPartitionReassignmentsRequestData.class);
        responseClasses.put(ApiKeys.LIST_PARTITION_REASSIGNMENTS, ListPartitionReassignmentsResponseData.class);
        requestClasses.put(ApiKeys.LIST_TRANSACTIONS, ListTransactionsRequestData.class);
        responseClasses.put(ApiKeys.LIST_TRANSACTIONS, ListTransactionsResponseData.class);
        requestClasses.put(ApiKeys.METADATA, MetadataRequestData.class);
        responseClasses.put(ApiKeys.METADATA, MetadataResponseData.class);
        requestClasses.put(ApiKeys.OFFSET_COMMIT, OffsetCommitRequestData.class);
        responseClasses.put(ApiKeys.OFFSET_COMMIT, OffsetCommitResponseData.class);
        requestClasses.put(ApiKeys.OFFSET_DELETE, OffsetDeleteRequestData.class);
        responseClasses.put(ApiKeys.OFFSET_DELETE, OffsetDeleteResponseData.class);
        requestClasses.put(ApiKeys.OFFSET_FETCH, OffsetFetchRequestData.class);
        responseClasses.put(ApiKeys.OFFSET_FETCH, OffsetFetchResponseData.class);
        requestClasses.put(ApiKeys.OFFSET_FOR_LEADER_EPOCH, OffsetForLeaderEpochRequestData.class);
        responseClasses.put(ApiKeys.OFFSET_FOR_LEADER_EPOCH, OffsetForLeaderEpochResponseData.class);
        requestClasses.put(ApiKeys.PRODUCE, ProduceRequestData.class);
        responseClasses.put(ApiKeys.PRODUCE, ProduceResponseData.class);
        requestClasses.put(ApiKeys.PUSH_TELEMETRY, PushTelemetryRequestData.class);
        responseClasses.put(ApiKeys.PUSH_TELEMETRY, PushTelemetryResponseData.class);
        requestClasses.put(ApiKeys.READ_SHARE_GROUP_STATE, ReadShareGroupStateRequestData.class);
        responseClasses.put(ApiKeys.READ_SHARE_GROUP_STATE, ReadShareGroupStateResponseData.class);
        requestClasses.put(ApiKeys.READ_SHARE_GROUP_STATE_SUMMARY, ReadShareGroupStateSummaryRequestData.class);
        responseClasses.put(ApiKeys.READ_SHARE_GROUP_STATE_SUMMARY, ReadShareGroupStateSummaryResponseData.class);
        requestClasses.put(ApiKeys.REMOVE_RAFT_VOTER, RemoveRaftVoterRequestData.class);
        responseClasses.put(ApiKeys.REMOVE_RAFT_VOTER, RemoveRaftVoterResponseData.class);
        requestClasses.put(ApiKeys.RENEW_DELEGATION_TOKEN, RenewDelegationTokenRequestData.class);
        responseClasses.put(ApiKeys.RENEW_DELEGATION_TOKEN, RenewDelegationTokenResponseData.class);
        requestClasses.put(ApiKeys.SASL_AUTHENTICATE, SaslAuthenticateRequestData.class);
        responseClasses.put(ApiKeys.SASL_AUTHENTICATE, SaslAuthenticateResponseData.class);
        requestClasses.put(ApiKeys.SASL_HANDSHAKE, SaslHandshakeRequestData.class);
        responseClasses.put(ApiKeys.SASL_HANDSHAKE, SaslHandshakeResponseData.class);
        requestClasses.put(ApiKeys.SHARE_ACKNOWLEDGE, ShareAcknowledgeRequestData.class);
        responseClasses.put(ApiKeys.SHARE_ACKNOWLEDGE, ShareAcknowledgeResponseData.class);
        requestClasses.put(ApiKeys.SHARE_FETCH, ShareFetchRequestData.class);
        responseClasses.put(ApiKeys.SHARE_FETCH, ShareFetchResponseData.class);
        requestClasses.put(ApiKeys.SHARE_GROUP_DESCRIBE, ShareGroupDescribeRequestData.class);
        responseClasses.put(ApiKeys.SHARE_GROUP_DESCRIBE, ShareGroupDescribeResponseData.class);
        requestClasses.put(ApiKeys.SHARE_GROUP_HEARTBEAT, ShareGroupHeartbeatRequestData.class);
        responseClasses.put(ApiKeys.SHARE_GROUP_HEARTBEAT, ShareGroupHeartbeatResponseData.class);
        requestClasses.put(ApiKeys.STOP_REPLICA, StopReplicaRequestData.class);
        responseClasses.put(ApiKeys.STOP_REPLICA, StopReplicaResponseData.class);
        requestClasses.put(ApiKeys.SYNC_GROUP, SyncGroupRequestData.class);
        responseClasses.put(ApiKeys.SYNC_GROUP, SyncGroupResponseData.class);
        requestClasses.put(ApiKeys.TXN_OFFSET_COMMIT, TxnOffsetCommitRequestData.class);
        responseClasses.put(ApiKeys.TXN_OFFSET_COMMIT, TxnOffsetCommitResponseData.class);
        requestClasses.put(ApiKeys.UNREGISTER_BROKER, UnregisterBrokerRequestData.class);
        responseClasses.put(ApiKeys.UNREGISTER_BROKER, UnregisterBrokerResponseData.class);
        requestClasses.put(ApiKeys.UPDATE_FEATURES, UpdateFeaturesRequestData.class);
        responseClasses.put(ApiKeys.UPDATE_FEATURES, UpdateFeaturesResponseData.class);
        requestClasses.put(ApiKeys.UPDATE_METADATA, UpdateMetadataRequestData.class);
        responseClasses.put(ApiKeys.UPDATE_METADATA, UpdateMetadataResponseData.class);
        requestClasses.put(ApiKeys.UPDATE_RAFT_VOTER, UpdateRaftVoterRequestData.class);
        responseClasses.put(ApiKeys.UPDATE_RAFT_VOTER, UpdateRaftVoterResponseData.class);
        requestClasses.put(ApiKeys.VOTE, VoteRequestData.class);
        responseClasses.put(ApiKeys.VOTE, VoteResponseData.class);
        requestClasses.put(ApiKeys.WRITE_SHARE_GROUP_STATE, WriteShareGroupStateRequestData.class);
        responseClasses.put(ApiKeys.WRITE_SHARE_GROUP_STATE, WriteShareGroupStateResponseData.class);
        requestClasses.put(ApiKeys.WRITE_TXN_MARKERS, WriteTxnMarkersRequestData.class);
        responseClasses.put(ApiKeys.WRITE_TXN_MARKERS, WriteTxnMarkersResponseData.class);
    }

    /**
    * Get the ApiMessage class per ApiKey for request messages
    * @return ApiKeys to ApiMessage class mappings
    */
    public static Map<ApiKeys, Class<? extends ApiMessage>> getRequestClasses() {
        return Collections.unmodifiableMap(requestClasses);
    }

    /**
    * Get the ApiMessage class per ApiKey for response messages
    * @return ApiKeys to ApiMessage class mappings
    */
    public static Map<ApiKeys, Class<? extends ApiMessage>> getResponseClasses() {
        return Collections.unmodifiableMap(responseClasses);
    }
}
