package io.kroxylicious.proxy.config.tls;

import io.kroxylicious.proxy.config.secret.InlinePasswordFluent;
import io.kroxylicious.proxy.config.model.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.SuppressWarnings;
import io.kroxylicious.proxy.config.model.Nested;
import io.kroxylicious.proxy.config.secret.InlinePassword;
import java.lang.String;
import io.kroxylicious.proxy.config.secret.FilePassword;
import io.kroxylicious.proxy.config.model.BaseFluent;
import io.kroxylicious.proxy.config.secret.FilePasswordFluent;
import io.kroxylicious.proxy.config.secret.PasswordProvider;
import io.kroxylicious.proxy.config.secret.InlinePasswordBuilder;
import java.lang.Object;
import io.kroxylicious.proxy.config.secret.FilePasswordBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TrustStoreFluent<A extends TrustStoreFluent<A>> extends BaseFluent<A>{
  public TrustStoreFluent() {
  }
  
  public TrustStoreFluent(TrustStore instance) {
    this.copyInstance(instance);
  }
  private String storeFile;
  private VisitableBuilder<? extends PasswordProvider,?> storePasswordProvider;
  private String storeType;
  private VisitableBuilder<? extends TrustOptions,?> trustOptions;
  
  protected void copyInstance(TrustStore instance) {
    if (instance != null) {
          this.withStoreFile(instance.storeFile());
          this.withStorePasswordProvider(instance.storePasswordProvider());
          this.withStoreType(instance.storeType());
          this.withTrustOptions(instance.trustOptions());
        }
  }
  
  public String getStoreFile() {
    return this.storeFile;
  }
  
  public A withStoreFile(String storeFile) {
    this.storeFile = storeFile;
    return (A) this;
  }
  
  public boolean hasStoreFile() {
    return this.storeFile != null;
  }
  
  public PasswordProvider buildStorePasswordProvider() {
    return this.storePasswordProvider != null ? this.storePasswordProvider.build() : null;
  }
  
  public A withStorePasswordProvider(PasswordProvider storePasswordProvider) {
    if (storePasswordProvider == null) {
        this.storePasswordProvider = null;
        this._visitables.remove("storePasswordProvider");
        return (A) this;
    } else {
        VisitableBuilder<? extends PasswordProvider,?> builder = builder(storePasswordProvider);;
        this._visitables.get("storePasswordProvider").clear();
        this._visitables.get("storePasswordProvider").add(builder);
        this.storePasswordProvider = builder;
        return (A) this;
    }
  }
  
  public boolean hasStorePasswordProvider() {
    return this.storePasswordProvider != null;
  }
  
  public InlinePasswordStoreProviderNested<A> withNewInlinePasswordStoreProvider() {
    return new InlinePasswordStoreProviderNested(null);
  }
  
  public InlinePasswordStoreProviderNested<A> withNewInlinePasswordStoreProviderLike(InlinePassword item) {
    return new InlinePasswordStoreProviderNested(item);
  }
  
  public A withNewInlinePasswordStoreProvider(String password) {
    return (A)withStorePasswordProvider(new InlinePassword(password));
  }
  
  public FilePasswordStoreProviderNested<A> withNewFilePasswordStoreProvider() {
    return new FilePasswordStoreProviderNested(null);
  }
  
  public FilePasswordStoreProviderNested<A> withNewFilePasswordStoreProviderLike(FilePassword item) {
    return new FilePasswordStoreProviderNested(item);
  }
  
  public A withNewFilePasswordStoreProvider(String passwordFile) {
    return (A)withStorePasswordProvider(new FilePassword(passwordFile));
  }
  
  public String getStoreType() {
    return this.storeType;
  }
  
  public A withStoreType(String storeType) {
    this.storeType = storeType;
    return (A) this;
  }
  
  public boolean hasStoreType() {
    return this.storeType != null;
  }
  
  public TrustOptions buildTrustOptions() {
    return this.trustOptions != null ? this.trustOptions.build() : null;
  }
  
  public A withTrustOptions(TrustOptions trustOptions) {
    if (trustOptions == null) {
        this.trustOptions = null;
        this._visitables.remove("trustOptions");
        return (A) this;
    } else {
        VisitableBuilder<? extends TrustOptions,?> builder = builder(trustOptions);;
        this._visitables.get("trustOptions").clear();
        this._visitables.get("trustOptions").add(builder);
        this.trustOptions = builder;
        return (A) this;
    }
  }
  
  public boolean hasTrustOptions() {
    return this.trustOptions != null;
  }
  
  public ServerOptionsTrustNested<A> withNewServerOptionsTrust() {
    return new ServerOptionsTrustNested(null);
  }
  
  public ServerOptionsTrustNested<A> withNewServerOptionsTrustLike(ServerOptions item) {
    return new ServerOptionsTrustNested(item);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TrustStoreFluent that = (TrustStoreFluent) o;
    if (!java.util.Objects.equals(storeFile, that.storeFile)) return false;
    if (!java.util.Objects.equals(storePasswordProvider, that.storePasswordProvider)) return false;
    if (!java.util.Objects.equals(storeType, that.storeType)) return false;
    if (!java.util.Objects.equals(trustOptions, that.trustOptions)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(storeFile,  storePasswordProvider,  storeType,  trustOptions,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (storeFile != null) { sb.append("storeFile:"); sb.append(storeFile + ","); }
    if (storePasswordProvider != null) { sb.append("storePasswordProvider:"); sb.append(storePasswordProvider + ","); }
    if (storeType != null) { sb.append("storeType:"); sb.append(storeType + ","); }
    if (trustOptions != null) { sb.append("trustOptions:"); sb.append(trustOptions); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.kroxylicious.proxy.config.secret."+"InlinePassword": return (VisitableBuilder<T, ?>)new InlinePasswordBuilder((InlinePassword) item);
    case "io.kroxylicious.proxy.config.secret."+"FilePassword": return (VisitableBuilder<T, ?>)new FilePasswordBuilder((FilePassword) item);
    case "io.kroxylicious.proxy.config.tls."+"ServerOptions": return (VisitableBuilder<T, ?>)new ServerOptionsBuilder((ServerOptions) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class InlinePasswordStoreProviderNested<N> extends InlinePasswordFluent<InlinePasswordStoreProviderNested<N>> implements Nested<N>{
    InlinePasswordStoreProviderNested(InlinePassword item) {
      this.builder = new InlinePasswordBuilder(this, item);
    }
    InlinePasswordBuilder builder;
    
    public N and() {
      return (N) TrustStoreFluent.this.withStorePasswordProvider(builder.build());
    }
    
    public N endInlinePasswordStoreProvider() {
      return and();
    }
    
  
  }
  public class FilePasswordStoreProviderNested<N> extends FilePasswordFluent<FilePasswordStoreProviderNested<N>> implements Nested<N>{
    FilePasswordStoreProviderNested(FilePassword item) {
      this.builder = new FilePasswordBuilder(this, item);
    }
    FilePasswordBuilder builder;
    
    public N and() {
      return (N) TrustStoreFluent.this.withStorePasswordProvider(builder.build());
    }
    
    public N endFilePasswordStoreProvider() {
      return and();
    }
    
  
  }
  public class ServerOptionsTrustNested<N> extends ServerOptionsFluent<ServerOptionsTrustNested<N>> implements Nested<N>{
    ServerOptionsTrustNested(ServerOptions item) {
      this.builder = new ServerOptionsBuilder(this, item);
    }
    ServerOptionsBuilder builder;
    
    public N and() {
      return (N) TrustStoreFluent.this.withTrustOptions(builder.build());
    }
    
    public N endServerOptionsTrust() {
      return and();
    }
    
  
  }

}