package io.kroxylicious.proxy.config.tls;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
public class TrustStoreBuilder extends TrustStoreFluent<TrustStoreBuilder> implements VisitableBuilder<TrustStore,TrustStoreBuilder>{
  public TrustStoreBuilder() {
    this.fluent = this;
  }
  
  public TrustStoreBuilder(TrustStoreFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public TrustStoreBuilder(TrustStoreFluent<?> fluent,TrustStore instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TrustStoreBuilder(TrustStore instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TrustStoreFluent<?> fluent;
  
  public TrustStore build() {
    TrustStore buildable = new TrustStore(fluent.getStoreFile(),fluent.buildStorePasswordProvider(),fluent.getStoreType(),fluent.buildTrustOptions());
    return buildable;
  }
  

}