package io.kroxylicious.proxy.config.tls;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.kroxylicious.proxy.config.model.Nested;
import java.lang.String;
import io.kroxylicious.proxy.config.model.BaseFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TlsFluent<A extends TlsFluent<A>> extends BaseFluent<A>{
  public TlsFluent() {
  }
  
  public TlsFluent(Tls instance) {
    this.copyInstance(instance);
  }
  private VisitableBuilder<? extends KeyProvider,?> key;
  private VisitableBuilder<? extends TrustProvider,?> trust;
  private AllowDeny<String> cipherSuites;
  private AllowDeny<String> protocols;
  
  protected void copyInstance(Tls instance) {
    if (instance != null) {
          this.withKey(instance.key());
          this.withTrust(instance.trust());
          this.withCipherSuites(instance.cipherSuites());
          this.withProtocols(instance.protocols());
        }
  }
  
  public KeyProvider buildKey() {
    return this.key != null ? this.key.build() : null;
  }
  
  public A withKey(KeyProvider key) {
    if (key == null) {
        this.key = null;
        this._visitables.remove("key");
        return (A) this;
    } else {
        VisitableBuilder<? extends KeyProvider,?> builder = builder(key);;
        this._visitables.get("key").clear();
        this._visitables.get("key").add(builder);
        this.key = builder;
        return (A) this;
    }
  }
  
  public boolean hasKey() {
    return this.key != null;
  }
  
  public KeyStoreKeyNested<A> withNewKeyStoreKey() {
    return new KeyStoreKeyNested(null);
  }
  
  public KeyStoreKeyNested<A> withNewKeyStoreKeyLike(KeyStore item) {
    return new KeyStoreKeyNested(item);
  }
  
  public KeyPairKeyNested<A> withNewKeyPairKey() {
    return new KeyPairKeyNested(null);
  }
  
  public KeyPairKeyNested<A> withNewKeyPairKeyLike(KeyPair item) {
    return new KeyPairKeyNested(item);
  }
  
  public TrustProvider buildTrust() {
    return this.trust != null ? this.trust.build() : null;
  }
  
  public A withTrust(TrustProvider trust) {
    if (trust == null) {
        this.trust = null;
        this._visitables.remove("trust");
        return (A) this;
    } else {
        VisitableBuilder<? extends TrustProvider,?> builder = builder(trust);;
        this._visitables.get("trust").clear();
        this._visitables.get("trust").add(builder);
        this.trust = builder;
        return (A) this;
    }
  }
  
  public boolean hasTrust() {
    return this.trust != null;
  }
  
  public InsecureTlsTrustNested<A> withNewInsecureTlsTrust() {
    return new InsecureTlsTrustNested(null);
  }
  
  public InsecureTlsTrustNested<A> withNewInsecureTlsTrustLike(InsecureTls item) {
    return new InsecureTlsTrustNested(item);
  }
  
  public A withNewInsecureTlsTrust(boolean insecure) {
    return (A)withTrust(new InsecureTls(insecure));
  }
  
  public TrustStoreTrustNested<A> withNewTrustStoreTrust() {
    return new TrustStoreTrustNested(null);
  }
  
  public TrustStoreTrustNested<A> withNewTrustStoreTrustLike(TrustStore item) {
    return new TrustStoreTrustNested(item);
  }
  
  public AllowDeny<String> getCipherSuites() {
    return this.cipherSuites;
  }
  
  public <T>A withCipherSuites(AllowDeny<String> cipherSuites) {
    this.cipherSuites = cipherSuites;
    return (A) this;
  }
  
  public boolean hasCipherSuites() {
    return this.cipherSuites != null;
  }
  
  public AllowDeny<String> getProtocols() {
    return this.protocols;
  }
  
  public <T>A withProtocols(AllowDeny<String> protocols) {
    this.protocols = protocols;
    return (A) this;
  }
  
  public boolean hasProtocols() {
    return this.protocols != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TlsFluent that = (TlsFluent) o;
    if (!java.util.Objects.equals(key, that.key)) return false;
    if (!java.util.Objects.equals(trust, that.trust)) return false;
    if (!java.util.Objects.equals(cipherSuites, that.cipherSuites)) return false;
    if (!java.util.Objects.equals(protocols, that.protocols)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(key,  trust,  cipherSuites,  protocols,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (key != null) { sb.append("key:"); sb.append(key + ","); }
    if (trust != null) { sb.append("trust:"); sb.append(trust + ","); }
    if (cipherSuites != null) { sb.append("cipherSuites:"); sb.append(cipherSuites + ","); }
    if (protocols != null) { sb.append("protocols:"); sb.append(protocols); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.kroxylicious.proxy.config.tls."+"KeyStore": return (VisitableBuilder<T, ?>)new KeyStoreBuilder((KeyStore) item);
    case "io.kroxylicious.proxy.config.tls."+"KeyPair": return (VisitableBuilder<T, ?>)new KeyPairBuilder((KeyPair) item);
    case "io.kroxylicious.proxy.config.tls."+"InsecureTls": return (VisitableBuilder<T, ?>)new InsecureTlsBuilder((InsecureTls) item);
    case "io.kroxylicious.proxy.config.tls."+"TrustStore": return (VisitableBuilder<T, ?>)new TrustStoreBuilder((TrustStore) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class KeyStoreKeyNested<N> extends KeyStoreFluent<KeyStoreKeyNested<N>> implements Nested<N>{
    KeyStoreKeyNested(KeyStore item) {
      this.builder = new KeyStoreBuilder(this, item);
    }
    KeyStoreBuilder builder;
    
    public N and() {
      return (N) TlsFluent.this.withKey(builder.build());
    }
    
    public N endKeyStoreKey() {
      return and();
    }
    
  
  }
  public class KeyPairKeyNested<N> extends KeyPairFluent<KeyPairKeyNested<N>> implements Nested<N>{
    KeyPairKeyNested(KeyPair item) {
      this.builder = new KeyPairBuilder(this, item);
    }
    KeyPairBuilder builder;
    
    public N and() {
      return (N) TlsFluent.this.withKey(builder.build());
    }
    
    public N endKeyPairKey() {
      return and();
    }
    
  
  }
  public class InsecureTlsTrustNested<N> extends InsecureTlsFluent<InsecureTlsTrustNested<N>> implements Nested<N>{
    InsecureTlsTrustNested(InsecureTls item) {
      this.builder = new InsecureTlsBuilder(this, item);
    }
    InsecureTlsBuilder builder;
    
    public N and() {
      return (N) TlsFluent.this.withTrust(builder.build());
    }
    
    public N endInsecureTlsTrust() {
      return and();
    }
    
  
  }
  public class TrustStoreTrustNested<N> extends TrustStoreFluent<TrustStoreTrustNested<N>> implements Nested<N>{
    TrustStoreTrustNested(TrustStore item) {
      this.builder = new TrustStoreBuilder(this, item);
    }
    TrustStoreBuilder builder;
    
    public N and() {
      return (N) TlsFluent.this.withTrust(builder.build());
    }
    
    public N endTrustStoreTrust() {
      return and();
    }
    
  
  }

}