package io.kroxylicious.proxy.config.tls;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
public class TlsBuilder extends TlsFluent<TlsBuilder> implements VisitableBuilder<Tls,TlsBuilder>{
  public TlsBuilder() {
    this.fluent = this;
  }
  
  public TlsBuilder(TlsFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public TlsBuilder(TlsFluent<?> fluent,Tls instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TlsBuilder(Tls instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TlsFluent<?> fluent;
  
  public Tls build() {
    Tls buildable = new Tls(fluent.buildKey(),fluent.buildTrust(),fluent.getCipherSuites(),fluent.getProtocols());
    return buildable;
  }
  

}