package io.kroxylicious.proxy.config.tls;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
public class ServerOptionsBuilder extends ServerOptionsFluent<ServerOptionsBuilder> implements VisitableBuilder<ServerOptions,ServerOptionsBuilder>{
  public ServerOptionsBuilder() {
    this.fluent = this;
  }
  
  public ServerOptionsBuilder(ServerOptionsFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public ServerOptionsBuilder(ServerOptionsFluent<?> fluent,ServerOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServerOptionsBuilder(ServerOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServerOptionsFluent<?> fluent;
  
  public ServerOptions build() {
    ServerOptions buildable = new ServerOptions(fluent.getClientAuth());
    return buildable;
  }
  

}