package io.kroxylicious.proxy.config.tls;

import io.kroxylicious.proxy.config.secret.InlinePasswordFluent;
import io.kroxylicious.proxy.config.model.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.SuppressWarnings;
import io.kroxylicious.proxy.config.model.Nested;
import io.kroxylicious.proxy.config.secret.InlinePassword;
import java.lang.String;
import io.kroxylicious.proxy.config.secret.PasswordProvider;
import io.kroxylicious.proxy.config.secret.FilePassword;
import io.kroxylicious.proxy.config.model.BaseFluent;
import io.kroxylicious.proxy.config.secret.InlinePasswordBuilder;
import io.kroxylicious.proxy.config.secret.FilePasswordFluent;
import java.lang.Object;
import io.kroxylicious.proxy.config.secret.FilePasswordBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KeyStoreFluent<A extends KeyStoreFluent<A>> extends BaseFluent<A>{
  public KeyStoreFluent() {
  }
  
  public KeyStoreFluent(KeyStore instance) {
    this.copyInstance(instance);
  }
  private String storeFile;
  private VisitableBuilder<? extends PasswordProvider,?> storePasswordProvider;
  private VisitableBuilder<? extends PasswordProvider,?> keyPasswordProvider;
  private String storeType;
  
  protected void copyInstance(KeyStore instance) {
    if (instance != null) {
          this.withStoreFile(instance.storeFile());
          this.withStorePasswordProvider(instance.storePasswordProvider());
          this.withKeyPasswordProvider(instance.keyPasswordProvider());
          this.withStoreType(instance.storeType());
        }
  }
  
  public String getStoreFile() {
    return this.storeFile;
  }
  
  public A withStoreFile(String storeFile) {
    this.storeFile = storeFile;
    return (A) this;
  }
  
  public boolean hasStoreFile() {
    return this.storeFile != null;
  }
  
  public PasswordProvider buildStorePasswordProvider() {
    return this.storePasswordProvider != null ? this.storePasswordProvider.build() : null;
  }
  
  public A withStorePasswordProvider(PasswordProvider storePasswordProvider) {
    if (storePasswordProvider == null) {
        this.storePasswordProvider = null;
        this._visitables.remove("storePasswordProvider");
        return (A) this;
    } else {
        VisitableBuilder<? extends PasswordProvider,?> builder = builder(storePasswordProvider);;
        this._visitables.get("storePasswordProvider").clear();
        this._visitables.get("storePasswordProvider").add(builder);
        this.storePasswordProvider = builder;
        return (A) this;
    }
  }
  
  public boolean hasStorePasswordProvider() {
    return this.storePasswordProvider != null;
  }
  
  public InlinePasswordStoreProviderNested<A> withNewInlinePasswordStoreProvider() {
    return new InlinePasswordStoreProviderNested(null);
  }
  
  public InlinePasswordStoreProviderNested<A> withNewInlinePasswordStoreProviderLike(InlinePassword item) {
    return new InlinePasswordStoreProviderNested(item);
  }
  
  public A withNewInlinePasswordStoreProvider(String password) {
    return (A)withStorePasswordProvider(new InlinePassword(password));
  }
  
  public FilePasswordStoreProviderNested<A> withNewFilePasswordStoreProvider() {
    return new FilePasswordStoreProviderNested(null);
  }
  
  public FilePasswordStoreProviderNested<A> withNewFilePasswordStoreProviderLike(FilePassword item) {
    return new FilePasswordStoreProviderNested(item);
  }
  
  public A withNewFilePasswordStoreProvider(String passwordFile) {
    return (A)withStorePasswordProvider(new FilePassword(passwordFile));
  }
  
  public PasswordProvider buildKeyPasswordProvider() {
    return this.keyPasswordProvider != null ? this.keyPasswordProvider.build() : null;
  }
  
  public A withKeyPasswordProvider(PasswordProvider keyPasswordProvider) {
    if (keyPasswordProvider == null) {
        this.keyPasswordProvider = null;
        this._visitables.remove("keyPasswordProvider");
        return (A) this;
    } else {
        VisitableBuilder<? extends PasswordProvider,?> builder = builder(keyPasswordProvider);;
        this._visitables.get("keyPasswordProvider").clear();
        this._visitables.get("keyPasswordProvider").add(builder);
        this.keyPasswordProvider = builder;
        return (A) this;
    }
  }
  
  public boolean hasKeyPasswordProvider() {
    return this.keyPasswordProvider != null;
  }
  
  public InlinePasswordKeyProviderNested<A> withNewInlinePasswordKeyProvider() {
    return new InlinePasswordKeyProviderNested(null);
  }
  
  public InlinePasswordKeyProviderNested<A> withNewInlinePasswordKeyProviderLike(InlinePassword item) {
    return new InlinePasswordKeyProviderNested(item);
  }
  
  public A withNewInlinePasswordKeyProvider(String password) {
    return (A)withKeyPasswordProvider(new InlinePassword(password));
  }
  
  public FilePasswordKeyProviderNested<A> withNewFilePasswordKeyProvider() {
    return new FilePasswordKeyProviderNested(null);
  }
  
  public FilePasswordKeyProviderNested<A> withNewFilePasswordKeyProviderLike(FilePassword item) {
    return new FilePasswordKeyProviderNested(item);
  }
  
  public A withNewFilePasswordKeyProvider(String passwordFile) {
    return (A)withKeyPasswordProvider(new FilePassword(passwordFile));
  }
  
  public String getStoreType() {
    return this.storeType;
  }
  
  public A withStoreType(String storeType) {
    this.storeType = storeType;
    return (A) this;
  }
  
  public boolean hasStoreType() {
    return this.storeType != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KeyStoreFluent that = (KeyStoreFluent) o;
    if (!java.util.Objects.equals(storeFile, that.storeFile)) return false;
    if (!java.util.Objects.equals(storePasswordProvider, that.storePasswordProvider)) return false;
    if (!java.util.Objects.equals(keyPasswordProvider, that.keyPasswordProvider)) return false;
    if (!java.util.Objects.equals(storeType, that.storeType)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(storeFile,  storePasswordProvider,  keyPasswordProvider,  storeType,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (storeFile != null) { sb.append("storeFile:"); sb.append(storeFile + ","); }
    if (storePasswordProvider != null) { sb.append("storePasswordProvider:"); sb.append(storePasswordProvider + ","); }
    if (keyPasswordProvider != null) { sb.append("keyPasswordProvider:"); sb.append(keyPasswordProvider + ","); }
    if (storeType != null) { sb.append("storeType:"); sb.append(storeType); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.kroxylicious.proxy.config.secret."+"InlinePassword": return (VisitableBuilder<T, ?>)new InlinePasswordBuilder((InlinePassword) item);
    case "io.kroxylicious.proxy.config.secret."+"FilePassword": return (VisitableBuilder<T, ?>)new FilePasswordBuilder((FilePassword) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class InlinePasswordStoreProviderNested<N> extends InlinePasswordFluent<InlinePasswordStoreProviderNested<N>> implements Nested<N>{
    InlinePasswordStoreProviderNested(InlinePassword item) {
      this.builder = new InlinePasswordBuilder(this, item);
    }
    InlinePasswordBuilder builder;
    
    public N and() {
      return (N) KeyStoreFluent.this.withStorePasswordProvider(builder.build());
    }
    
    public N endInlinePasswordStoreProvider() {
      return and();
    }
    
  
  }
  public class FilePasswordStoreProviderNested<N> extends FilePasswordFluent<FilePasswordStoreProviderNested<N>> implements Nested<N>{
    FilePasswordStoreProviderNested(FilePassword item) {
      this.builder = new FilePasswordBuilder(this, item);
    }
    FilePasswordBuilder builder;
    
    public N and() {
      return (N) KeyStoreFluent.this.withStorePasswordProvider(builder.build());
    }
    
    public N endFilePasswordStoreProvider() {
      return and();
    }
    
  
  }
  public class InlinePasswordKeyProviderNested<N> extends InlinePasswordFluent<InlinePasswordKeyProviderNested<N>> implements Nested<N>{
    InlinePasswordKeyProviderNested(InlinePassword item) {
      this.builder = new InlinePasswordBuilder(this, item);
    }
    InlinePasswordBuilder builder;
    
    public N and() {
      return (N) KeyStoreFluent.this.withKeyPasswordProvider(builder.build());
    }
    
    public N endInlinePasswordKeyProvider() {
      return and();
    }
    
  
  }
  public class FilePasswordKeyProviderNested<N> extends FilePasswordFluent<FilePasswordKeyProviderNested<N>> implements Nested<N>{
    FilePasswordKeyProviderNested(FilePassword item) {
      this.builder = new FilePasswordBuilder(this, item);
    }
    FilePasswordBuilder builder;
    
    public N and() {
      return (N) KeyStoreFluent.this.withKeyPasswordProvider(builder.build());
    }
    
    public N endFilePasswordKeyProvider() {
      return and();
    }
    
  
  }

}