package io.kroxylicious.proxy.config.tls;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
public class KeyStoreBuilder extends KeyStoreFluent<KeyStoreBuilder> implements VisitableBuilder<KeyStore,KeyStoreBuilder>{
  public KeyStoreBuilder() {
    this.fluent = this;
  }
  
  public KeyStoreBuilder(KeyStoreFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public KeyStoreBuilder(KeyStoreFluent<?> fluent,KeyStore instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KeyStoreBuilder(KeyStore instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KeyStoreFluent<?> fluent;
  
  public KeyStore build() {
    KeyStore buildable = new KeyStore(fluent.getStoreFile(),fluent.buildStorePasswordProvider(),fluent.buildKeyPasswordProvider(),fluent.getStoreType());
    return buildable;
  }
  

}