package io.kroxylicious.proxy.config.tls;

import io.kroxylicious.proxy.config.secret.InlinePasswordFluent;
import io.kroxylicious.proxy.config.model.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.SuppressWarnings;
import io.kroxylicious.proxy.config.model.Nested;
import io.kroxylicious.proxy.config.secret.InlinePassword;
import java.lang.String;
import io.kroxylicious.proxy.config.secret.PasswordProvider;
import io.kroxylicious.proxy.config.secret.FilePassword;
import io.kroxylicious.proxy.config.model.BaseFluent;
import io.kroxylicious.proxy.config.secret.InlinePasswordBuilder;
import io.kroxylicious.proxy.config.secret.FilePasswordFluent;
import java.lang.Object;
import io.kroxylicious.proxy.config.secret.FilePasswordBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KeyPairFluent<A extends KeyPairFluent<A>> extends BaseFluent<A>{
  public KeyPairFluent() {
  }
  
  public KeyPairFluent(KeyPair instance) {
    this.copyInstance(instance);
  }
  private String privateKeyFile;
  private String certificateFile;
  private VisitableBuilder<? extends PasswordProvider,?> keyPasswordProvider;
  
  protected void copyInstance(KeyPair instance) {
    if (instance != null) {
          this.withPrivateKeyFile(instance.privateKeyFile());
          this.withCertificateFile(instance.certificateFile());
          this.withKeyPasswordProvider(instance.keyPasswordProvider());
        }
  }
  
  public String getPrivateKeyFile() {
    return this.privateKeyFile;
  }
  
  public A withPrivateKeyFile(String privateKeyFile) {
    this.privateKeyFile = privateKeyFile;
    return (A) this;
  }
  
  public boolean hasPrivateKeyFile() {
    return this.privateKeyFile != null;
  }
  
  public String getCertificateFile() {
    return this.certificateFile;
  }
  
  public A withCertificateFile(String certificateFile) {
    this.certificateFile = certificateFile;
    return (A) this;
  }
  
  public boolean hasCertificateFile() {
    return this.certificateFile != null;
  }
  
  public PasswordProvider buildKeyPasswordProvider() {
    return this.keyPasswordProvider != null ? this.keyPasswordProvider.build() : null;
  }
  
  public A withKeyPasswordProvider(PasswordProvider keyPasswordProvider) {
    if (keyPasswordProvider == null) {
        this.keyPasswordProvider = null;
        this._visitables.remove("keyPasswordProvider");
        return (A) this;
    } else {
        VisitableBuilder<? extends PasswordProvider,?> builder = builder(keyPasswordProvider);;
        this._visitables.get("keyPasswordProvider").clear();
        this._visitables.get("keyPasswordProvider").add(builder);
        this.keyPasswordProvider = builder;
        return (A) this;
    }
  }
  
  public boolean hasKeyPasswordProvider() {
    return this.keyPasswordProvider != null;
  }
  
  public InlinePasswordKeyProviderNested<A> withNewInlinePasswordKeyProvider() {
    return new InlinePasswordKeyProviderNested(null);
  }
  
  public InlinePasswordKeyProviderNested<A> withNewInlinePasswordKeyProviderLike(InlinePassword item) {
    return new InlinePasswordKeyProviderNested(item);
  }
  
  public A withNewInlinePasswordKeyProvider(String password) {
    return (A)withKeyPasswordProvider(new InlinePassword(password));
  }
  
  public FilePasswordKeyProviderNested<A> withNewFilePasswordKeyProvider() {
    return new FilePasswordKeyProviderNested(null);
  }
  
  public FilePasswordKeyProviderNested<A> withNewFilePasswordKeyProviderLike(FilePassword item) {
    return new FilePasswordKeyProviderNested(item);
  }
  
  public A withNewFilePasswordKeyProvider(String passwordFile) {
    return (A)withKeyPasswordProvider(new FilePassword(passwordFile));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KeyPairFluent that = (KeyPairFluent) o;
    if (!java.util.Objects.equals(privateKeyFile, that.privateKeyFile)) return false;
    if (!java.util.Objects.equals(certificateFile, that.certificateFile)) return false;
    if (!java.util.Objects.equals(keyPasswordProvider, that.keyPasswordProvider)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(privateKeyFile,  certificateFile,  keyPasswordProvider,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (privateKeyFile != null) { sb.append("privateKeyFile:"); sb.append(privateKeyFile + ","); }
    if (certificateFile != null) { sb.append("certificateFile:"); sb.append(certificateFile + ","); }
    if (keyPasswordProvider != null) { sb.append("keyPasswordProvider:"); sb.append(keyPasswordProvider); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.kroxylicious.proxy.config.secret."+"InlinePassword": return (VisitableBuilder<T, ?>)new InlinePasswordBuilder((InlinePassword) item);
    case "io.kroxylicious.proxy.config.secret."+"FilePassword": return (VisitableBuilder<T, ?>)new FilePasswordBuilder((FilePassword) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class InlinePasswordKeyProviderNested<N> extends InlinePasswordFluent<InlinePasswordKeyProviderNested<N>> implements Nested<N>{
    InlinePasswordKeyProviderNested(InlinePassword item) {
      this.builder = new InlinePasswordBuilder(this, item);
    }
    InlinePasswordBuilder builder;
    
    public N and() {
      return (N) KeyPairFluent.this.withKeyPasswordProvider(builder.build());
    }
    
    public N endInlinePasswordKeyProvider() {
      return and();
    }
    
  
  }
  public class FilePasswordKeyProviderNested<N> extends FilePasswordFluent<FilePasswordKeyProviderNested<N>> implements Nested<N>{
    FilePasswordKeyProviderNested(FilePassword item) {
      this.builder = new FilePasswordBuilder(this, item);
    }
    FilePasswordBuilder builder;
    
    public N and() {
      return (N) KeyPairFluent.this.withKeyPasswordProvider(builder.build());
    }
    
    public N endFilePasswordKeyProvider() {
      return and();
    }
    
  
  }

}