package io.kroxylicious.proxy.config.tls;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
public class KeyPairBuilder extends KeyPairFluent<KeyPairBuilder> implements VisitableBuilder<KeyPair,KeyPairBuilder>{
  public KeyPairBuilder() {
    this.fluent = this;
  }
  
  public KeyPairBuilder(KeyPairFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public KeyPairBuilder(KeyPairFluent<?> fluent,KeyPair instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KeyPairBuilder(KeyPair instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KeyPairFluent<?> fluent;
  
  public KeyPair build() {
    KeyPair buildable = new KeyPair(fluent.getPrivateKeyFile(),fluent.getCertificateFile(),fluent.buildKeyPasswordProvider());
    return buildable;
  }
  

}