package io.kroxylicious.proxy.config.secret;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
public class FilePasswordBuilder extends FilePasswordFluent<FilePasswordBuilder> implements VisitableBuilder<FilePassword,FilePasswordBuilder>{
  public FilePasswordBuilder() {
    this.fluent = this;
  }
  
  public FilePasswordBuilder(FilePasswordFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public FilePasswordBuilder(FilePasswordFluent<?> fluent,FilePassword instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public FilePasswordBuilder(FilePassword instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  FilePasswordFluent<?> fluent;
  
  public FilePassword build() {
    FilePassword buildable = new FilePassword(fluent.getPasswordFile());
    return buildable;
  }
  

}