package io.kroxylicious.proxy.config.admin;

import java.lang.SuppressWarnings;
import io.kroxylicious.proxy.config.model.Nested;
import java.lang.String;
import java.lang.Integer;
import io.kroxylicious.proxy.config.model.BaseFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ManagementConfigurationFluent<A extends ManagementConfigurationFluent<A>> extends BaseFluent<A>{
  public ManagementConfigurationFluent() {
  }
  
  public ManagementConfigurationFluent(ManagementConfiguration instance) {
    this.copyInstance(instance);
  }
  private String bindAddress;
  private Integer port;
  private EndpointsConfigurationBuilder endpoints;
  
  protected void copyInstance(ManagementConfiguration instance) {
    if (instance != null) {
          this.withBindAddress(instance.bindAddress());
          this.withPort(instance.port());
          this.withEndpoints(instance.endpoints());
        }
  }
  
  public String getBindAddress() {
    return this.bindAddress;
  }
  
  public A withBindAddress(String bindAddress) {
    this.bindAddress = bindAddress;
    return (A) this;
  }
  
  public boolean hasBindAddress() {
    return this.bindAddress != null;
  }
  
  public Integer getPort() {
    return this.port;
  }
  
  public A withPort(Integer port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public EndpointsConfiguration buildEndpoints() {
    return this.endpoints != null ? this.endpoints.build() : null;
  }
  
  public A withEndpoints(EndpointsConfiguration endpoints) {
    this._visitables.remove("endpoints");
    if (endpoints != null) {
        this.endpoints = new EndpointsConfigurationBuilder(endpoints);
        this._visitables.get("endpoints").add(this.endpoints);
    } else {
        this.endpoints = null;
        this._visitables.get("endpoints").remove(this.endpoints);
    }
    return (A) this;
  }
  
  public boolean hasEndpoints() {
    return this.endpoints != null;
  }
  
  public EndpointsNested<A> withNewEndpoints() {
    return new EndpointsNested(null);
  }
  
  public EndpointsNested<A> withNewEndpointsLike(EndpointsConfiguration item) {
    return new EndpointsNested(item);
  }
  
  public EndpointsNested<A> editEndpoints() {
    return withNewEndpointsLike(java.util.Optional.ofNullable(buildEndpoints()).orElse(null));
  }
  
  public EndpointsNested<A> editOrNewEndpoints() {
    return withNewEndpointsLike(java.util.Optional.ofNullable(buildEndpoints()).orElse(new EndpointsConfigurationBuilder().build()));
  }
  
  public EndpointsNested<A> editOrNewEndpointsLike(EndpointsConfiguration item) {
    return withNewEndpointsLike(java.util.Optional.ofNullable(buildEndpoints()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ManagementConfigurationFluent that = (ManagementConfigurationFluent) o;
    if (!java.util.Objects.equals(bindAddress, that.bindAddress)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(endpoints, that.endpoints)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bindAddress,  port,  endpoints,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bindAddress != null) { sb.append("bindAddress:"); sb.append(bindAddress + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (endpoints != null) { sb.append("endpoints:"); sb.append(endpoints); }
    sb.append("}");
    return sb.toString();
  }
  public class EndpointsNested<N> extends EndpointsConfigurationFluent<EndpointsNested<N>> implements Nested<N>{
    EndpointsNested(EndpointsConfiguration item) {
      this.builder = new EndpointsConfigurationBuilder(this, item);
    }
    EndpointsConfigurationBuilder builder;
    
    public N and() {
      return (N) ManagementConfigurationFluent.this.withEndpoints(builder.build());
    }
    
    public N endEndpoints() {
      return and();
    }
    
  
  }

}