package io.kroxylicious.proxy.config;

import java.util.Optional;
import java.lang.SuppressWarnings;
import io.kroxylicious.proxy.config.model.Nested;
import java.lang.String;
import io.kroxylicious.proxy.config.tls.TlsFluent;
import io.kroxylicious.proxy.config.model.BaseFluent;
import io.kroxylicious.proxy.config.tls.Tls;
import java.lang.Object;
import io.kroxylicious.proxy.config.tls.TlsBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VirtualClusterGatewayFluent<A extends VirtualClusterGatewayFluent<A>> extends BaseFluent<A>{
  public VirtualClusterGatewayFluent() {
  }
  
  public VirtualClusterGatewayFluent(VirtualClusterGateway instance) {
    this.copyInstance(instance);
  }
  private String name;
  private PortIdentifiesNodeIdentificationStrategyBuilder portIdentifiesNode;
  private SniHostIdentifiesNodeIdentificationStrategyBuilder sniHostIdentifiesNode;
  private Optional<TlsBuilder> tls =  Optional.empty();
  
  protected void copyInstance(VirtualClusterGateway instance) {
    if (instance != null) {
          this.withName(instance.name());
          this.withPortIdentifiesNode(instance.portIdentifiesNode());
          this.withSniHostIdentifiesNode(instance.sniHostIdentifiesNode());
          this.withTls(instance.tls());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public PortIdentifiesNodeIdentificationStrategy buildPortIdentifiesNode() {
    return this.portIdentifiesNode != null ? this.portIdentifiesNode.build() : null;
  }
  
  public A withPortIdentifiesNode(PortIdentifiesNodeIdentificationStrategy portIdentifiesNode) {
    this._visitables.remove("portIdentifiesNode");
    if (portIdentifiesNode != null) {
        this.portIdentifiesNode = new PortIdentifiesNodeIdentificationStrategyBuilder(portIdentifiesNode);
        this._visitables.get("portIdentifiesNode").add(this.portIdentifiesNode);
    } else {
        this.portIdentifiesNode = null;
        this._visitables.get("portIdentifiesNode").remove(this.portIdentifiesNode);
    }
    return (A) this;
  }
  
  public boolean hasPortIdentifiesNode() {
    return this.portIdentifiesNode != null;
  }
  
  public PortIdentifiesNodeNested<A> withNewPortIdentifiesNode() {
    return new PortIdentifiesNodeNested(null);
  }
  
  public PortIdentifiesNodeNested<A> withNewPortIdentifiesNodeLike(PortIdentifiesNodeIdentificationStrategy item) {
    return new PortIdentifiesNodeNested(item);
  }
  
  public PortIdentifiesNodeNested<A> editPortIdentifiesNode() {
    return withNewPortIdentifiesNodeLike(java.util.Optional.ofNullable(buildPortIdentifiesNode()).orElse(null));
  }
  
  public PortIdentifiesNodeNested<A> editOrNewPortIdentifiesNode() {
    return withNewPortIdentifiesNodeLike(java.util.Optional.ofNullable(buildPortIdentifiesNode()).orElse(new PortIdentifiesNodeIdentificationStrategyBuilder().build()));
  }
  
  public PortIdentifiesNodeNested<A> editOrNewPortIdentifiesNodeLike(PortIdentifiesNodeIdentificationStrategy item) {
    return withNewPortIdentifiesNodeLike(java.util.Optional.ofNullable(buildPortIdentifiesNode()).orElse(item));
  }
  
  public SniHostIdentifiesNodeIdentificationStrategy buildSniHostIdentifiesNode() {
    return this.sniHostIdentifiesNode != null ? this.sniHostIdentifiesNode.build() : null;
  }
  
  public A withSniHostIdentifiesNode(SniHostIdentifiesNodeIdentificationStrategy sniHostIdentifiesNode) {
    this._visitables.remove("sniHostIdentifiesNode");
    if (sniHostIdentifiesNode != null) {
        this.sniHostIdentifiesNode = new SniHostIdentifiesNodeIdentificationStrategyBuilder(sniHostIdentifiesNode);
        this._visitables.get("sniHostIdentifiesNode").add(this.sniHostIdentifiesNode);
    } else {
        this.sniHostIdentifiesNode = null;
        this._visitables.get("sniHostIdentifiesNode").remove(this.sniHostIdentifiesNode);
    }
    return (A) this;
  }
  
  public boolean hasSniHostIdentifiesNode() {
    return this.sniHostIdentifiesNode != null;
  }
  
  public SniHostIdentifiesNodeNested<A> withNewSniHostIdentifiesNode() {
    return new SniHostIdentifiesNodeNested(null);
  }
  
  public SniHostIdentifiesNodeNested<A> withNewSniHostIdentifiesNodeLike(SniHostIdentifiesNodeIdentificationStrategy item) {
    return new SniHostIdentifiesNodeNested(item);
  }
  
  public SniHostIdentifiesNodeNested<A> editSniHostIdentifiesNode() {
    return withNewSniHostIdentifiesNodeLike(java.util.Optional.ofNullable(buildSniHostIdentifiesNode()).orElse(null));
  }
  
  public SniHostIdentifiesNodeNested<A> editOrNewSniHostIdentifiesNode() {
    return withNewSniHostIdentifiesNodeLike(java.util.Optional.ofNullable(buildSniHostIdentifiesNode()).orElse(new SniHostIdentifiesNodeIdentificationStrategyBuilder().build()));
  }
  
  public SniHostIdentifiesNodeNested<A> editOrNewSniHostIdentifiesNodeLike(SniHostIdentifiesNodeIdentificationStrategy item) {
    return withNewSniHostIdentifiesNodeLike(java.util.Optional.ofNullable(buildSniHostIdentifiesNode()).orElse(item));
  }
  
  public A withTls(Optional<Tls> tls) {
    if (tls == null || !tls.isPresent()) {
      this.tls = java.util.Optional.empty();
    } else {
        TlsBuilder b = new TlsBuilder(tls.get());;
        _visitables.get("tls").add(b);
        this.tls = java.util.Optional.of(b);
    }
    return (A) this;
  }
  
  public A withTls(Tls tls) {
    if (tls == null) {
      this.tls = java.util.Optional.empty();
    } else {
        TlsBuilder b = new TlsBuilder(tls);;
        _visitables.get("tls").add(b);
        this.tls = java.util.Optional.of(b);
    }
    return (A) this;
  }
  
  public Optional<Tls> buildTls() {
    return (Optional<Tls>) (this.tls != null && this.tls.isPresent() ? java.util.Optional.of(this.tls.get().build()) : java.util.Optional.empty());
  }
  
  public boolean hasTls() {
    return this.tls != null && this.tls.isPresent();
  }
  
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  
  public TlsNested<A> withNewTlsLike(Tls item) {
    return new TlsNested(item);
  }
  
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).flatMap(java.util.function.Function.identity()).orElse(null));
  }
  
  public <T>TlsNested<?> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).flatMap(java.util.function.Function.identity()).orElse(new TlsBuilder().build()));
  }
  
  public TlsNested<A> editOrNewTlsLike(Tls item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).flatMap(java.util.function.Function.identity()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VirtualClusterGatewayFluent that = (VirtualClusterGatewayFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(portIdentifiesNode, that.portIdentifiesNode)) return false;
    if (!java.util.Objects.equals(sniHostIdentifiesNode, that.sniHostIdentifiesNode)) return false;
    if (!java.util.Objects.equals(tls, that.tls)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  portIdentifiesNode,  sniHostIdentifiesNode,  tls,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (portIdentifiesNode != null) { sb.append("portIdentifiesNode:"); sb.append(portIdentifiesNode + ","); }
    if (sniHostIdentifiesNode != null) { sb.append("sniHostIdentifiesNode:"); sb.append(sniHostIdentifiesNode + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls); }
    sb.append("}");
    return sb.toString();
  }
  public class PortIdentifiesNodeNested<N> extends PortIdentifiesNodeIdentificationStrategyFluent<PortIdentifiesNodeNested<N>> implements Nested<N>{
    PortIdentifiesNodeNested(PortIdentifiesNodeIdentificationStrategy item) {
      this.builder = new PortIdentifiesNodeIdentificationStrategyBuilder(this, item);
    }
    PortIdentifiesNodeIdentificationStrategyBuilder builder;
    
    public N and() {
      return (N) VirtualClusterGatewayFluent.this.withPortIdentifiesNode(builder.build());
    }
    
    public N endPortIdentifiesNode() {
      return and();
    }
    
  
  }
  public class SniHostIdentifiesNodeNested<N> extends SniHostIdentifiesNodeIdentificationStrategyFluent<SniHostIdentifiesNodeNested<N>> implements Nested<N>{
    SniHostIdentifiesNodeNested(SniHostIdentifiesNodeIdentificationStrategy item) {
      this.builder = new SniHostIdentifiesNodeIdentificationStrategyBuilder(this, item);
    }
    SniHostIdentifiesNodeIdentificationStrategyBuilder builder;
    
    public N and() {
      return (N) VirtualClusterGatewayFluent.this.withSniHostIdentifiesNode(builder.build());
    }
    
    public N endSniHostIdentifiesNode() {
      return and();
    }
    
  
  }
  public class TlsNested<N> extends TlsFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(Tls item) {
      this.builder = new TlsBuilder(this, item);
    }
    TlsBuilder builder;
    
    public N and() {
      return (N) VirtualClusterGatewayFluent.this.withTls(builder.build());
    }
    
    public N endTls() {
      return and();
    }
    
  
  }

}