package io.kroxylicious.proxy.config;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
public class VirtualClusterGatewayBuilder extends VirtualClusterGatewayFluent<VirtualClusterGatewayBuilder> implements VisitableBuilder<VirtualClusterGateway,VirtualClusterGatewayBuilder>{
  public VirtualClusterGatewayBuilder() {
    this.fluent = this;
  }
  
  public VirtualClusterGatewayBuilder(VirtualClusterGatewayFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public VirtualClusterGatewayBuilder(VirtualClusterGatewayFluent<?> fluent,VirtualClusterGateway instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VirtualClusterGatewayBuilder(VirtualClusterGateway instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VirtualClusterGatewayFluent<?> fluent;
  
  public VirtualClusterGateway build() {
    VirtualClusterGateway buildable = new VirtualClusterGateway(fluent.getName(),fluent.buildPortIdentifiesNode(),fluent.buildSniHostIdentifiesNode(),fluent.buildTls());
    return buildable;
  }
  

}