package io.kroxylicious.proxy.config;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.kroxylicious.proxy.config.model.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kroxylicious.proxy.plugin.PluginImplConfig;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.kroxylicious.proxy.config.model.BaseFluent;
import java.util.Iterator;
import io.kroxylicious.proxy.config.tls.Tls;
import java.util.List;
import io.kroxylicious.proxy.config.tls.TlsBuilder;
import io.kroxylicious.proxy.service.ClusterNetworkAddressConfigProviderService;
import java.util.Optional;
import io.kroxylicious.proxy.config.tls.TlsFluent;
import java.util.Collection;
import java.lang.Object;
import io.kroxylicious.proxy.plugin.PluginImplName;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VirtualClusterFluent<A extends VirtualClusterFluent<A>> extends BaseFluent<A>{
  public VirtualClusterFluent() {
  }
  
  public VirtualClusterFluent(VirtualCluster instance) {
    this.copyInstance(instance);
  }
  private String name;
  private TargetClusterBuilder targetCluster;
  private ClusterNetworkAddressConfigProviderDefinition clusterNetworkAddressConfigProvider;
  private Optional<TlsBuilder> tls =  Optional.empty();
  private ArrayList<VirtualClusterGatewayBuilder> gateways;
  private boolean logNetwork;
  private boolean logFrames;
  private List<String> filters;
  
  protected void copyInstance(VirtualCluster instance) {
    if (instance != null) {
          this.withName(instance.name());
          this.withTargetCluster(instance.targetCluster());
          this.withClusterNetworkAddressConfigProvider(instance.clusterNetworkAddressConfigProvider());
          this.withTls(instance.tls());
          this.withGateways(instance.gateways());
          this.withLogNetwork(instance.logNetwork());
          this.withLogFrames(instance.logFrames());
          this.withFilters(instance.filters());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public TargetCluster buildTargetCluster() {
    return this.targetCluster != null ? this.targetCluster.build() : null;
  }
  
  public A withTargetCluster(TargetCluster targetCluster) {
    this._visitables.remove("targetCluster");
    if (targetCluster != null) {
        this.targetCluster = new TargetClusterBuilder(targetCluster);
        this._visitables.get("targetCluster").add(this.targetCluster);
    } else {
        this.targetCluster = null;
        this._visitables.get("targetCluster").remove(this.targetCluster);
    }
    return (A) this;
  }
  
  public boolean hasTargetCluster() {
    return this.targetCluster != null;
  }
  
  public TargetClusterNested<A> withNewTargetCluster() {
    return new TargetClusterNested(null);
  }
  
  public TargetClusterNested<A> withNewTargetClusterLike(TargetCluster item) {
    return new TargetClusterNested(item);
  }
  
  public TargetClusterNested<A> editTargetCluster() {
    return withNewTargetClusterLike(java.util.Optional.ofNullable(buildTargetCluster()).orElse(null));
  }
  
  public TargetClusterNested<A> editOrNewTargetCluster() {
    return withNewTargetClusterLike(java.util.Optional.ofNullable(buildTargetCluster()).orElse(new TargetClusterBuilder().build()));
  }
  
  public TargetClusterNested<A> editOrNewTargetClusterLike(TargetCluster item) {
    return withNewTargetClusterLike(java.util.Optional.ofNullable(buildTargetCluster()).orElse(item));
  }
  
  
  /**
   * The field clusterNetworkAddressConfigProvider has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public ClusterNetworkAddressConfigProviderDefinition getClusterNetworkAddressConfigProvider() {
    return this.clusterNetworkAddressConfigProvider;
  }
  
  
  /**
   * The field clusterNetworkAddressConfigProvider has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A withClusterNetworkAddressConfigProvider(ClusterNetworkAddressConfigProviderDefinition clusterNetworkAddressConfigProvider) {
    this.clusterNetworkAddressConfigProvider = clusterNetworkAddressConfigProvider;
    return (A) this;
  }
  
  
  /**
   * The field clusterNetworkAddressConfigProvider has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public boolean hasClusterNetworkAddressConfigProvider() {
    return this.clusterNetworkAddressConfigProvider != null;
  }
  
  
  /**
   * The field clusterNetworkAddressConfigProvider has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A withNewClusterNetworkAddressConfigProvider(String type,Object config) {
    return (A)withClusterNetworkAddressConfigProvider(new ClusterNetworkAddressConfigProviderDefinition(type, config));
  }
  
  
  /**
   * The field tls has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A withTls(Optional<Tls> tls) {
    if (tls == null || !tls.isPresent()) {
      this.tls = java.util.Optional.empty();
    } else {
        TlsBuilder b = new TlsBuilder(tls.get());;
        _visitables.get("tls").add(b);
        this.tls = java.util.Optional.of(b);
    }
    return (A) this;
  }
  
  
  /**
   * The field tls has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A withTls(Tls tls) {
    if (tls == null) {
      this.tls = java.util.Optional.empty();
    } else {
        TlsBuilder b = new TlsBuilder(tls);;
        _visitables.get("tls").add(b);
        this.tls = java.util.Optional.of(b);
    }
    return (A) this;
  }
  
  
  /**
   * The field tls has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public Optional<Tls> buildTls() {
    return (Optional<Tls>) (this.tls != null && this.tls.isPresent() ? java.util.Optional.of(this.tls.get().build()) : java.util.Optional.empty());
  }
  
  
  /**
   * The field tls has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public boolean hasTls() {
    return this.tls != null && this.tls.isPresent();
  }
  
  
  /**
   * The field tls has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  
  
  /**
   * The field tls has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public TlsNested<A> withNewTlsLike(Tls item) {
    return new TlsNested(item);
  }
  
  
  /**
   * The field tls has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).flatMap(java.util.function.Function.identity()).orElse(null));
  }
  
  
  /**
   * The field tls has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public <T>TlsNested<?> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).flatMap(java.util.function.Function.identity()).orElse(new TlsBuilder().build()));
  }
  
  
  /**
   * The field tls has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public TlsNested<A> editOrNewTlsLike(Tls item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).flatMap(java.util.function.Function.identity()).orElse(item));
  }
  
  public A addToGateways(int index,VirtualClusterGateway item) {
    if (this.gateways == null) {this.gateways = new ArrayList<VirtualClusterGatewayBuilder>();}
    VirtualClusterGatewayBuilder builder = new VirtualClusterGatewayBuilder(item);
    if (index < 0 || index >= gateways.size()) {
        _visitables.get("gateways").add(builder);
        gateways.add(builder);
    } else {
        _visitables.get("gateways").add(builder);
        gateways.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToGateways(int index,VirtualClusterGateway item) {
    if (this.gateways == null) {this.gateways = new ArrayList<VirtualClusterGatewayBuilder>();}
    VirtualClusterGatewayBuilder builder = new VirtualClusterGatewayBuilder(item);
    if (index < 0 || index >= gateways.size()) {
        _visitables.get("gateways").add(builder);
        gateways.add(builder);
    } else {
        _visitables.get("gateways").add(builder);
        gateways.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToGateways(io.kroxylicious.proxy.config.VirtualClusterGateway... items) {
    if (this.gateways == null) {this.gateways = new ArrayList<VirtualClusterGatewayBuilder>();}
    for (VirtualClusterGateway item : items) {VirtualClusterGatewayBuilder builder = new VirtualClusterGatewayBuilder(item);_visitables.get("gateways").add(builder);this.gateways.add(builder);} return (A)this;
  }
  
  public A addAllToGateways(Collection<VirtualClusterGateway> items) {
    if (this.gateways == null) {this.gateways = new ArrayList<VirtualClusterGatewayBuilder>();}
    for (VirtualClusterGateway item : items) {VirtualClusterGatewayBuilder builder = new VirtualClusterGatewayBuilder(item);_visitables.get("gateways").add(builder);this.gateways.add(builder);} return (A)this;
  }
  
  public A removeFromGateways(io.kroxylicious.proxy.config.VirtualClusterGateway... items) {
    if (this.gateways == null) return (A)this;
    for (VirtualClusterGateway item : items) {VirtualClusterGatewayBuilder builder = new VirtualClusterGatewayBuilder(item);_visitables.get("gateways").remove(builder); this.gateways.remove(builder);} return (A)this;
  }
  
  public A removeAllFromGateways(Collection<VirtualClusterGateway> items) {
    if (this.gateways == null) return (A)this;
    for (VirtualClusterGateway item : items) {VirtualClusterGatewayBuilder builder = new VirtualClusterGatewayBuilder(item);_visitables.get("gateways").remove(builder); this.gateways.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromGateways(Predicate<VirtualClusterGatewayBuilder> predicate) {
    if (gateways == null) return (A) this;
    final Iterator<VirtualClusterGatewayBuilder> each = gateways.iterator();
    final List visitables = _visitables.get("gateways");
    while (each.hasNext()) {
      VirtualClusterGatewayBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<VirtualClusterGateway> buildGateways() {
    return this.gateways != null ? build(gateways) : null;
  }
  
  public VirtualClusterGateway buildGateway(int index) {
    return this.gateways.get(index).build();
  }
  
  public VirtualClusterGateway buildFirstGateway() {
    return this.gateways.get(0).build();
  }
  
  public VirtualClusterGateway buildLastGateway() {
    return this.gateways.get(gateways.size() - 1).build();
  }
  
  public VirtualClusterGateway buildMatchingGateway(Predicate<VirtualClusterGatewayBuilder> predicate) {
      for (VirtualClusterGatewayBuilder item : gateways) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingGateway(Predicate<VirtualClusterGatewayBuilder> predicate) {
      for (VirtualClusterGatewayBuilder item : gateways) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGateways(List<VirtualClusterGateway> gateways) {
    if (this.gateways != null) {
      this._visitables.get("gateways").clear();
    }
    if (gateways != null) {
        this.gateways = new ArrayList();
        for (VirtualClusterGateway item : gateways) {
          this.addToGateways(item);
        }
    } else {
      this.gateways = null;
    }
    return (A) this;
  }
  
  public A withGateways(io.kroxylicious.proxy.config.VirtualClusterGateway... gateways) {
    if (this.gateways != null) {
        this.gateways.clear();
        _visitables.remove("gateways");
    }
    if (gateways != null) {
      for (VirtualClusterGateway item : gateways) {
        this.addToGateways(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasGateways() {
    return this.gateways != null && !this.gateways.isEmpty();
  }
  
  public GatewaysNested<A> addNewGateway() {
    return new GatewaysNested(-1, null);
  }
  
  public GatewaysNested<A> addNewGatewayLike(VirtualClusterGateway item) {
    return new GatewaysNested(-1, item);
  }
  
  public GatewaysNested<A> setNewGatewayLike(int index,VirtualClusterGateway item) {
    return new GatewaysNested(index, item);
  }
  
  public GatewaysNested<A> editGateway(int index) {
    if (gateways.size() <= index) throw new RuntimeException("Can't edit gateways. Index exceeds size.");
    return setNewGatewayLike(index, buildGateway(index));
  }
  
  public GatewaysNested<A> editFirstGateway() {
    if (gateways.size() == 0) throw new RuntimeException("Can't edit first gateways. The list is empty.");
    return setNewGatewayLike(0, buildGateway(0));
  }
  
  public GatewaysNested<A> editLastGateway() {
    int index = gateways.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last gateways. The list is empty.");
    return setNewGatewayLike(index, buildGateway(index));
  }
  
  public GatewaysNested<A> editMatchingGateway(Predicate<VirtualClusterGatewayBuilder> predicate) {
    int index = -1;
    for (int i=0;i<gateways.size();i++) { 
    if (predicate.test(gateways.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching gateways. No match found.");
    return setNewGatewayLike(index, buildGateway(index));
  }
  
  public boolean isLogNetwork() {
    return this.logNetwork;
  }
  
  public A withLogNetwork(boolean logNetwork) {
    this.logNetwork = logNetwork;
    return (A) this;
  }
  
  public boolean hasLogNetwork() {
    return true;
  }
  
  public boolean isLogFrames() {
    return this.logFrames;
  }
  
  public A withLogFrames(boolean logFrames) {
    this.logFrames = logFrames;
    return (A) this;
  }
  
  public boolean hasLogFrames() {
    return true;
  }
  
  public A addToFilters(int index,String item) {
    if (this.filters == null) {this.filters = new ArrayList<String>();}
    this.filters.add(index, item);
    return (A)this;
  }
  
  public A setToFilters(int index,String item) {
    if (this.filters == null) {this.filters = new ArrayList<String>();}
    this.filters.set(index, item); return (A)this;
  }
  
  public A addToFilters(java.lang.String... items) {
    if (this.filters == null) {this.filters = new ArrayList<String>();}
    for (String item : items) {this.filters.add(item);} return (A)this;
  }
  
  public A addAllToFilters(Collection<String> items) {
    if (this.filters == null) {this.filters = new ArrayList<String>();}
    for (String item : items) {this.filters.add(item);} return (A)this;
  }
  
  public A removeFromFilters(java.lang.String... items) {
    if (this.filters == null) return (A)this;
    for (String item : items) { this.filters.remove(item);} return (A)this;
  }
  
  public A removeAllFromFilters(Collection<String> items) {
    if (this.filters == null) return (A)this;
    for (String item : items) { this.filters.remove(item);} return (A)this;
  }
  
  public List<String> getFilters() {
    return this.filters;
  }
  
  public String getFilter(int index) {
    return this.filters.get(index);
  }
  
  public String getFirstFilter() {
    return this.filters.get(0);
  }
  
  public String getLastFilter() {
    return this.filters.get(filters.size() - 1);
  }
  
  public String getMatchingFilter(Predicate<String> predicate) {
      for (String item : filters) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingFilter(Predicate<String> predicate) {
      for (String item : filters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFilters(List<String> filters) {
    if (filters != null) {
        this.filters = new ArrayList();
        for (String item : filters) {
          this.addToFilters(item);
        }
    } else {
      this.filters = null;
    }
    return (A) this;
  }
  
  public A withFilters(java.lang.String... filters) {
    if (this.filters != null) {
        this.filters.clear();
        _visitables.remove("filters");
    }
    if (filters != null) {
      for (String item : filters) {
        this.addToFilters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFilters() {
    return this.filters != null && !this.filters.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VirtualClusterFluent that = (VirtualClusterFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(targetCluster, that.targetCluster)) return false;
    if (!java.util.Objects.equals(clusterNetworkAddressConfigProvider, that.clusterNetworkAddressConfigProvider)) return false;
    if (!java.util.Objects.equals(tls, that.tls)) return false;
    if (!java.util.Objects.equals(gateways, that.gateways)) return false;
    if (logNetwork != that.logNetwork) return false;
    if (logFrames != that.logFrames) return false;
    if (!java.util.Objects.equals(filters, that.filters)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  targetCluster,  clusterNetworkAddressConfigProvider,  tls,  gateways,  logNetwork,  logFrames,  filters,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (targetCluster != null) { sb.append("targetCluster:"); sb.append(targetCluster + ","); }
    if (clusterNetworkAddressConfigProvider != null) { sb.append("clusterNetworkAddressConfigProvider:"); sb.append(clusterNetworkAddressConfigProvider + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls + ","); }
    if (gateways != null && !gateways.isEmpty()) { sb.append("gateways:"); sb.append(gateways + ","); }
    sb.append("logNetwork:"); sb.append(logNetwork + ",");
    sb.append("logFrames:"); sb.append(logFrames + ",");
    if (filters != null && !filters.isEmpty()) { sb.append("filters:"); sb.append(filters); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withLogNetwork() {
    return withLogNetwork(true);
  }
  
  public A withLogFrames() {
    return withLogFrames(true);
  }
  public class TargetClusterNested<N> extends TargetClusterFluent<TargetClusterNested<N>> implements Nested<N>{
    TargetClusterNested(TargetCluster item) {
      this.builder = new TargetClusterBuilder(this, item);
    }
    TargetClusterBuilder builder;
    
    public N and() {
      return (N) VirtualClusterFluent.this.withTargetCluster(builder.build());
    }
    
    public N endTargetCluster() {
      return and();
    }
    
  
  }
  public class TlsNested<N> extends TlsFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(Tls item) {
      this.builder = new TlsBuilder(this, item);
    }
    TlsBuilder builder;
    
    public N and() {
      return (N) VirtualClusterFluent.this.withTls(builder.build());
    }
    
    public N endTls() {
      return and();
    }
    
  
  }
  public class GatewaysNested<N> extends VirtualClusterGatewayFluent<GatewaysNested<N>> implements Nested<N>{
    GatewaysNested(int index,VirtualClusterGateway item) {
      this.index = index;
      this.builder = new VirtualClusterGatewayBuilder(this, item);
    }
    VirtualClusterGatewayBuilder builder;
    int index;
    
    public N and() {
      return (N) VirtualClusterFluent.this.setToGateways(index,builder.build());
    }
    
    public N endGateway() {
      return and();
    }
    
  
  }

}