package io.kroxylicious.proxy.config;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
public class VirtualClusterBuilder extends VirtualClusterFluent<VirtualClusterBuilder> implements VisitableBuilder<VirtualCluster,VirtualClusterBuilder>{
  public VirtualClusterBuilder() {
    this.fluent = this;
  }
  
  public VirtualClusterBuilder(VirtualClusterFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public VirtualClusterBuilder(VirtualClusterFluent<?> fluent,VirtualCluster instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VirtualClusterBuilder(VirtualCluster instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VirtualClusterFluent<?> fluent;
  
  public VirtualCluster build() {
    VirtualCluster buildable = new VirtualCluster(fluent.getName(),fluent.buildTargetCluster(),fluent.getClusterNetworkAddressConfigProvider(),fluent.buildTls(),fluent.buildGateways(),fluent.isLogNetwork(),fluent.isLogFrames(),fluent.getFilters());
    return buildable;
  }
  

}