package io.kroxylicious.proxy.config;

import java.util.Optional;
import java.lang.SuppressWarnings;
import io.kroxylicious.proxy.config.model.Nested;
import java.lang.String;
import io.kroxylicious.proxy.config.tls.TlsFluent;
import io.kroxylicious.proxy.config.model.BaseFluent;
import io.kroxylicious.proxy.config.tls.Tls;
import java.lang.Object;
import io.kroxylicious.proxy.config.tls.TlsBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TargetClusterFluent<A extends TargetClusterFluent<A>> extends BaseFluent<A>{
  public TargetClusterFluent() {
  }
  
  public TargetClusterFluent(TargetCluster instance) {
    this.copyInstance(instance);
  }
  private String bootstrapServers;
  private Optional<TlsBuilder> tls =  Optional.empty();
  
  protected void copyInstance(TargetCluster instance) {
    if (instance != null) {
          this.withBootstrapServers(instance.bootstrapServers());
          this.withTls(instance.tls());
        }
  }
  
  public String getBootstrapServers() {
    return this.bootstrapServers;
  }
  
  public A withBootstrapServers(String bootstrapServers) {
    this.bootstrapServers = bootstrapServers;
    return (A) this;
  }
  
  public boolean hasBootstrapServers() {
    return this.bootstrapServers != null;
  }
  
  public A withTls(Optional<Tls> tls) {
    if (tls == null || !tls.isPresent()) {
      this.tls = java.util.Optional.empty();
    } else {
        TlsBuilder b = new TlsBuilder(tls.get());;
        _visitables.get("tls").add(b);
        this.tls = java.util.Optional.of(b);
    }
    return (A) this;
  }
  
  public A withTls(Tls tls) {
    if (tls == null) {
      this.tls = java.util.Optional.empty();
    } else {
        TlsBuilder b = new TlsBuilder(tls);;
        _visitables.get("tls").add(b);
        this.tls = java.util.Optional.of(b);
    }
    return (A) this;
  }
  
  public Optional<Tls> buildTls() {
    return (Optional<Tls>) (this.tls != null && this.tls.isPresent() ? java.util.Optional.of(this.tls.get().build()) : java.util.Optional.empty());
  }
  
  public boolean hasTls() {
    return this.tls != null && this.tls.isPresent();
  }
  
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  
  public TlsNested<A> withNewTlsLike(Tls item) {
    return new TlsNested(item);
  }
  
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).flatMap(java.util.function.Function.identity()).orElse(null));
  }
  
  public <T>TlsNested<?> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).flatMap(java.util.function.Function.identity()).orElse(new TlsBuilder().build()));
  }
  
  public TlsNested<A> editOrNewTlsLike(Tls item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).flatMap(java.util.function.Function.identity()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TargetClusterFluent that = (TargetClusterFluent) o;
    if (!java.util.Objects.equals(bootstrapServers, that.bootstrapServers)) return false;
    if (!java.util.Objects.equals(tls, that.tls)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bootstrapServers,  tls,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootstrapServers != null) { sb.append("bootstrapServers:"); sb.append(bootstrapServers + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls); }
    sb.append("}");
    return sb.toString();
  }
  public class TlsNested<N> extends TlsFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(Tls item) {
      this.builder = new TlsBuilder(this, item);
    }
    TlsBuilder builder;
    
    public N and() {
      return (N) TargetClusterFluent.this.withTls(builder.build());
    }
    
    public N endTls() {
      return and();
    }
    
  
  }

}