package io.kroxylicious.proxy.config;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
public class TargetClusterBuilder extends TargetClusterFluent<TargetClusterBuilder> implements VisitableBuilder<TargetCluster,TargetClusterBuilder>{
  public TargetClusterBuilder() {
    this.fluent = this;
  }
  
  public TargetClusterBuilder(TargetClusterFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public TargetClusterBuilder(TargetClusterFluent<?> fluent,TargetCluster instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TargetClusterBuilder(TargetCluster instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TargetClusterFluent<?> fluent;
  
  public TargetCluster build() {
    TargetCluster buildable = new TargetCluster(fluent.getBootstrapServers(),fluent.buildTls());
    return buildable;
  }
  

}