package io.kroxylicious.proxy.config;

import java.lang.SuppressWarnings;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.kroxylicious.proxy.service.HostPort;
import io.kroxylicious.proxy.config.model.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SniHostIdentifiesNodeIdentificationStrategyFluent<A extends SniHostIdentifiesNodeIdentificationStrategyFluent<A>> extends BaseFluent<A>{
  public SniHostIdentifiesNodeIdentificationStrategyFluent() {
  }
  
  public SniHostIdentifiesNodeIdentificationStrategyFluent(SniHostIdentifiesNodeIdentificationStrategy instance) {
    this.copyInstance(instance);
  }
  private HostPort bootstrapAddress;
  private String advertisedBrokerAddressPattern;
  
  protected void copyInstance(SniHostIdentifiesNodeIdentificationStrategy instance) {
    if (instance != null) {
          this.withBootstrapAddress(instance.bootstrapAddress());
          this.withAdvertisedBrokerAddressPattern(instance.advertisedBrokerAddressPattern());
        }
  }
  
  public HostPort getBootstrapAddress() {
    return this.bootstrapAddress;
  }
  
  public A withBootstrapAddress(HostPort bootstrapAddress) {
    this.bootstrapAddress = bootstrapAddress;
    return (A) this;
  }
  
  public boolean hasBootstrapAddress() {
    return this.bootstrapAddress != null;
  }
  
  public A withNewBootstrapAddress(String host,int port) {
    return (A)withBootstrapAddress(new HostPort(host, port));
  }
  
  public String getAdvertisedBrokerAddressPattern() {
    return this.advertisedBrokerAddressPattern;
  }
  
  public A withAdvertisedBrokerAddressPattern(String advertisedBrokerAddressPattern) {
    this.advertisedBrokerAddressPattern = advertisedBrokerAddressPattern;
    return (A) this;
  }
  
  public boolean hasAdvertisedBrokerAddressPattern() {
    return this.advertisedBrokerAddressPattern != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SniHostIdentifiesNodeIdentificationStrategyFluent that = (SniHostIdentifiesNodeIdentificationStrategyFluent) o;
    if (!java.util.Objects.equals(bootstrapAddress, that.bootstrapAddress)) return false;
    if (!java.util.Objects.equals(advertisedBrokerAddressPattern, that.advertisedBrokerAddressPattern)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bootstrapAddress,  advertisedBrokerAddressPattern,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootstrapAddress != null) { sb.append("bootstrapAddress:"); sb.append(bootstrapAddress + ","); }
    if (advertisedBrokerAddressPattern != null) { sb.append("advertisedBrokerAddressPattern:"); sb.append(advertisedBrokerAddressPattern); }
    sb.append("}");
    return sb.toString();
  }
  

}