package io.kroxylicious.proxy.config;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.SuppressWarnings;
import io.kroxylicious.proxy.service.HostPort;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.kroxylicious.proxy.config.model.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.kroxylicious.proxy.config.model.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PortIdentifiesNodeIdentificationStrategyFluent<A extends PortIdentifiesNodeIdentificationStrategyFluent<A>> extends BaseFluent<A>{
  public PortIdentifiesNodeIdentificationStrategyFluent() {
  }
  
  public PortIdentifiesNodeIdentificationStrategyFluent(PortIdentifiesNodeIdentificationStrategy instance) {
    this.copyInstance(instance);
  }
  private HostPort bootstrapAddress;
  private String advertisedBrokerAddressPattern;
  private Integer nodeStartPort;
  private ArrayList<NamedRangeBuilder> nodeIdRanges;
  
  protected void copyInstance(PortIdentifiesNodeIdentificationStrategy instance) {
    if (instance != null) {
          this.withBootstrapAddress(instance.bootstrapAddress());
          this.withAdvertisedBrokerAddressPattern(instance.advertisedBrokerAddressPattern());
          this.withNodeStartPort(instance.nodeStartPort());
          this.withNodeIdRanges(instance.nodeIdRanges());
        }
  }
  
  public HostPort getBootstrapAddress() {
    return this.bootstrapAddress;
  }
  
  public A withBootstrapAddress(HostPort bootstrapAddress) {
    this.bootstrapAddress = bootstrapAddress;
    return (A) this;
  }
  
  public boolean hasBootstrapAddress() {
    return this.bootstrapAddress != null;
  }
  
  public A withNewBootstrapAddress(String host,int port) {
    return (A)withBootstrapAddress(new HostPort(host, port));
  }
  
  public String getAdvertisedBrokerAddressPattern() {
    return this.advertisedBrokerAddressPattern;
  }
  
  public A withAdvertisedBrokerAddressPattern(String advertisedBrokerAddressPattern) {
    this.advertisedBrokerAddressPattern = advertisedBrokerAddressPattern;
    return (A) this;
  }
  
  public boolean hasAdvertisedBrokerAddressPattern() {
    return this.advertisedBrokerAddressPattern != null;
  }
  
  public Integer getNodeStartPort() {
    return this.nodeStartPort;
  }
  
  public A withNodeStartPort(Integer nodeStartPort) {
    this.nodeStartPort = nodeStartPort;
    return (A) this;
  }
  
  public boolean hasNodeStartPort() {
    return this.nodeStartPort != null;
  }
  
  public A addToNodeIdRanges(int index,NamedRange item) {
    if (this.nodeIdRanges == null) {this.nodeIdRanges = new ArrayList<NamedRangeBuilder>();}
    NamedRangeBuilder builder = new NamedRangeBuilder(item);
    if (index < 0 || index >= nodeIdRanges.size()) {
        _visitables.get("nodeIdRanges").add(builder);
        nodeIdRanges.add(builder);
    } else {
        _visitables.get("nodeIdRanges").add(builder);
        nodeIdRanges.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToNodeIdRanges(int index,NamedRange item) {
    if (this.nodeIdRanges == null) {this.nodeIdRanges = new ArrayList<NamedRangeBuilder>();}
    NamedRangeBuilder builder = new NamedRangeBuilder(item);
    if (index < 0 || index >= nodeIdRanges.size()) {
        _visitables.get("nodeIdRanges").add(builder);
        nodeIdRanges.add(builder);
    } else {
        _visitables.get("nodeIdRanges").add(builder);
        nodeIdRanges.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToNodeIdRanges(io.kroxylicious.proxy.config.NamedRange... items) {
    if (this.nodeIdRanges == null) {this.nodeIdRanges = new ArrayList<NamedRangeBuilder>();}
    for (NamedRange item : items) {NamedRangeBuilder builder = new NamedRangeBuilder(item);_visitables.get("nodeIdRanges").add(builder);this.nodeIdRanges.add(builder);} return (A)this;
  }
  
  public A addAllToNodeIdRanges(Collection<NamedRange> items) {
    if (this.nodeIdRanges == null) {this.nodeIdRanges = new ArrayList<NamedRangeBuilder>();}
    for (NamedRange item : items) {NamedRangeBuilder builder = new NamedRangeBuilder(item);_visitables.get("nodeIdRanges").add(builder);this.nodeIdRanges.add(builder);} return (A)this;
  }
  
  public A removeFromNodeIdRanges(io.kroxylicious.proxy.config.NamedRange... items) {
    if (this.nodeIdRanges == null) return (A)this;
    for (NamedRange item : items) {NamedRangeBuilder builder = new NamedRangeBuilder(item);_visitables.get("nodeIdRanges").remove(builder); this.nodeIdRanges.remove(builder);} return (A)this;
  }
  
  public A removeAllFromNodeIdRanges(Collection<NamedRange> items) {
    if (this.nodeIdRanges == null) return (A)this;
    for (NamedRange item : items) {NamedRangeBuilder builder = new NamedRangeBuilder(item);_visitables.get("nodeIdRanges").remove(builder); this.nodeIdRanges.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromNodeIdRanges(Predicate<NamedRangeBuilder> predicate) {
    if (nodeIdRanges == null) return (A) this;
    final Iterator<NamedRangeBuilder> each = nodeIdRanges.iterator();
    final List visitables = _visitables.get("nodeIdRanges");
    while (each.hasNext()) {
      NamedRangeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NamedRange> buildNodeIdRanges() {
    return this.nodeIdRanges != null ? build(nodeIdRanges) : null;
  }
  
  public NamedRange buildNodeIdRange(int index) {
    return this.nodeIdRanges.get(index).build();
  }
  
  public NamedRange buildFirstNodeIdRange() {
    return this.nodeIdRanges.get(0).build();
  }
  
  public NamedRange buildLastNodeIdRange() {
    return this.nodeIdRanges.get(nodeIdRanges.size() - 1).build();
  }
  
  public NamedRange buildMatchingNodeIdRange(Predicate<NamedRangeBuilder> predicate) {
      for (NamedRangeBuilder item : nodeIdRanges) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingNodeIdRange(Predicate<NamedRangeBuilder> predicate) {
      for (NamedRangeBuilder item : nodeIdRanges) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withNodeIdRanges(List<NamedRange> nodeIdRanges) {
    if (this.nodeIdRanges != null) {
      this._visitables.get("nodeIdRanges").clear();
    }
    if (nodeIdRanges != null) {
        this.nodeIdRanges = new ArrayList();
        for (NamedRange item : nodeIdRanges) {
          this.addToNodeIdRanges(item);
        }
    } else {
      this.nodeIdRanges = null;
    }
    return (A) this;
  }
  
  public A withNodeIdRanges(io.kroxylicious.proxy.config.NamedRange... nodeIdRanges) {
    if (this.nodeIdRanges != null) {
        this.nodeIdRanges.clear();
        _visitables.remove("nodeIdRanges");
    }
    if (nodeIdRanges != null) {
      for (NamedRange item : nodeIdRanges) {
        this.addToNodeIdRanges(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasNodeIdRanges() {
    return this.nodeIdRanges != null && !this.nodeIdRanges.isEmpty();
  }
  
  public A addNewNodeIdRange(String name,int start,int end) {
    return (A)addToNodeIdRanges(new NamedRange(name, start, end));
  }
  
  public NodeIdRangesNested<A> addNewNodeIdRange() {
    return new NodeIdRangesNested(-1, null);
  }
  
  public NodeIdRangesNested<A> addNewNodeIdRangeLike(NamedRange item) {
    return new NodeIdRangesNested(-1, item);
  }
  
  public NodeIdRangesNested<A> setNewNodeIdRangeLike(int index,NamedRange item) {
    return new NodeIdRangesNested(index, item);
  }
  
  public NodeIdRangesNested<A> editNodeIdRange(int index) {
    if (nodeIdRanges.size() <= index) throw new RuntimeException("Can't edit nodeIdRanges. Index exceeds size.");
    return setNewNodeIdRangeLike(index, buildNodeIdRange(index));
  }
  
  public NodeIdRangesNested<A> editFirstNodeIdRange() {
    if (nodeIdRanges.size() == 0) throw new RuntimeException("Can't edit first nodeIdRanges. The list is empty.");
    return setNewNodeIdRangeLike(0, buildNodeIdRange(0));
  }
  
  public NodeIdRangesNested<A> editLastNodeIdRange() {
    int index = nodeIdRanges.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last nodeIdRanges. The list is empty.");
    return setNewNodeIdRangeLike(index, buildNodeIdRange(index));
  }
  
  public NodeIdRangesNested<A> editMatchingNodeIdRange(Predicate<NamedRangeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<nodeIdRanges.size();i++) { 
    if (predicate.test(nodeIdRanges.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching nodeIdRanges. No match found.");
    return setNewNodeIdRangeLike(index, buildNodeIdRange(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PortIdentifiesNodeIdentificationStrategyFluent that = (PortIdentifiesNodeIdentificationStrategyFluent) o;
    if (!java.util.Objects.equals(bootstrapAddress, that.bootstrapAddress)) return false;
    if (!java.util.Objects.equals(advertisedBrokerAddressPattern, that.advertisedBrokerAddressPattern)) return false;
    if (!java.util.Objects.equals(nodeStartPort, that.nodeStartPort)) return false;
    if (!java.util.Objects.equals(nodeIdRanges, that.nodeIdRanges)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bootstrapAddress,  advertisedBrokerAddressPattern,  nodeStartPort,  nodeIdRanges,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootstrapAddress != null) { sb.append("bootstrapAddress:"); sb.append(bootstrapAddress + ","); }
    if (advertisedBrokerAddressPattern != null) { sb.append("advertisedBrokerAddressPattern:"); sb.append(advertisedBrokerAddressPattern + ","); }
    if (nodeStartPort != null) { sb.append("nodeStartPort:"); sb.append(nodeStartPort + ","); }
    if (nodeIdRanges != null && !nodeIdRanges.isEmpty()) { sb.append("nodeIdRanges:"); sb.append(nodeIdRanges); }
    sb.append("}");
    return sb.toString();
  }
  public class NodeIdRangesNested<N> extends NamedRangeFluent<NodeIdRangesNested<N>> implements Nested<N>{
    NodeIdRangesNested(int index,NamedRange item) {
      this.index = index;
      this.builder = new NamedRangeBuilder(this, item);
    }
    NamedRangeBuilder builder;
    int index;
    
    public N and() {
      return (N) PortIdentifiesNodeIdentificationStrategyFluent.this.setToNodeIdRanges(index,builder.build());
    }
    
    public N endNodeIdRange() {
      return and();
    }
    
  
  }

}