package io.kroxylicious.proxy.config;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
public class NamedRangeBuilder extends NamedRangeFluent<NamedRangeBuilder> implements VisitableBuilder<NamedRange,NamedRangeBuilder>{
  public NamedRangeBuilder() {
    this.fluent = this;
  }
  
  public NamedRangeBuilder(NamedRangeFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public NamedRangeBuilder(NamedRangeFluent<?> fluent,NamedRange instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NamedRangeBuilder(NamedRange instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NamedRangeFluent<?> fluent;
  
  public NamedRange build() {
    NamedRange buildable = new NamedRange(fluent.getName(),fluent.getStart(),fluent.getEnd());
    return buildable;
  }
  

}