package io.kroxylicious.proxy.config;

import io.kroxylicious.proxy.micrometer.MicrometerConfigurationHookService;
import io.kroxylicious.proxy.config.model.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.SuppressWarnings;
import io.kroxylicious.proxy.config.model.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kroxylicious.proxy.filter.FilterFactory;
import io.kroxylicious.proxy.plugin.PluginImplConfig;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.kroxylicious.proxy.config.model.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.kroxylicious.proxy.config.admin.ManagementConfiguration;
import java.util.Optional;
import io.kroxylicious.proxy.config.admin.ManagementConfigurationBuilder;
import io.kroxylicious.proxy.config.admin.ManagementConfigurationFluent;
import java.util.Collection;
import java.lang.Object;
import io.kroxylicious.proxy.plugin.PluginImplName;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConfigurationFluent<A extends ConfigurationFluent<A>> extends BaseFluent<A>{
  public ConfigurationFluent() {
  }
  
  public ConfigurationFluent(Configuration instance) {
    this.copyInstance(instance);
  }
  private ManagementConfigurationBuilder management;
  private List<NamedFilterDefinition> filterDefinitions;
  private List<String> defaultFilters;
  private ArrayList<VirtualClusterBuilder> virtualClusters;
  private List<FilterDefinition> filters;
  private List<MicrometerDefinition> micrometer;
  private boolean useIoUring;
  private Optional<Map<String,Object>> development = Optional.empty();
  
  protected void copyInstance(Configuration instance) {
    if (instance != null) {
          this.withManagement(instance.management());
          this.withFilterDefinitions(instance.filterDefinitions());
          this.withDefaultFilters(instance.defaultFilters());
          this.withVirtualClusters(instance.virtualClusters());
          this.withFilters(instance.filters());
          this.withMicrometer(instance.getMicrometer());
          this.withUseIoUring(instance.isUseIoUring());
          this.withDevelopment(instance.development());
        }
  }
  
  public ManagementConfiguration buildManagement() {
    return this.management != null ? this.management.build() : null;
  }
  
  public A withManagement(ManagementConfiguration management) {
    this._visitables.remove("management");
    if (management != null) {
        this.management = new ManagementConfigurationBuilder(management);
        this._visitables.get("management").add(this.management);
    } else {
        this.management = null;
        this._visitables.get("management").remove(this.management);
    }
    return (A) this;
  }
  
  public boolean hasManagement() {
    return this.management != null;
  }
  
  public ManagementNested<A> withNewManagement() {
    return new ManagementNested(null);
  }
  
  public ManagementNested<A> withNewManagementLike(ManagementConfiguration item) {
    return new ManagementNested(item);
  }
  
  public ManagementNested<A> editManagement() {
    return withNewManagementLike(java.util.Optional.ofNullable(buildManagement()).orElse(null));
  }
  
  public ManagementNested<A> editOrNewManagement() {
    return withNewManagementLike(java.util.Optional.ofNullable(buildManagement()).orElse(new ManagementConfigurationBuilder().build()));
  }
  
  public ManagementNested<A> editOrNewManagementLike(ManagementConfiguration item) {
    return withNewManagementLike(java.util.Optional.ofNullable(buildManagement()).orElse(item));
  }
  
  public A addToFilterDefinitions(int index,NamedFilterDefinition item) {
    if (this.filterDefinitions == null) {this.filterDefinitions = new ArrayList<NamedFilterDefinition>();}
    this.filterDefinitions.add(index, item);
    return (A)this;
  }
  
  public A setToFilterDefinitions(int index,NamedFilterDefinition item) {
    if (this.filterDefinitions == null) {this.filterDefinitions = new ArrayList<NamedFilterDefinition>();}
    this.filterDefinitions.set(index, item); return (A)this;
  }
  
  public A addToFilterDefinitions(io.kroxylicious.proxy.config.NamedFilterDefinition... items) {
    if (this.filterDefinitions == null) {this.filterDefinitions = new ArrayList<NamedFilterDefinition>();}
    for (NamedFilterDefinition item : items) {this.filterDefinitions.add(item);} return (A)this;
  }
  
  public A addAllToFilterDefinitions(Collection<NamedFilterDefinition> items) {
    if (this.filterDefinitions == null) {this.filterDefinitions = new ArrayList<NamedFilterDefinition>();}
    for (NamedFilterDefinition item : items) {this.filterDefinitions.add(item);} return (A)this;
  }
  
  public A removeFromFilterDefinitions(io.kroxylicious.proxy.config.NamedFilterDefinition... items) {
    if (this.filterDefinitions == null) return (A)this;
    for (NamedFilterDefinition item : items) { this.filterDefinitions.remove(item);} return (A)this;
  }
  
  public A removeAllFromFilterDefinitions(Collection<NamedFilterDefinition> items) {
    if (this.filterDefinitions == null) return (A)this;
    for (NamedFilterDefinition item : items) { this.filterDefinitions.remove(item);} return (A)this;
  }
  
  public List<NamedFilterDefinition> getFilterDefinitions() {
    return this.filterDefinitions;
  }
  
  public NamedFilterDefinition getFilterDefinition(int index) {
    return this.filterDefinitions.get(index);
  }
  
  public NamedFilterDefinition getFirstFilterDefinition() {
    return this.filterDefinitions.get(0);
  }
  
  public NamedFilterDefinition getLastFilterDefinition() {
    return this.filterDefinitions.get(filterDefinitions.size() - 1);
  }
  
  public NamedFilterDefinition getMatchingFilterDefinition(Predicate<NamedFilterDefinition> predicate) {
      for (NamedFilterDefinition item : filterDefinitions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingFilterDefinition(Predicate<NamedFilterDefinition> predicate) {
      for (NamedFilterDefinition item : filterDefinitions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFilterDefinitions(List<NamedFilterDefinition> filterDefinitions) {
    if (filterDefinitions != null) {
        this.filterDefinitions = new ArrayList();
        for (NamedFilterDefinition item : filterDefinitions) {
          this.addToFilterDefinitions(item);
        }
    } else {
      this.filterDefinitions = null;
    }
    return (A) this;
  }
  
  public A withFilterDefinitions(io.kroxylicious.proxy.config.NamedFilterDefinition... filterDefinitions) {
    if (this.filterDefinitions != null) {
        this.filterDefinitions.clear();
        _visitables.remove("filterDefinitions");
    }
    if (filterDefinitions != null) {
      for (NamedFilterDefinition item : filterDefinitions) {
        this.addToFilterDefinitions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFilterDefinitions() {
    return this.filterDefinitions != null && !this.filterDefinitions.isEmpty();
  }
  
  public A addNewFilterDefinition(String name,String type,Object config) {
    return (A)addToFilterDefinitions(new NamedFilterDefinition(name, type, config));
  }
  
  public A addToDefaultFilters(int index,String item) {
    if (this.defaultFilters == null) {this.defaultFilters = new ArrayList<String>();}
    this.defaultFilters.add(index, item);
    return (A)this;
  }
  
  public A setToDefaultFilters(int index,String item) {
    if (this.defaultFilters == null) {this.defaultFilters = new ArrayList<String>();}
    this.defaultFilters.set(index, item); return (A)this;
  }
  
  public A addToDefaultFilters(java.lang.String... items) {
    if (this.defaultFilters == null) {this.defaultFilters = new ArrayList<String>();}
    for (String item : items) {this.defaultFilters.add(item);} return (A)this;
  }
  
  public A addAllToDefaultFilters(Collection<String> items) {
    if (this.defaultFilters == null) {this.defaultFilters = new ArrayList<String>();}
    for (String item : items) {this.defaultFilters.add(item);} return (A)this;
  }
  
  public A removeFromDefaultFilters(java.lang.String... items) {
    if (this.defaultFilters == null) return (A)this;
    for (String item : items) { this.defaultFilters.remove(item);} return (A)this;
  }
  
  public A removeAllFromDefaultFilters(Collection<String> items) {
    if (this.defaultFilters == null) return (A)this;
    for (String item : items) { this.defaultFilters.remove(item);} return (A)this;
  }
  
  public List<String> getDefaultFilters() {
    return this.defaultFilters;
  }
  
  public String getDefaultFilter(int index) {
    return this.defaultFilters.get(index);
  }
  
  public String getFirstDefaultFilter() {
    return this.defaultFilters.get(0);
  }
  
  public String getLastDefaultFilter() {
    return this.defaultFilters.get(defaultFilters.size() - 1);
  }
  
  public String getMatchingDefaultFilter(Predicate<String> predicate) {
      for (String item : defaultFilters) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingDefaultFilter(Predicate<String> predicate) {
      for (String item : defaultFilters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDefaultFilters(List<String> defaultFilters) {
    if (defaultFilters != null) {
        this.defaultFilters = new ArrayList();
        for (String item : defaultFilters) {
          this.addToDefaultFilters(item);
        }
    } else {
      this.defaultFilters = null;
    }
    return (A) this;
  }
  
  public A withDefaultFilters(java.lang.String... defaultFilters) {
    if (this.defaultFilters != null) {
        this.defaultFilters.clear();
        _visitables.remove("defaultFilters");
    }
    if (defaultFilters != null) {
      for (String item : defaultFilters) {
        this.addToDefaultFilters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDefaultFilters() {
    return this.defaultFilters != null && !this.defaultFilters.isEmpty();
  }
  
  public A addToVirtualClusters(int index,VirtualCluster item) {
    if (this.virtualClusters == null) {this.virtualClusters = new ArrayList<VirtualClusterBuilder>();}
    VirtualClusterBuilder builder = new VirtualClusterBuilder(item);
    if (index < 0 || index >= virtualClusters.size()) {
        _visitables.get("virtualClusters").add(builder);
        virtualClusters.add(builder);
    } else {
        _visitables.get("virtualClusters").add(builder);
        virtualClusters.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToVirtualClusters(int index,VirtualCluster item) {
    if (this.virtualClusters == null) {this.virtualClusters = new ArrayList<VirtualClusterBuilder>();}
    VirtualClusterBuilder builder = new VirtualClusterBuilder(item);
    if (index < 0 || index >= virtualClusters.size()) {
        _visitables.get("virtualClusters").add(builder);
        virtualClusters.add(builder);
    } else {
        _visitables.get("virtualClusters").add(builder);
        virtualClusters.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToVirtualClusters(io.kroxylicious.proxy.config.VirtualCluster... items) {
    if (this.virtualClusters == null) {this.virtualClusters = new ArrayList<VirtualClusterBuilder>();}
    for (VirtualCluster item : items) {VirtualClusterBuilder builder = new VirtualClusterBuilder(item);_visitables.get("virtualClusters").add(builder);this.virtualClusters.add(builder);} return (A)this;
  }
  
  public A addAllToVirtualClusters(Collection<VirtualCluster> items) {
    if (this.virtualClusters == null) {this.virtualClusters = new ArrayList<VirtualClusterBuilder>();}
    for (VirtualCluster item : items) {VirtualClusterBuilder builder = new VirtualClusterBuilder(item);_visitables.get("virtualClusters").add(builder);this.virtualClusters.add(builder);} return (A)this;
  }
  
  public A removeFromVirtualClusters(io.kroxylicious.proxy.config.VirtualCluster... items) {
    if (this.virtualClusters == null) return (A)this;
    for (VirtualCluster item : items) {VirtualClusterBuilder builder = new VirtualClusterBuilder(item);_visitables.get("virtualClusters").remove(builder); this.virtualClusters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVirtualClusters(Collection<VirtualCluster> items) {
    if (this.virtualClusters == null) return (A)this;
    for (VirtualCluster item : items) {VirtualClusterBuilder builder = new VirtualClusterBuilder(item);_visitables.get("virtualClusters").remove(builder); this.virtualClusters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVirtualClusters(Predicate<VirtualClusterBuilder> predicate) {
    if (virtualClusters == null) return (A) this;
    final Iterator<VirtualClusterBuilder> each = virtualClusters.iterator();
    final List visitables = _visitables.get("virtualClusters");
    while (each.hasNext()) {
      VirtualClusterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<VirtualCluster> buildVirtualClusters() {
    return this.virtualClusters != null ? build(virtualClusters) : null;
  }
  
  public VirtualCluster buildVirtualCluster(int index) {
    return this.virtualClusters.get(index).build();
  }
  
  public VirtualCluster buildFirstVirtualCluster() {
    return this.virtualClusters.get(0).build();
  }
  
  public VirtualCluster buildLastVirtualCluster() {
    return this.virtualClusters.get(virtualClusters.size() - 1).build();
  }
  
  public VirtualCluster buildMatchingVirtualCluster(Predicate<VirtualClusterBuilder> predicate) {
      for (VirtualClusterBuilder item : virtualClusters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVirtualCluster(Predicate<VirtualClusterBuilder> predicate) {
      for (VirtualClusterBuilder item : virtualClusters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVirtualClusters(List<VirtualCluster> virtualClusters) {
    if (this.virtualClusters != null) {
      this._visitables.get("virtualClusters").clear();
    }
    if (virtualClusters != null) {
        this.virtualClusters = new ArrayList();
        for (VirtualCluster item : virtualClusters) {
          this.addToVirtualClusters(item);
        }
    } else {
      this.virtualClusters = null;
    }
    return (A) this;
  }
  
  public A withVirtualClusters(io.kroxylicious.proxy.config.VirtualCluster... virtualClusters) {
    if (this.virtualClusters != null) {
        this.virtualClusters.clear();
        _visitables.remove("virtualClusters");
    }
    if (virtualClusters != null) {
      for (VirtualCluster item : virtualClusters) {
        this.addToVirtualClusters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVirtualClusters() {
    return this.virtualClusters != null && !this.virtualClusters.isEmpty();
  }
  
  public VirtualClustersNested<A> addNewVirtualCluster() {
    return new VirtualClustersNested(-1, null);
  }
  
  public VirtualClustersNested<A> addNewVirtualClusterLike(VirtualCluster item) {
    return new VirtualClustersNested(-1, item);
  }
  
  public VirtualClustersNested<A> setNewVirtualClusterLike(int index,VirtualCluster item) {
    return new VirtualClustersNested(index, item);
  }
  
  public VirtualClustersNested<A> editVirtualCluster(int index) {
    if (virtualClusters.size() <= index) throw new RuntimeException("Can't edit virtualClusters. Index exceeds size.");
    return setNewVirtualClusterLike(index, buildVirtualCluster(index));
  }
  
  public VirtualClustersNested<A> editFirstVirtualCluster() {
    if (virtualClusters.size() == 0) throw new RuntimeException("Can't edit first virtualClusters. The list is empty.");
    return setNewVirtualClusterLike(0, buildVirtualCluster(0));
  }
  
  public VirtualClustersNested<A> editLastVirtualCluster() {
    int index = virtualClusters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last virtualClusters. The list is empty.");
    return setNewVirtualClusterLike(index, buildVirtualCluster(index));
  }
  
  public VirtualClustersNested<A> editMatchingVirtualCluster(Predicate<VirtualClusterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<virtualClusters.size();i++) { 
    if (predicate.test(virtualClusters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching virtualClusters. No match found.");
    return setNewVirtualClusterLike(index, buildVirtualCluster(index));
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A addToFilters(int index,FilterDefinition item) {
    if (this.filters == null) {this.filters = new ArrayList<FilterDefinition>();}
    this.filters.add(index, item);
    return (A)this;
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A setToFilters(int index,FilterDefinition item) {
    if (this.filters == null) {this.filters = new ArrayList<FilterDefinition>();}
    this.filters.set(index, item); return (A)this;
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A addToFilters(io.kroxylicious.proxy.config.FilterDefinition... items) {
    if (this.filters == null) {this.filters = new ArrayList<FilterDefinition>();}
    for (FilterDefinition item : items) {this.filters.add(item);} return (A)this;
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A addAllToFilters(Collection<FilterDefinition> items) {
    if (this.filters == null) {this.filters = new ArrayList<FilterDefinition>();}
    for (FilterDefinition item : items) {this.filters.add(item);} return (A)this;
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A removeFromFilters(io.kroxylicious.proxy.config.FilterDefinition... items) {
    if (this.filters == null) return (A)this;
    for (FilterDefinition item : items) { this.filters.remove(item);} return (A)this;
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A removeAllFromFilters(Collection<FilterDefinition> items) {
    if (this.filters == null) return (A)this;
    for (FilterDefinition item : items) { this.filters.remove(item);} return (A)this;
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public List<FilterDefinition> getFilters() {
    return this.filters;
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public FilterDefinition getFilter(int index) {
    return this.filters.get(index);
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public FilterDefinition getFirstFilter() {
    return this.filters.get(0);
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public FilterDefinition getLastFilter() {
    return this.filters.get(filters.size() - 1);
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public FilterDefinition getMatchingFilter(Predicate<FilterDefinition> predicate) {
      for (FilterDefinition item : filters) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public boolean hasMatchingFilter(Predicate<FilterDefinition> predicate) {
      for (FilterDefinition item : filters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A withFilters(List<FilterDefinition> filters) {
    if (filters != null) {
        this.filters = new ArrayList();
        for (FilterDefinition item : filters) {
          this.addToFilters(item);
        }
    } else {
      this.filters = null;
    }
    return (A) this;
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A withFilters(io.kroxylicious.proxy.config.FilterDefinition... filters) {
    if (this.filters != null) {
        this.filters.clear();
        _visitables.remove("filters");
    }
    if (filters != null) {
      for (FilterDefinition item : filters) {
        this.addToFilters(item);
      }
    }
    return (A) this;
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public boolean hasFilters() {
    return this.filters != null && !this.filters.isEmpty();
  }
  
  
  /**
   * The field filters has been deprecated, please see the pojo class for more information
   */
  @Deprecated
  public A addNewFilter(String type,Object config) {
    return (A)addToFilters(new FilterDefinition(type, config));
  }
  
  public A addToMicrometer(int index,MicrometerDefinition item) {
    if (this.micrometer == null) {this.micrometer = new ArrayList<MicrometerDefinition>();}
    this.micrometer.add(index, item);
    return (A)this;
  }
  
  public A setToMicrometer(int index,MicrometerDefinition item) {
    if (this.micrometer == null) {this.micrometer = new ArrayList<MicrometerDefinition>();}
    this.micrometer.set(index, item); return (A)this;
  }
  
  public A addToMicrometer(io.kroxylicious.proxy.config.MicrometerDefinition... items) {
    if (this.micrometer == null) {this.micrometer = new ArrayList<MicrometerDefinition>();}
    for (MicrometerDefinition item : items) {this.micrometer.add(item);} return (A)this;
  }
  
  public A addAllToMicrometer(Collection<MicrometerDefinition> items) {
    if (this.micrometer == null) {this.micrometer = new ArrayList<MicrometerDefinition>();}
    for (MicrometerDefinition item : items) {this.micrometer.add(item);} return (A)this;
  }
  
  public A removeFromMicrometer(io.kroxylicious.proxy.config.MicrometerDefinition... items) {
    if (this.micrometer == null) return (A)this;
    for (MicrometerDefinition item : items) { this.micrometer.remove(item);} return (A)this;
  }
  
  public A removeAllFromMicrometer(Collection<MicrometerDefinition> items) {
    if (this.micrometer == null) return (A)this;
    for (MicrometerDefinition item : items) { this.micrometer.remove(item);} return (A)this;
  }
  
  public List<MicrometerDefinition> getMicrometer() {
    return this.micrometer;
  }
  
  public MicrometerDefinition getMicrometer(int index) {
    return this.micrometer.get(index);
  }
  
  public MicrometerDefinition getFirstMicrometer() {
    return this.micrometer.get(0);
  }
  
  public MicrometerDefinition getLastMicrometer() {
    return this.micrometer.get(micrometer.size() - 1);
  }
  
  public MicrometerDefinition getMatchingMicrometer(Predicate<MicrometerDefinition> predicate) {
      for (MicrometerDefinition item : micrometer) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingMicrometer(Predicate<MicrometerDefinition> predicate) {
      for (MicrometerDefinition item : micrometer) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMicrometer(List<MicrometerDefinition> micrometer) {
    if (micrometer != null) {
        this.micrometer = new ArrayList();
        for (MicrometerDefinition item : micrometer) {
          this.addToMicrometer(item);
        }
    } else {
      this.micrometer = null;
    }
    return (A) this;
  }
  
  public A withMicrometer(io.kroxylicious.proxy.config.MicrometerDefinition... micrometer) {
    if (this.micrometer != null) {
        this.micrometer.clear();
        _visitables.remove("micrometer");
    }
    if (micrometer != null) {
      for (MicrometerDefinition item : micrometer) {
        this.addToMicrometer(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMicrometer() {
    return this.micrometer != null && !this.micrometer.isEmpty();
  }
  
  public A addNewMicrometer(String type,Object config) {
    return (A)addToMicrometer(new MicrometerDefinition(type, config));
  }
  
  public boolean isUseIoUring() {
    return this.useIoUring;
  }
  
  public A withUseIoUring(boolean useIoUring) {
    this.useIoUring = useIoUring;
    return (A) this;
  }
  
  public boolean hasUseIoUring() {
    return true;
  }
  
  public A withDevelopment(Optional<Map<String,Object>> development) {
    if (development == null || !development.isPresent()) {
      this.development = java.util.Optional.empty();
    } else {
      this.development = development;
    }
    return (A) this;
  }
  
  public A withDevelopment(Map<String,Object> development) {
    if (development == null) {
      this.development = java.util.Optional.empty();
    } else {
        this.development = java.util.Optional.of(development);
    }
    return (A) this;
  }
  
  public Optional<Map<String,Object>> getDevelopment() {
    return this.development;
  }
  
  public boolean hasDevelopment() {
    return this.development != null && this.development.isPresent();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConfigurationFluent that = (ConfigurationFluent) o;
    if (!java.util.Objects.equals(management, that.management)) return false;
    if (!java.util.Objects.equals(filterDefinitions, that.filterDefinitions)) return false;
    if (!java.util.Objects.equals(defaultFilters, that.defaultFilters)) return false;
    if (!java.util.Objects.equals(virtualClusters, that.virtualClusters)) return false;
    if (!java.util.Objects.equals(filters, that.filters)) return false;
    if (!java.util.Objects.equals(micrometer, that.micrometer)) return false;
    if (useIoUring != that.useIoUring) return false;
    if (!java.util.Objects.equals(development, that.development)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(management,  filterDefinitions,  defaultFilters,  virtualClusters,  filters,  micrometer,  useIoUring,  development,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (management != null) { sb.append("management:"); sb.append(management + ","); }
    if (filterDefinitions != null && !filterDefinitions.isEmpty()) { sb.append("filterDefinitions:"); sb.append(filterDefinitions + ","); }
    if (defaultFilters != null && !defaultFilters.isEmpty()) { sb.append("defaultFilters:"); sb.append(defaultFilters + ","); }
    if (virtualClusters != null && !virtualClusters.isEmpty()) { sb.append("virtualClusters:"); sb.append(virtualClusters + ","); }
    if (filters != null && !filters.isEmpty()) { sb.append("filters:"); sb.append(filters + ","); }
    if (micrometer != null && !micrometer.isEmpty()) { sb.append("micrometer:"); sb.append(micrometer + ","); }
    sb.append("useIoUring:"); sb.append(useIoUring + ",");
    if (development != null) { sb.append("development:"); sb.append(development); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withUseIoUring() {
    return withUseIoUring(true);
  }
  public class ManagementNested<N> extends ManagementConfigurationFluent<ManagementNested<N>> implements Nested<N>{
    ManagementNested(ManagementConfiguration item) {
      this.builder = new ManagementConfigurationBuilder(this, item);
    }
    ManagementConfigurationBuilder builder;
    
    public N and() {
      return (N) ConfigurationFluent.this.withManagement(builder.build());
    }
    
    public N endManagement() {
      return and();
    }
    
  
  }
  public class VirtualClustersNested<N> extends VirtualClusterFluent<VirtualClustersNested<N>> implements Nested<N>{
    VirtualClustersNested(int index,VirtualCluster item) {
      this.index = index;
      this.builder = new VirtualClusterBuilder(this, item);
    }
    VirtualClusterBuilder builder;
    int index;
    
    public N and() {
      return (N) ConfigurationFluent.this.setToVirtualClusters(index,builder.build());
    }
    
    public N endVirtualCluster() {
      return and();
    }
    
  
  }

}