package io.kroxylicious.proxy.config;

import io.kroxylicious.proxy.config.model.VisitableBuilder;
public class ConfigurationBuilder extends ConfigurationFluent<ConfigurationBuilder> implements VisitableBuilder<Configuration,ConfigurationBuilder>{
  public ConfigurationBuilder() {
    this.fluent = this;
  }
  
  public ConfigurationBuilder(ConfigurationFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public ConfigurationBuilder(ConfigurationFluent<?> fluent,Configuration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConfigurationBuilder(Configuration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConfigurationFluent<?> fluent;
  
  public Configuration build() {
    Configuration buildable = new Configuration(fluent.buildManagement(),fluent.getFilterDefinitions(),fluent.getDefaultFilters(),fluent.buildVirtualClusters(),fluent.getFilters(),fluent.getMicrometer(),fluent.isUseIoUring(),fluent.getDevelopment());
    return buildable;
  }
  

}