/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.formats.neo4jcsv;

import com.github.tototoshi.csv.CSVFormat;
import com.github.tototoshi.csv.CSVReader$;
import flatgraph.Graph;
import flatgraph.formats.Importer;
import flatgraph.formats.neo4jcsv.Neo4jCsvImporter;
import flatgraph.formats.neo4jcsv.Neo4jCsvImporter$ColumnDef$;
import flatgraph.formats.neo4jcsv.Neo4jCsvImporter$HeaderAndDataFile$;
import flatgraph.formats.neo4jcsv.Neo4jCsvImporter$ParsedEdgeRowData$;
import flatgraph.formats.neo4jcsv.Neo4jCsvImporter$ParsedHeaderFile$;
import flatgraph.formats.neo4jcsv.Neo4jCsvImporter$ParsedNodeRowData$;
import flatgraph.formats.neo4jcsv.Neo4jCsvImporter$ParsedProperty$;
import flatgraph.formats.neo4jcsv.package$;
import flatgraph.formats.neo4jcsv.package$ColumnType$;
import flatgraph.formats.neo4jcsv.package$FileType$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;

public final class Neo4jCsvImporter$
implements Importer,
Serializable {
    private static Logger logger;
    private static final String Neo4jAdminDoc;
    private static final Neo4jCsvImporter$HeaderAndDataFile$ HeaderAndDataFile;
    private static final Neo4jCsvImporter$ParsedHeaderFile$ ParsedHeaderFile;
    public static final Neo4jCsvImporter$ColumnDef$ flatgraph$formats$neo4jcsv$Neo4jCsvImporter$$$ColumnDef;
    private static final Neo4jCsvImporter$ParsedProperty$ ParsedProperty;
    private static final Neo4jCsvImporter$ParsedNodeRowData$ ParsedNodeRowData;
    private static final Neo4jCsvImporter$ParsedEdgeRowData$ ParsedEdgeRowData;
    public static final Neo4jCsvImporter$ MODULE$;

    private Neo4jCsvImporter$() {
    }

    static {
        MODULE$ = new Neo4jCsvImporter$();
        Importer.$init$(MODULE$);
        Neo4jAdminDoc = "https://neo4j.com/docs/operations-manual/current/tools/neo4j-admin/neo4j-admin-import";
        Statics.releaseFence();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void flatgraph$formats$Importer$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Neo4jCsvImporter$.class);
    }

    public String Neo4jAdminDoc() {
        return Neo4jAdminDoc;
    }

    @Override
    public void runImport(Graph graph, Seq<Path> inputFiles) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private Seq<Neo4jCsvImporter.HeaderAndDataFile> groupInputFiles(Seq<Path> inputFiles) {
        Seq nonCsvFiles = (Seq)inputFiles.filterNot((Function1 & Serializable)_$1 -> _$1.getFileName().toString().endsWith(".csv"));
        if (!nonCsvFiles.isEmpty()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(70).append("input files must all have `.csv` extension, which is not the case for ").append(nonCsvFiles.mkString(",")).toString());
        }
        Tuple2 tuple2 = inputFiles.partition((Function1 & Serializable)_$2 -> _$2.getFileName().toString().endsWith(new StringBuilder(4).append(package$.MODULE$.HeaderFileSuffix()).append(".csv").toString()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq headerFiles = (Seq)tuple2._1();
        Seq dataFiles = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)headerFiles, (Object)dataFiles);
        Seq headerFiles2 = (Seq)tuple22._1();
        Seq dataFiles2 = (Seq)tuple22._2();
        if (headerFiles2.size() != dataFiles2.size()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(82).append("number of header files (`xyz").append(package$.MODULE$.HeaderFileSuffix()).append(".csv`) must equal the number of data files (`xyz.csv`)").toString());
        }
        return (Seq)headerFiles2.map((Function1 & Serializable)headerFile -> {
            String wantedBodyFilename = headerFile.getFileName().toString().replaceAll(package$.MODULE$.HeaderFileSuffix(), package$.MODULE$.DataFileSuffix());
            Option option = dataFiles2.find((Function1 & Serializable)_$3 -> {
                String string = _$3.getFileName().toString();
                String string2 = wantedBodyFilename;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            if (option instanceof Some) {
                Path dataFile = (Path)((Some)option).value();
                return Neo4jCsvImporter$HeaderAndDataFile$.MODULE$.apply(MODULE$.parseHeaderFile((Path)headerFile), dataFile);
            }
            if (None$.MODULE$.equals(option)) {
                String inputFilenames = ((IterableOnceOps)inputFiles.map((Function1 & Serializable)_$4 -> _$4.getFileName())).mkString(", ");
                throw new AssertionError((Object)new StringBuilder(61).append("body filename `").append(wantedBodyFilename).append("` wanted, but not found in given input files: ").append(inputFilenames).toString());
            }
            throw new MatchError((Object)option);
        });
    }

    private int nodeFilesFirst(Neo4jCsvImporter.HeaderAndDataFile headerAndDataFile) {
        Enumeration.Value value = headerAndDataFile.headerFile().fileType();
        Enumeration.Value value2 = package$FileType$.MODULE$.Nodes();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return 1;
        }
        Enumeration.Value value4 = package$FileType$.MODULE$.Relationships();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return 2;
        }
        throw new MatchError((Object)value);
    }

    private Neo4jCsvImporter.ParsedHeaderFile parseHeaderFile(Path headerFile) {
        List columnDefs = (List)Using$.MODULE$.resource((Object)CSVReader$.MODULE$.open(headerFile.toFile(), (CSVFormat)com.github.tototoshi.csv.package$.MODULE$.defaultCSVFormat()), (Function1 & Serializable)headerReader -> (List)headerReader.all().headOption().getOrElse(() -> Neo4jCsvImporter$.$anonfun$4$$anonfun$1(headerFile)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Builder propertyDefs = Predef$.MODULE$.Map().newBuilder();
        BooleanRef labelColumnFound = BooleanRef.create((boolean)false);
        ObjectRef fileType = ObjectRef.create((Object)None$.MODULE$);
        ((List)columnDefs.zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            block4: {
                Neo4jCsvImporter.ColumnDef columnDef;
                int idx;
                block6: {
                    String string;
                    block11: {
                        String valueTpe0;
                        String name;
                        String propertyDef;
                        block14: {
                            List list;
                            block12: {
                                List list2;
                                Nil$ nil$;
                                block13: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block5: {
                                                        tuple2 = x$1;
                                                        if (tuple2 == null) break block4;
                                                        String entry = (String)tuple2._1();
                                                        idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                                                        string = entry;
                                                        String string2 = package$ColumnType$.MODULE$.LabelMarker();
                                                        String string3 = string;
                                                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block5;
                                                        if (labelColumnFound$1.elem) {
                                                            throw new NotImplementedError(new StringBuilder(64).append("multiple ").append(package$ColumnType$.MODULE$.Label()).append(" columns found in ").append(headerFile).append(", which is not supported by flatgraph").toString());
                                                        }
                                                        labelColumnFound$1.elem = true;
                                                        fileType$1.elem = Option$.MODULE$.apply((Object)package$FileType$.MODULE$.Nodes());
                                                        columnDef = Neo4jCsvImporter$ColumnDef$.MODULE$.apply((Option<String>)None$.MODULE$, package$ColumnType$.MODULE$.Label(), Neo4jCsvImporter$ColumnDef$.MODULE$.$lessinit$greater$default$3());
                                                        break block6;
                                                    }
                                                    String string4 = package$ColumnType$.MODULE$.TypeMarker();
                                                    String string5 = string;
                                                    if (string4 != null ? !string4.equals(string5) : string5 != null) break block7;
                                                    fileType$1.elem = Option$.MODULE$.apply((Object)package$FileType$.MODULE$.Relationships());
                                                    columnDef = Neo4jCsvImporter$ColumnDef$.MODULE$.apply((Option<String>)None$.MODULE$, package$ColumnType$.MODULE$.Type(), Neo4jCsvImporter$ColumnDef$.MODULE$.$lessinit$greater$default$3());
                                                    break block6;
                                                }
                                                String s = string;
                                                if (!s.endsWith(package$ColumnType$.MODULE$.Id().toString())) break block8;
                                                columnDef = Neo4jCsvImporter$ColumnDef$.MODULE$.apply((Option<String>)None$.MODULE$, package$ColumnType$.MODULE$.Id(), Neo4jCsvImporter$ColumnDef$.MODULE$.$lessinit$greater$default$3());
                                                break block6;
                                            }
                                            String s = string;
                                            if (!s.endsWith(package$ColumnType$.MODULE$.StartId().toString())) break block9;
                                            columnDef = Neo4jCsvImporter$ColumnDef$.MODULE$.apply((Option<String>)None$.MODULE$, package$ColumnType$.MODULE$.StartId(), Neo4jCsvImporter$ColumnDef$.MODULE$.$lessinit$greater$default$3());
                                            break block6;
                                        }
                                        String s = string;
                                        if (!s.endsWith(package$ColumnType$.MODULE$.EndId().toString())) break block10;
                                        columnDef = Neo4jCsvImporter$ColumnDef$.MODULE$.apply((Option<String>)None$.MODULE$, package$ColumnType$.MODULE$.EndId(), Neo4jCsvImporter$ColumnDef$.MODULE$.$lessinit$greater$default$3());
                                        break block6;
                                    }
                                    propertyDef = string;
                                    if (!propertyDef.contains(":")) break block11;
                                    list = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(propertyDef), ':')).toList();
                                    if (!(list instanceof .colon.colon)) break block12;
                                    .colon.colon colon2 = (.colon.colon)list;
                                    List list3 = colon2.next();
                                    name = (String)colon2.head();
                                    if (!(list3 instanceof .colon.colon)) break block12;
                                    .colon.colon colon3 = (.colon.colon)list3;
                                    List list4 = colon3.next();
                                    valueTpe0 = (String)colon3.head();
                                    nil$ = scala.package$.MODULE$.Nil();
                                    list2 = list4;
                                    if (nil$ != null) break block13;
                                    if (list2 == null) break block14;
                                    break block12;
                                }
                                if (nil$.equals(list2)) break block14;
                            }
                            throw new MatchError((Object)list);
                        }
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)name, (Object)valueTpe0);
                        String name2 = (String)tuple22._1();
                        String valueTpe02 = (String)tuple22._2();
                        boolean isArray = propertyDef.endsWith(package$ColumnType$.MODULE$.ArrayMarker());
                        String valueTpe = isArray ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(valueTpe02), 2) : valueTpe02;
                        columnDef = Neo4jCsvImporter$ColumnDef$.MODULE$.apply((Option<String>)Option$.MODULE$.apply((Object)name2), package$ColumnType$.MODULE$.withName(valueTpe), isArray);
                        break block6;
                    }
                    String propertyName = string;
                    columnDef = Neo4jCsvImporter$ColumnDef$.MODULE$.apply((Option<String>)Option$.MODULE$.apply((Object)propertyName), package$ColumnType$.MODULE$.String(), Neo4jCsvImporter$ColumnDef$.MODULE$.$lessinit$greater$default$3());
                }
                Neo4jCsvImporter.ColumnDef propertyDef = columnDef;
                return (Builder)propertyDefs.addOne((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)idx), (Object)propertyDef));
            }
            throw new MatchError((Object)tuple2);
        });
        Map propertyDefsRes = (Map)propertyDefs.result();
        Option option = (Option)fileType.elem;
        if (option instanceof Some) {
            Enumeration.Value value = (Enumeration.Value)((Some)option).value();
            Enumeration.Value value2 = package$FileType$.MODULE$.Nodes();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                if (!propertyDefsRes.values().exists((Function1 & Serializable)_$5 -> {
                    Enumeration.Value value = _$5.valueType();
                    Enumeration.Value value2 = package$ColumnType$.MODULE$.Id();
                    return !(value != null ? !value.equals(value2) : value2 != null);
                })) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(62).append("no :ID column found in headerFile ").append(headerFile).append(" - see format definition in ").append(this.Neo4jAdminDoc()).toString());
                }
                return Neo4jCsvImporter$ParsedHeaderFile$.MODULE$.apply(package$FileType$.MODULE$.Nodes(), (Map<Object, Neo4jCsvImporter.ColumnDef>)propertyDefsRes);
            }
            Enumeration.Value value4 = package$FileType$.MODULE$.Relationships();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                if (!propertyDefsRes.values().exists((Function1 & Serializable)_$6 -> {
                    Enumeration.Value value = _$6.valueType();
                    Enumeration.Value value2 = package$ColumnType$.MODULE$.StartId();
                    return !(value != null ? !value.equals(value2) : value2 != null);
                })) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(68).append("no :START_ID column found in headerFile ").append(headerFile).append(" - see format definition in ").append(this.Neo4jAdminDoc()).toString());
                }
                if (!propertyDefsRes.values().exists((Function1 & Serializable)_$7 -> {
                    Enumeration.Value value = _$7.valueType();
                    Enumeration.Value value2 = package$ColumnType$.MODULE$.EndId();
                    return !(value != null ? !value.equals(value2) : value2 != null);
                })) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(66).append("no :END_ID column found in headerFile ").append(headerFile).append(" - see format definition in ").append(this.Neo4jAdminDoc()).toString());
                }
                return Neo4jCsvImporter$ParsedHeaderFile$.MODULE$.apply(package$FileType$.MODULE$.Relationships(), (Map<Object, Neo4jCsvImporter.ColumnDef>)propertyDefsRes);
            }
        }
        throw new AssertionError((Object)new StringBuilder(83).append("unable to determine file type - neither ").append(package$ColumnType$.MODULE$.Label()).append(" (for nodes) nor ").append(package$ColumnType$.MODULE$.Type()).append(" (for relationships) found").toString());
    }

    private Neo4jCsvImporter.ParsedNodeRowData parseNodeRowData(Seq<String> columnsRaw, Map<Object, Neo4jCsvImporter.ColumnDef> columnDefs, Path inputFile, int lineNo) {
        ObjectRef id = ObjectRef.create(null);
        ObjectRef label = ObjectRef.create(null);
        Builder properties = scala.package$.MODULE$.Seq().newBuilder();
        ((IterableOnceOps)columnsRaw.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String entry = (String)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Neo4jCsvImporter.ColumnDef columnDef = (Neo4jCsvImporter.ColumnDef)columnDefs.getOrElse((Object)BoxesRunTime.boxToInteger((int)idx), () -> Neo4jCsvImporter$.$anonfun$5(idx));
                this.parseEntry(entry, columnDef, inputFile, lineNo, (PartialFunction<Neo4jCsvImporter.ColumnDef, ?>)new Serializable(id, entry, lineNo, label, properties){
                    private final ObjectRef id$2;
                    private final String entry$1;
                    private final int lineNo$2;
                    private final ObjectRef label$2;
                    private final Builder properties$2;
                    {
                        this.id$2 = id$3;
                        this.entry$1 = entry$3;
                        this.lineNo$2 = lineNo$6;
                        this.label$2 = label$5;
                        this.properties$2 = properties$5;
                    }

                    public final boolean isDefinedAt(Neo4jCsvImporter.ColumnDef x) {
                        Neo4jCsvImporter.ColumnDef columnDef = x;
                        if (columnDef != null) {
                            Neo4jCsvImporter.ColumnDef columnDef2 = Neo4jCsvImporter$ColumnDef$.MODULE$.unapply(columnDef);
                            Option<String> option = columnDef2._1();
                            Enumeration.Value value = columnDef2._2();
                            boolean bl = columnDef2._3();
                            Enumeration.Value value2 = package$ColumnType$.MODULE$.Id();
                            Enumeration.Value value3 = value;
                            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                                return true;
                            }
                            Enumeration.Value value4 = package$ColumnType$.MODULE$.Label();
                            Enumeration.Value value5 = value;
                            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                                return true;
                            }
                            if (option instanceof Some) {
                                String string;
                                String name = string = (String)((Some)option).value();
                                Enumeration.Value valueType = value;
                                if (!bl) {
                                    return true;
                                }
                                String name2 = string;
                                Enumeration.Value valueType2 = value;
                                if (bl) {
                                    return true;
                                }
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(Neo4jCsvImporter.ColumnDef x, Function1 function1) {
                        Neo4jCsvImporter.ColumnDef columnDef = x;
                        if (columnDef != null) {
                            Neo4jCsvImporter.ColumnDef columnDef2 = Neo4jCsvImporter$ColumnDef$.MODULE$.unapply(columnDef);
                            Option<String> option = columnDef2._1();
                            Enumeration.Value value = columnDef2._2();
                            boolean bl = columnDef2._3();
                            Enumeration.Value value2 = package$ColumnType$.MODULE$.Id();
                            Enumeration.Value value3 = value;
                            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                                this.id$2.elem = Predef$.MODULE$.int2Integer(Neo4jCsvImporter$.MODULE$.flatgraph$formats$neo4jcsv$Neo4jCsvImporter$$$parseInt(this.entry$1, package$ColumnType$.MODULE$.Id(), this.lineNo$2));
                                return BoxedUnit.UNIT;
                            }
                            Enumeration.Value value4 = package$ColumnType$.MODULE$.Label();
                            Enumeration.Value value5 = value;
                            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                                this.label$2.elem = this.entry$1;
                                return BoxedUnit.UNIT;
                            }
                            if (option instanceof Some) {
                                String string;
                                String name = string = (String)((Some)option).value();
                                Enumeration.Value valueType = value;
                                if (!bl) {
                                    Neo4jCsvImporter$.MODULE$.flatgraph$formats$neo4jcsv$Neo4jCsvImporter$$$parseProperty(this.entry$1, name, valueType).foreach((Function1 & Serializable)elem -> (Builder)this.properties$2.addOne(elem));
                                    return BoxedUnit.UNIT;
                                }
                                String name2 = string;
                                Enumeration.Value valueType2 = value;
                                if (bl) {
                                    Neo4jCsvImporter$.MODULE$.flatgraph$formats$neo4jcsv$Neo4jCsvImporter$$$parseArrayProperty(this.entry$1, name2, valueType2).foreach((Function1 & Serializable)elem -> (Builder)this.properties$2.addOne(elem));
                                    return BoxedUnit.UNIT;
                                }
                            }
                        }
                        return function1.apply((Object)x);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(flatgraph.formats.neo4jcsv.Neo4jCsvImporter$ParsedProperty ), applyOrElse$$anonfun$2(flatgraph.formats.neo4jcsv.Neo4jCsvImporter$ParsedProperty )}, serializedLambda);
                    }
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        if ((Integer)id.elem == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(27).append("no ID column found in line ").append(lineNo).toString());
        }
        if ((String)label.elem == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(30).append("no LABEL column found in line ").append(lineNo).toString());
        }
        Neo4jCsvImporter.ParsedNodeRowData ret = Neo4jCsvImporter$ParsedNodeRowData$.MODULE$.apply(Predef$.MODULE$.Integer2int((Integer)id.elem), (String)label.elem, (Seq<Neo4jCsvImporter.ParsedProperty>)((Seq)properties.result()));
        this.logger().debug("parsed line {}: {}", (Object)BoxesRunTime.boxToInteger((int)lineNo), (Object)ret);
        return ret;
    }

    private Neo4jCsvImporter.ParsedEdgeRowData parseEdgeRowData(Seq<String> columnsRaw, Map<Object, Neo4jCsvImporter.ColumnDef> columnDefs, Path inputFile, int lineNo) {
        ObjectRef startId = ObjectRef.create(null);
        ObjectRef endId = ObjectRef.create(null);
        ObjectRef label = ObjectRef.create(null);
        Builder properties = scala.package$.MODULE$.Seq().newBuilder();
        ((IterableOnceOps)columnsRaw.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String entry = (String)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Neo4jCsvImporter.ColumnDef columnDef = (Neo4jCsvImporter.ColumnDef)columnDefs.getOrElse((Object)BoxesRunTime.boxToInteger((int)idx), () -> Neo4jCsvImporter$.$anonfun$6(idx));
                this.parseEntry(entry, columnDef, inputFile, lineNo, (PartialFunction<Neo4jCsvImporter.ColumnDef, ?>)new Serializable(startId, entry, lineNo, endId, label, properties){
                    private final ObjectRef startId$2;
                    private final String entry$2;
                    private final int lineNo$4;
                    private final ObjectRef endId$2;
                    private final ObjectRef label$4;
                    private final Builder properties$4;
                    {
                        this.startId$2 = startId$3;
                        this.entry$2 = entry$4;
                        this.lineNo$4 = lineNo$7;
                        this.endId$2 = endId$3;
                        this.label$4 = label$6;
                        this.properties$4 = properties$6;
                    }

                    public final boolean isDefinedAt(Neo4jCsvImporter.ColumnDef x) {
                        Neo4jCsvImporter.ColumnDef columnDef = x;
                        if (columnDef != null) {
                            Neo4jCsvImporter.ColumnDef columnDef2 = Neo4jCsvImporter$ColumnDef$.MODULE$.unapply(columnDef);
                            Option<String> option = columnDef2._1();
                            Enumeration.Value value = columnDef2._2();
                            boolean bl = columnDef2._3();
                            Enumeration.Value value2 = package$ColumnType$.MODULE$.StartId();
                            Enumeration.Value value3 = value;
                            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                                return true;
                            }
                            Enumeration.Value value4 = package$ColumnType$.MODULE$.EndId();
                            Enumeration.Value value5 = value;
                            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                                return true;
                            }
                            Enumeration.Value value6 = package$ColumnType$.MODULE$.Type();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                return true;
                            }
                            if (option instanceof Some) {
                                String string;
                                String name = string = (String)((Some)option).value();
                                Enumeration.Value valueType = value;
                                if (!bl) {
                                    return true;
                                }
                                String name2 = string;
                                Enumeration.Value valueType2 = value;
                                if (bl) {
                                    return true;
                                }
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(Neo4jCsvImporter.ColumnDef x, Function1 function1) {
                        Neo4jCsvImporter.ColumnDef columnDef = x;
                        if (columnDef != null) {
                            Neo4jCsvImporter.ColumnDef columnDef2 = Neo4jCsvImporter$ColumnDef$.MODULE$.unapply(columnDef);
                            Option<String> option = columnDef2._1();
                            Enumeration.Value value = columnDef2._2();
                            boolean bl = columnDef2._3();
                            Enumeration.Value value2 = package$ColumnType$.MODULE$.StartId();
                            Enumeration.Value value3 = value;
                            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                                this.startId$2.elem = Predef$.MODULE$.int2Integer(Neo4jCsvImporter$.MODULE$.flatgraph$formats$neo4jcsv$Neo4jCsvImporter$$$parseInt(this.entry$2, package$ColumnType$.MODULE$.StartId(), this.lineNo$4));
                                return BoxedUnit.UNIT;
                            }
                            Enumeration.Value value4 = package$ColumnType$.MODULE$.EndId();
                            Enumeration.Value value5 = value;
                            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                                this.endId$2.elem = Predef$.MODULE$.int2Integer(Neo4jCsvImporter$.MODULE$.flatgraph$formats$neo4jcsv$Neo4jCsvImporter$$$parseInt(this.entry$2, package$ColumnType$.MODULE$.EndId(), this.lineNo$4));
                                return BoxedUnit.UNIT;
                            }
                            Enumeration.Value value6 = package$ColumnType$.MODULE$.Type();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                this.label$4.elem = this.entry$2;
                                return BoxedUnit.UNIT;
                            }
                            if (option instanceof Some) {
                                String string;
                                String name = string = (String)((Some)option).value();
                                Enumeration.Value valueType = value;
                                if (!bl) {
                                    Neo4jCsvImporter$.MODULE$.flatgraph$formats$neo4jcsv$Neo4jCsvImporter$$$parseProperty(this.entry$2, name, valueType).foreach((Function1 & Serializable)elem -> (Builder)this.properties$4.addOne(elem));
                                    return BoxedUnit.UNIT;
                                }
                                String name2 = string;
                                Enumeration.Value valueType2 = value;
                                if (bl) {
                                    Neo4jCsvImporter$.MODULE$.flatgraph$formats$neo4jcsv$Neo4jCsvImporter$$$parseArrayProperty(this.entry$2, name2, valueType2).foreach((Function1 & Serializable)elem -> (Builder)this.properties$4.addOne(elem));
                                    return BoxedUnit.UNIT;
                                }
                            }
                        }
                        return function1.apply((Object)x);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$3(flatgraph.formats.neo4jcsv.Neo4jCsvImporter$ParsedProperty ), applyOrElse$$anonfun$4(flatgraph.formats.neo4jcsv.Neo4jCsvImporter$ParsedProperty )}, serializedLambda);
                    }
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        if ((Integer)startId.elem == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(33).append("no START_ID column found in line ").append(lineNo).toString());
        }
        if ((Integer)endId.elem == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(31).append("no END_ID column found in line ").append(lineNo).toString());
        }
        if ((String)label.elem == null) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(30).append("no LABEL column found in line ").append(lineNo).toString());
        }
        Neo4jCsvImporter.ParsedEdgeRowData ret = Neo4jCsvImporter$ParsedEdgeRowData$.MODULE$.apply(Predef$.MODULE$.Integer2int((Integer)startId.elem), Predef$.MODULE$.Integer2int((Integer)endId.elem), (String)label.elem, (Seq<Neo4jCsvImporter.ParsedProperty>)((Seq)properties.result()));
        this.logger().debug("parsed line {}: {}", (Object)BoxesRunTime.boxToInteger((int)lineNo), (Object)ret);
        return ret;
    }

    private void parseEntry(String rawValue, Neo4jCsvImporter.ColumnDef columnDef, Path inputFile, int lineNo, PartialFunction<Neo4jCsvImporter.ColumnDef, ?> handleColumn) {
        try {
            handleColumn.applyOrElse((Object)columnDef, (Function1 & Serializable)_$8 -> {
                throw new MatchError((Object)new StringBuilder(39).append("unhandled case ").append(columnDef).append(" for rawValue=").append(rawValue).append(" in ").append(inputFile.getFileName()).append(" line ").append(lineNo).toString());
            });
        }
        catch (Exception err) {
            throw new RuntimeException(new StringBuilder(58).append("error while parsing input value '").append(rawValue).append("' of valueType=").append(columnDef.valueType()).append(" in ").append(inputFile.getFileName()).append(" line ").append(lineNo).toString(), err);
        }
    }

    public Option<Neo4jCsvImporter.ParsedProperty> flatgraph$formats$neo4jcsv$Neo4jCsvImporter$$$parseProperty(String rawValue, String name, Enumeration.Value valueType) {
        return Option$.MODULE$.apply((Object)rawValue).filter((Function1 & Serializable)_$9 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$9))).map((Function1 & Serializable)value -> Neo4jCsvImporter$ParsedProperty$.MODULE$.apply(name, MODULE$.parsePropertyValue((String)value, valueType)));
    }

    public Option<Neo4jCsvImporter.ParsedProperty> flatgraph$formats$neo4jcsv$Neo4jCsvImporter$$$parseArrayProperty(String rawValue, String name, Enumeration.Value valueType) {
        Object[] values = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(rawValue), ';');
        Object object = Predef$.MODULE$.refArrayOps(values);
        if (ArrayOps$.MODULE$.nonEmpty$extension(object)) {
            Object object2 = Predef$.MODULE$.refArrayOps(values);
            String string = (String)ArrayOps$.MODULE$.head$extension(object2);
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                Object object3 = Predef$.MODULE$.refArrayOps(values);
                Object[] parsedValues = (Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$10 -> MODULE$.parsePropertyValue((String)_$10, valueType), ClassTag$.MODULE$.Any());
                return Some$.MODULE$.apply((Object)Neo4jCsvImporter$ParsedProperty$.MODULE$.apply(name, parsedValues));
            }
        }
        return None$.MODULE$;
    }

    private Object parsePropertyValue(String rawString, Enumeration.Value valueType) {
        Enumeration.Value value = valueType;
        Enumeration.Value value2 = package$ColumnType$.MODULE$.Int();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value4 = package$ColumnType$.MODULE$.Long();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value6 = package$ColumnType$.MODULE$.Float();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value8 = package$ColumnType$.MODULE$.Double();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value10 = package$ColumnType$.MODULE$.Boolean();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            return BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value12 = package$ColumnType$.MODULE$.Byte();
        Enumeration.Value value13 = value;
        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
            return BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value14 = package$ColumnType$.MODULE$.Short();
        Enumeration.Value value15 = value;
        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
            return BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value16 = package$ColumnType$.MODULE$.Char();
        Enumeration.Value value17 = value;
        if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
            return BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(rawString)));
        }
        Enumeration.Value value18 = package$ColumnType$.MODULE$.String();
        Enumeration.Value value19 = value;
        if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
            return rawString;
        }
        Enumeration.Value value20 = package$ColumnType$.MODULE$.Point();
        Enumeration.Value value21 = value;
        if (!(value20 != null ? !value20.equals(value21) : value21 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Enumeration.Value value22 = package$ColumnType$.MODULE$.Date();
        Enumeration.Value value23 = value;
        if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Enumeration.Value value24 = package$ColumnType$.MODULE$.LocalTime();
        Enumeration.Value value25 = value;
        if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Enumeration.Value value26 = package$ColumnType$.MODULE$.Time();
        Enumeration.Value value27 = value;
        if (!(value26 != null ? !value26.equals(value27) : value27 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Enumeration.Value value28 = package$ColumnType$.MODULE$.LocalDateTime();
        Enumeration.Value value29 = value;
        if (!(value28 != null ? !value28.equals(value29) : value29 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Enumeration.Value value30 = package$ColumnType$.MODULE$.DateTime();
        Enumeration.Value value31 = value;
        if (!(value30 != null ? !value30.equals(value31) : value31 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Enumeration.Value value32 = package$ColumnType$.MODULE$.Duration();
        Enumeration.Value value33 = value;
        if (!(value32 != null ? !value32.equals(value33) : value33 != null)) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        throw new MatchError((Object)value);
    }

    public int flatgraph$formats$neo4jcsv$Neo4jCsvImporter$$$parseInt(String entry, Enumeration.Value columnType, int lineNo) {
        int n;
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(entry));
        }
        catch (Exception err) {
            throw new AssertionError(new StringBuilder(21).append(columnType).append(" is not an Int (").append(lineNo).append("): ").append(entry).append(": ").append(err).toString(), err);
        }
        return n;
    }

    private static final List $anonfun$4$$anonfun$1(Path headerFile$2) {
        throw new AssertionError((Object)new StringBuilder(21).append("header file ").append(headerFile$2).append(" is empty").toString());
    }

    private static final Neo4jCsvImporter.ColumnDef $anonfun$5(int idx$1) {
        throw new AssertionError((Object)new StringBuilder(74).append("column with index=").append(idx$1).append(" not found in column definitions derived from headerFile").toString());
    }

    private static final Neo4jCsvImporter.ColumnDef $anonfun$6(int idx$2) {
        throw new AssertionError((Object)new StringBuilder(74).append("column with index=").append(idx$2).append(" not found in column definitions derived from headerFile").toString());
    }
}

