/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.formats.graphson;

import flatgraph.DNode;
import flatgraph.DNodeOrNode;
import flatgraph.DiffGraphApplier$;
import flatgraph.DiffGraphBuilder;
import flatgraph.GNode;
import flatgraph.GenericDNode;
import flatgraph.GenericDNode$;
import flatgraph.Graph;
import flatgraph.formats.Importer;
import flatgraph.formats.graphson.GraphSONProtocol$;
import flatgraph.formats.graphson.package;
import flatgraph.formats.graphson.package$ListValue$;
import flatgraph.formats.graphson.package$NodeIdValue$;
import flatgraph.misc.ConversionException;
import flatgraph.misc.Conversions$;
import java.io.Serializable;
import java.nio.file.Path;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;

public final class GraphSONImporter$
implements Importer,
Serializable {
    private static Logger logger;
    public static final GraphSONImporter$ MODULE$;

    private GraphSONImporter$() {
    }

    static {
        MODULE$ = new GraphSONImporter$();
        Importer.$init$(MODULE$);
        Statics.releaseFence();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void flatgraph$formats$Importer$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GraphSONImporter$.class);
    }

    @Override
    public void runImport(Graph graph, Seq<Path> inputFiles) {
        if (inputFiles.size() != 1) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(40).append("input must be exactly one file, but got ").append(inputFiles.size()).toString());
        }
        Using$.MODULE$.resource((Object)Source$.MODULE$.fromFile(((Path)inputFiles.head()).toFile(), Codec$.MODULE$.fallbackSystemCodec()), (Function1)(JProcedure1 & Serializable)source -> {
            package.GraphSON graphSON = (package.GraphSON)spray.json.package$.MODULE$.enrichString(source.mkString()).parseJson().convertTo(GraphSONProtocol$.MODULE$.graphSONFormat());
            Seq<package.Vertex> graphsonNodes = graphSON.$atvalue().vertices();
            Map<Object, GNode> graphsonNodeIdToGNode = this.addNodesRaw(graphsonNodes, graph);
            DiffGraphBuilder diffGraph = new DiffGraphBuilder(graph.schema());
            graphSON.$atvalue().vertices().foreach((Function1)(JProcedure1 & Serializable)graphsonNode -> {
                LazyRef lazyRef = new LazyRef();
                long graphsonNodeId = graphsonNode.id().$atvalue();
                graphsonNode.properties().foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        package.Property property = (package.Property)tuple2._2();
                        return diffGraph.setNodeProperty(this.gNode$1(graphsonNodeIdToGNode, graphsonNodeId, lazyRef), name, this.extractPropertyValue(property, graphsonNodeIdToGNode));
                    }
                    throw new MatchError((Object)tuple2);
                });
            });
            graphSON.$atvalue().edges().foreach((Function1 & Serializable)edge -> {
                GNode src = this.lookupGNode(edge.outV().$atvalue(), graphsonNodeIdToGNode);
                GNode tgt = this.lookupGNode(edge.inV().$atvalue(), graphsonNodeIdToGNode);
                return diffGraph.addEdge((DNodeOrNode)src, (DNodeOrNode)tgt, edge.label(), this.flattenProperties(edge.properties(), graphsonNodeIdToGNode));
            });
            DiffGraphApplier$.MODULE$.applyDiff(graph, diffGraph);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private Map<Object, GNode> addNodesRaw(Seq<package.Vertex> graphsonNodes, Graph graph) {
        DiffGraphBuilder diffGraphForRawNodes = new DiffGraphBuilder(graph.schema());
        scala.collection.mutable.Map graphsonNodeIdToGNode = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        graphsonNodes.foreach((Function1 & Serializable)graphsonNode -> {
            GenericDNode newNode = new GenericDNode(Conversions$.MODULE$.toShortSafely(graph.schema().getNodeKindByLabel(graphsonNode.label())), GenericDNode$.MODULE$.$lessinit$greater$default$2());
            diffGraphForRawNodes.addNode((DNode)newNode);
            return graphsonNodeIdToGNode.put((Object)BoxesRunTime.boxToLong((long)graphsonNode.id().$atvalue()), (Object)newNode);
        });
        DiffGraphApplier$.MODULE$.applyDiff(graph, diffGraphForRawNodes);
        return graphsonNodeIdToGNode.view().mapValues((Function1 & Serializable)_$1 -> (GNode)_$1.storedRef().get()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private GNode lookupGNode(long graphsonNodeId, Map<Object, GNode> graphsonNodeIdToGNode) {
        return (GNode)graphsonNodeIdToGNode.get((Object)BoxesRunTime.boxToLong((long)graphsonNodeId)).getOrElse(() -> this.lookupGNode$$anonfun$1(graphsonNodeId));
    }

    private Object extractPropertyValue(package.Property property, Map<Object, GNode> graphsonNodeIdToGNode) {
        package.PropertyValue propertyValue = property.$atvalue();
        if (propertyValue instanceof package.ListValue) {
            package.ListValue listValue = package$ListValue$.MODULE$.unapply((package.ListValue)propertyValue);
            Object[] objectArray = listValue._1();
            String string = listValue._2();
            Object[] values = objectArray;
            Object object = Predef$.MODULE$.refArrayOps(values);
            return ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)value -> this.handleSingle$1((Map)graphsonNodeIdToGNode, (package.PropertyValue)value), ClassTag$.MODULE$.Any());
        }
        package.PropertyValue value2 = propertyValue;
        return this.handleSingle$1(graphsonNodeIdToGNode, value2);
    }

    private Object flattenProperties(Map<String, package.Property> properties, Map<Object, GNode> graphsonNodeIdToGNode) {
        SeqOps seqOps;
        List list = ((IterableOnceOps)((IterableOps)properties.view().map((Function1 & Serializable)_$2 -> ((package.Property)_$2._2()).$atvalue())).map((Function1 & Serializable)x$1 -> {
            package.PropertyValue propertyValue = x$1;
            if (propertyValue instanceof package.ListValue) {
                package.ListValue listValue = package$ListValue$.MODULE$.unapply((package.ListValue)propertyValue);
                Object[] objectArray = listValue._1();
                String string = listValue._2();
                Object[] value = objectArray;
                Object object = Predef$.MODULE$.refArrayOps(value);
                return ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$3 -> _$3.$atvalue(), ClassTag$.MODULE$.Any());
            }
            if (propertyValue instanceof package.NodeIdValue) {
                package.NodeIdValue nodeIdValue = package$NodeIdValue$.MODULE$.unapply((package.NodeIdValue)propertyValue);
                long l = nodeIdValue._1();
                String string = nodeIdValue._2();
                long value = l;
                return this.lookupGNode(value, graphsonNodeIdToGNode);
            }
            package.PropertyValue x = propertyValue;
            return x.$atvalue();
        })).toList();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return null;
        }
        if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list), 1) == 0) {
            Object object;
            Object singleValue = object = SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
            return singleValue;
        }
        List multipleValues = list;
        return multipleValues;
    }

    private final GNode gNode$lzyINIT1$1(Map graphsonNodeIdToGNode$1, long graphsonNodeId$1, LazyRef gNode$lzy1$1) {
        GNode gNode;
        LazyRef lazyRef = gNode$lzy1$1;
        synchronized (lazyRef) {
            gNode = (GNode)(gNode$lzy1$1.initialized() ? gNode$lzy1$1.value() : gNode$lzy1$1.initialize((Object)this.lookupGNode(graphsonNodeId$1, (Map<Object, GNode>)graphsonNodeIdToGNode$1)));
        }
        return gNode;
    }

    private final GNode gNode$1(Map graphsonNodeIdToGNode$3, long graphsonNodeId$2, LazyRef gNode$lzy1$2) {
        return (GNode)(gNode$lzy1$2.initialized() ? gNode$lzy1$2.value() : this.gNode$lzyINIT1$1(graphsonNodeIdToGNode$3, graphsonNodeId$2, gNode$lzy1$2));
    }

    private final GNode lookupGNode$$anonfun$1(long graphsonNodeId$4) {
        throw new ConversionException(new StringBuilder(32).append("node with id=").append(graphsonNodeId$4).append(" not found in graph").toString());
    }

    private final Object handleSingle$1(Map graphsonNodeIdToGNode$7, package.PropertyValue value) {
        package.PropertyValue propertyValue = value;
        if (propertyValue instanceof package.NodeIdValue) {
            package.NodeIdValue nodeIdValue = package$NodeIdValue$.MODULE$.unapply((package.NodeIdValue)propertyValue);
            long l = nodeIdValue._1();
            String string = nodeIdValue._2();
            long value2 = l;
            return this.lookupGNode(value2, (Map<Object, GNode>)graphsonNodeIdToGNode$7);
        }
        package.PropertyValue value3 = propertyValue;
        return value3.$atvalue();
    }
}

