/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.DeleteControl;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusHandler;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.RetryInfo;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.sample.ErrorSimulationException;
import io.javaoperatorsdk.operator.sample.WebPage;
import io.javaoperatorsdk.operator.sample.WebPageSpec;
import io.javaoperatorsdk.operator.sample.WebPageStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ControllerConfiguration
public class WebPageReconciler
implements Reconciler<WebPage>,
ErrorStatusHandler<WebPage> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final KubernetesClient kubernetesClient;

    public WebPageReconciler(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    public UpdateControl<WebPage> reconcile(WebPage webPage, Context context) {
        if (((WebPageSpec)webPage.getSpec()).getHtml().contains("error")) {
            throw new ErrorSimulationException("Simulating error");
        }
        String ns = webPage.getMetadata().getNamespace();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("index.html", ((WebPageSpec)webPage.getSpec()).getHtml());
        ConfigMap htmlConfigMap = ((ConfigMapBuilder)((ConfigMapBuilder)new ConfigMapBuilder().withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(WebPageReconciler.configMapName(webPage))).withNamespace(ns)).build())).withData(data)).build();
        Deployment deployment = this.loadYaml(Deployment.class, "deployment.yaml");
        deployment.getMetadata().setName(WebPageReconciler.deploymentName(webPage));
        deployment.getMetadata().setNamespace(ns);
        deployment.getSpec().getSelector().getMatchLabels().put("app", WebPageReconciler.deploymentName(webPage));
        deployment.getSpec().getTemplate().getMetadata().getLabels().put("app", WebPageReconciler.deploymentName(webPage));
        ((Volume)deployment.getSpec().getTemplate().getSpec().getVolumes().get(0)).setConfigMap(((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(WebPageReconciler.configMapName(webPage))).build());
        Service service = this.loadYaml(Service.class, "service.yaml");
        service.getMetadata().setName(WebPageReconciler.serviceName(webPage));
        service.getMetadata().setNamespace(ns);
        service.getSpec().setSelector(deployment.getSpec().getTemplate().getMetadata().getLabels());
        ConfigMap existingConfigMap = (ConfigMap)((Resource)((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(htmlConfigMap.getMetadata().getNamespace())).withName(htmlConfigMap.getMetadata().getName())).get();
        this.log.info("Creating or updating ConfigMap {} in {}", (Object)htmlConfigMap.getMetadata().getName(), (Object)ns);
        ((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(ns)).createOrReplace((Object[])new ConfigMap[]{htmlConfigMap});
        this.log.info("Creating or updating Deployment {} in {}", (Object)deployment.getMetadata().getName(), (Object)ns);
        ((NonNamespaceOperation)this.kubernetesClient.apps().deployments().inNamespace(ns)).createOrReplace((Object[])new Deployment[]{deployment});
        if (((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(ns)).withName(service.getMetadata().getName())).get() == null) {
            this.log.info("Creating Service {} in {}", (Object)service.getMetadata().getName(), (Object)ns);
            ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(ns)).createOrReplace((Object[])new Service[]{service});
        }
        if (existingConfigMap != null && !StringUtils.equals((CharSequence)((CharSequence)existingConfigMap.getData().get("index.html")), (CharSequence)((CharSequence)htmlConfigMap.getData().get("index.html")))) {
            this.log.info("Restarting pods because HTML has changed in {}", (Object)ns);
            ((FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(ns)).withLabel("app", WebPageReconciler.deploymentName(webPage))).delete();
        }
        WebPageStatus status = new WebPageStatus();
        status.setHtmlConfigMap(htmlConfigMap.getMetadata().getName());
        status.setAreWeGood("Yes!");
        status.setErrorMessage(null);
        webPage.setStatus((Object)status);
        return UpdateControl.updateStatus((HasMetadata)webPage);
    }

    public DeleteControl cleanup(WebPage nginx, Context context) {
        this.log.info("Cleaning up for: {}", (Object)nginx.getMetadata().getName());
        this.log.info("Deleting ConfigMap {}", (Object)WebPageReconciler.configMapName(nginx));
        Resource configMap = (Resource)((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(nginx.getMetadata().getNamespace())).withName(WebPageReconciler.configMapName(nginx));
        if (configMap.get() != null) {
            configMap.delete();
        }
        this.log.info("Deleting Deployment {}", (Object)WebPageReconciler.deploymentName(nginx));
        RollableScalableResource deployment = (RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.apps().deployments().inNamespace(nginx.getMetadata().getNamespace())).withName(WebPageReconciler.deploymentName(nginx));
        if (deployment.get() != null) {
            ((EditReplacePatchDeletable)deployment.cascading(true)).delete();
        }
        this.log.info("Deleting Service {}", (Object)WebPageReconciler.serviceName(nginx));
        ServiceResource service = (ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(nginx.getMetadata().getNamespace())).withName(WebPageReconciler.serviceName(nginx));
        if (service.get() != null) {
            service.delete();
        }
        return DeleteControl.defaultDelete();
    }

    private static String configMapName(WebPage nginx) {
        return nginx.getMetadata().getName() + "-html";
    }

    private static String deploymentName(WebPage nginx) {
        return nginx.getMetadata().getName();
    }

    private static String serviceName(WebPage nginx) {
        return nginx.getMetadata().getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T loadYaml(Class<T> clazz, String yaml) {
        try (InputStream is = this.getClass().getResourceAsStream(yaml);){
            Object object = Serialization.unmarshal((InputStream)is, clazz);
            return (T)object;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot find yaml on classpath: " + yaml);
        }
    }

    public Optional<WebPage> updateErrorStatus(WebPage resource, RetryInfo retryInfo, RuntimeException e) {
        ((WebPageStatus)((Object)resource.getStatus())).setErrorMessage("Error: " + e.getMessage());
        return Optional.of(resource);
    }
}

