/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.config.informer.Informer;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceUtils;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependentResourceConfigBuilder;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Workflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.WorkflowBuilder;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import io.javaoperatorsdk.operator.sample.Utils;
import io.javaoperatorsdk.operator.sample.customresource.WebPage;
import io.javaoperatorsdk.operator.sample.dependentresource.ConfigMapDependentResource;
import io.javaoperatorsdk.operator.sample.dependentresource.DeploymentDependentResource;
import io.javaoperatorsdk.operator.sample.dependentresource.ExposedIngressCondition;
import io.javaoperatorsdk.operator.sample.dependentresource.IngressDependentResource;
import io.javaoperatorsdk.operator.sample.dependentresource.ServiceDependentResource;
import java.util.Arrays;
import java.util.List;

@ControllerConfiguration(informer=@Informer(labelSelector="!low-level"))
public class WebPageDependentsWorkflowReconciler
implements Reconciler<WebPage> {
    public static final String DEPENDENT_RESOURCE_LABEL_SELECTOR = "!low-level";
    private KubernetesDependentResource<ConfigMap, WebPage> configMapDR;
    private KubernetesDependentResource<Deployment, WebPage> deploymentDR;
    private KubernetesDependentResource<Service, WebPage> serviceDR;
    private KubernetesDependentResource<Ingress, WebPage> ingressDR;
    private final Workflow<WebPage> workflow;

    public WebPageDependentsWorkflowReconciler(KubernetesClient kubernetesClient) {
        this.initDependentResources(kubernetesClient);
        this.workflow = new WorkflowBuilder().addDependentResource(this.configMapDR).addDependentResource(this.deploymentDR).addDependentResource(this.serviceDR).addDependentResourceAndConfigure(this.ingressDR).withReconcilePrecondition((Condition)new ExposedIngressCondition()).build();
    }

    public List<EventSource<?, WebPage>> prepareEventSources(EventSourceContext<WebPage> context) {
        return EventSourceUtils.dependentEventSources(context, (DependentResource[])new DependentResource[]{this.configMapDR, this.deploymentDR, this.serviceDR, this.ingressDR});
    }

    public UpdateControl<WebPage> reconcile(WebPage webPage, Context<WebPage> context) throws Exception {
        Utils.simulateErrorIfRequested(webPage);
        this.workflow.reconcile((HasMetadata)webPage, context);
        return UpdateControl.patchStatus((HasMetadata)Utils.createWebPageForStatusUpdate(webPage, ((ConfigMap)context.getSecondaryResource(ConfigMap.class).orElseThrow()).getMetadata().getName()));
    }

    public ErrorStatusUpdateControl<WebPage> updateErrorStatus(WebPage resource, Context<WebPage> retryInfo, Exception e) {
        return Utils.handleError(resource, e);
    }

    private void initDependentResources(KubernetesClient client) {
        this.configMapDR = new ConfigMapDependentResource();
        this.deploymentDR = new DeploymentDependentResource();
        this.serviceDR = new ServiceDependentResource();
        this.ingressDR = new IngressDependentResource();
        Arrays.asList(this.configMapDR, this.deploymentDR, this.serviceDR, this.ingressDR).forEach(dr -> dr.configureWith(new KubernetesDependentResourceConfigBuilder().withKubernetesDependentInformerConfig(InformerConfiguration.builder((Class)dr.resourceType()).withLabelSelector(DEPENDENT_RESOURCE_LABEL_SELECTOR).build()).build()));
    }
}

