/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample.dependentresource;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.sample.Utils;
import io.javaoperatorsdk.operator.sample.customresource.WebPage;
import io.javaoperatorsdk.operator.sample.customresource.WebPageSpec;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KubernetesDependent(labelSelector="managed")
public class ConfigMapDependentResource
extends CRUDKubernetesDependentResource<ConfigMap, WebPage> {
    private static final Logger log = LoggerFactory.getLogger(ConfigMapDependentResource.class);

    public ConfigMapDependentResource() {
        super(ConfigMap.class);
    }

    protected ConfigMap desired(WebPage webPage, Context<WebPage> context) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("index.html", ((WebPageSpec)webPage.getSpec()).getHtml());
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("managed", "true");
        return ((ConfigMapBuilder)((ConfigMapBuilder)new ConfigMapBuilder().withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(Utils.configMapName(webPage))).withNamespace(webPage.getMetadata().getNamespace())).withLabels(labels)).build())).withData(data)).build();
    }

    public ConfigMap update(ConfigMap actual, ConfigMap target, WebPage primary, Context<WebPage> context) {
        ConfigMap res = (ConfigMap)super.update((HasMetadata)actual, (HasMetadata)target, (HasMetadata)primary, context);
        String ns = actual.getMetadata().getNamespace();
        log.info("Restarting pods because HTML has changed in {}", (Object)ns);
        ((FilterWatchListDeletable)((NonNamespaceOperation)this.getKubernetesClient().pods().inNamespace(ns)).withLabel("app", Utils.deploymentName(primary))).delete();
        return res;
    }
}

