/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Cleaner;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.DeleteControl;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusHandler;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Dependent;
import io.javaoperatorsdk.operator.sample.Utils;
import io.javaoperatorsdk.operator.sample.customresource.WebPage;
import io.javaoperatorsdk.operator.sample.dependentresource.ConfigMapDependentResource;
import io.javaoperatorsdk.operator.sample.dependentresource.DeploymentDependentResource;
import io.javaoperatorsdk.operator.sample.dependentresource.ExposedIngressCondition;
import io.javaoperatorsdk.operator.sample.dependentresource.IngressDependentResource;
import io.javaoperatorsdk.operator.sample.dependentresource.ServiceDependentResource;

@ControllerConfiguration(dependents={@Dependent(type=ConfigMapDependentResource.class), @Dependent(type=DeploymentDependentResource.class), @Dependent(type=ServiceDependentResource.class), @Dependent(type=IngressDependentResource.class, reconcilePrecondition=ExposedIngressCondition.class)})
public class WebPageManagedDependentsReconciler
implements Reconciler<WebPage>,
ErrorStatusHandler<WebPage>,
Cleaner<WebPage> {
    public static final String SELECTOR = "managed";

    public ErrorStatusUpdateControl<WebPage> updateErrorStatus(WebPage resource, Context<WebPage> context, Exception e) {
        return Utils.handleError(resource, e);
    }

    public UpdateControl<WebPage> reconcile(WebPage webPage, Context<WebPage> context) throws Exception {
        Utils.simulateErrorIfRequested(webPage);
        String name = ((ConfigMap)context.getSecondaryResource(ConfigMap.class).orElseThrow()).getMetadata().getName();
        webPage.setStatus((Object)Utils.createStatus(name));
        return UpdateControl.patchStatus((HasMetadata)webPage);
    }

    public DeleteControl cleanup(WebPage resource, Context<WebPage> context) {
        return DeleteControl.defaultDelete();
    }
}

