/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRule;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.sample.ErrorSimulationException;
import io.javaoperatorsdk.operator.sample.customresource.WebPage;
import io.javaoperatorsdk.operator.sample.customresource.WebPageSpec;
import io.javaoperatorsdk.operator.sample.customresource.WebPageStatus;

public class Utils {
    private Utils() {
    }

    public static WebPageStatus createStatus(String configMapName) {
        WebPageStatus status = new WebPageStatus();
        status.setHtmlConfigMap(configMapName);
        status.setAreWeGood(true);
        status.setErrorMessage(null);
        return status;
    }

    public static String configMapName(WebPage nginx) {
        return nginx.getMetadata().getName() + "-html";
    }

    public static String deploymentName(WebPage nginx) {
        return nginx.getMetadata().getName();
    }

    public static String serviceName(WebPage webPage) {
        return webPage.getMetadata().getName();
    }

    public static ErrorStatusUpdateControl<WebPage> handleError(WebPage resource, Exception e) {
        ((WebPageStatus)((Object)resource.getStatus())).setErrorMessage("Error: " + e.getMessage());
        return ErrorStatusUpdateControl.updateStatus((HasMetadata)resource);
    }

    public static void simulateErrorIfRequested(WebPage webPage) throws ErrorSimulationException {
        if (((WebPageSpec)webPage.getSpec()).getHtml().contains("error")) {
            throw new ErrorSimulationException("Simulating error");
        }
    }

    public static boolean isValidHtml(WebPage webPage) {
        String lowerCaseHtml = ((WebPageSpec)webPage.getSpec()).getHtml().toLowerCase();
        return lowerCaseHtml.contains("<html>") && lowerCaseHtml.contains("</html>");
    }

    public static WebPage setInvalidHtmlErrorMessage(WebPage webPage) {
        if (webPage.getStatus() == null) {
            webPage.setStatus((Object)new WebPageStatus());
        }
        ((WebPageStatus)((Object)webPage.getStatus())).setErrorMessage("Invalid html.");
        return webPage;
    }

    public static Ingress makeDesiredIngress(WebPage webPage) {
        Ingress ingress = (Ingress)ReconcilerUtils.loadYaml(Ingress.class, Utils.class, (String)"ingress.yaml");
        ingress.getMetadata().setName(webPage.getMetadata().getName());
        ingress.getMetadata().setNamespace(webPage.getMetadata().getNamespace());
        ((HTTPIngressPath)((IngressRule)ingress.getSpec().getRules().get(0)).getHttp().getPaths().get(0)).getBackend().getService().setName(Utils.serviceName(webPage));
        return ingress;
    }
}

