/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.Service;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.sample.Utils;
import io.javaoperatorsdk.operator.sample.WebPage;
import java.util.HashMap;

@KubernetesDependent(labelSelector="managed")
class ServiceDependentResource
extends CRUKubernetesDependentResource<Service, WebPage> {
    public ServiceDependentResource() {
        super(Service.class);
    }

    protected Service desired(WebPage webPage, Context<WebPage> context) {
        Service service = (Service)ReconcilerUtils.loadYaml(Service.class, ((Object)((Object)this)).getClass(), (String)"service.yaml");
        service.getMetadata().setName(Utils.serviceName(webPage));
        service.getMetadata().setNamespace(webPage.getMetadata().getNamespace());
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("app", Utils.deploymentName(webPage));
        service.getSpec().setSelector(labels);
        return service;
    }
}

