/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.sample.Utils;
import io.javaoperatorsdk.operator.sample.WebPage;

@KubernetesDependent(labelSelector="managed")
class DeploymentDependentResource
extends CRUKubernetesDependentResource<Deployment, WebPage> {
    public DeploymentDependentResource() {
        super(Deployment.class);
    }

    protected Deployment desired(WebPage webPage, Context<WebPage> context) {
        String deploymentName = Utils.deploymentName(webPage);
        Deployment deployment = (Deployment)ReconcilerUtils.loadYaml(Deployment.class, ((Object)((Object)this)).getClass(), (String)"deployment.yaml");
        deployment.getMetadata().setName(deploymentName);
        deployment.getMetadata().setNamespace(webPage.getMetadata().getNamespace());
        deployment.getSpec().getSelector().getMatchLabels().put("app", deploymentName);
        deployment.getSpec().getTemplate().getMetadata().getLabels().put("app", deploymentName);
        ((Volume)deployment.getSpec().getTemplate().getSpec().getVolumes().get(0)).setConfigMap(((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(Utils.configMapName(webPage))).build());
        return deployment;
    }
}

