/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.junit;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.RegisteredController;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceOverrider;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ControllerConfigurationOverrider;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.junit.AbstractOperatorExtension;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocallyRunOperatorExtension
extends AbstractOperatorExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocallyRunOperatorExtension.class);
    private final Operator operator;
    private final List<ReconcilerSpec> reconcilers;
    private final List<PortForwardSpec> portForwards;
    private final List<LocalPortForward> localPortForwards;
    private final List<Class<? extends CustomResource>> additionalCustomResourceDefinitions;
    private final Map<Reconciler, RegisteredController> registeredControllers;
    private final List<String> additionalCrds;

    private LocallyRunOperatorExtension(List<ReconcilerSpec> reconcilers, List<HasMetadata> infrastructure, List<PortForwardSpec> portForwards, List<Class<? extends CustomResource>> additionalCustomResourceDefinitions, Duration infrastructureTimeout, boolean preserveNamespaceOnError, boolean waitForNamespaceDeletion, boolean oneNamespacePerClass, KubernetesClient kubernetesClient, Consumer<ConfigurationServiceOverrider> configurationServiceOverrider, Function<ExtensionContext, String> namespaceNameSupplier, Function<ExtensionContext, String> perClassNamespaceNameSupplier, List<String> additionalCrds) {
        super(infrastructure, infrastructureTimeout, oneNamespacePerClass, preserveNamespaceOnError, waitForNamespaceDeletion, kubernetesClient, namespaceNameSupplier, perClassNamespaceNameSupplier);
        this.reconcilers = reconcilers;
        this.portForwards = portForwards;
        this.localPortForwards = new ArrayList<LocalPortForward>(portForwards.size());
        this.additionalCustomResourceDefinitions = additionalCustomResourceDefinitions;
        configurationServiceOverrider = configurationServiceOverrider != null ? configurationServiceOverrider.andThen(overrider -> overrider.withKubernetesClient(kubernetesClient)) : overrider -> overrider.withKubernetesClient(kubernetesClient);
        this.operator = new Operator(configurationServiceOverrider);
        this.registeredControllers = new HashMap<Reconciler, RegisteredController>();
        this.additionalCrds = additionalCrds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void applyCrd(Class<? extends HasMetadata> resourceClass, KubernetesClient client) {
        LocallyRunOperatorExtension.applyCrd(ReconcilerUtils.getResourceTypeName(resourceClass), client);
    }

    public static void applyCrd(String resourceTypeName, KubernetesClient client) {
        String path = "/META-INF/fabric8/" + resourceTypeName + "-v1.yml";
        try (InputStream is = LocallyRunOperatorExtension.class.getResourceAsStream(path);){
            LocallyRunOperatorExtension.applyCrd(is, path, client);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot apply CRD yaml: " + path, e);
        }
    }

    public static void applyCrd(CustomResourceDefinition crd, KubernetesClient client) {
        client.resource((HasMetadata)crd).serverSideApply();
    }

    private static void applyCrd(InputStream is, String path, KubernetesClient client) {
        try {
            if (is == null) {
                throw new IllegalStateException("Cannot find CRD at " + path);
            }
            String crdString = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            LOGGER.debug("Applying CRD: {}", (Object)crdString);
            NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable crd = client.load((InputStream)new ByteArrayInputStream(crdString.getBytes()));
            crd.serverSideApply();
            Thread.sleep(2000L);
            LOGGER.debug("Applied CRD with path: {}", (Object)path);
        }
        catch (InterruptedException ex) {
            LOGGER.error("Interrupted.", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot apply CRD yaml: " + path, ex);
        }
    }

    public static List<CustomResourceDefinition> parseCrds(String path, KubernetesClient client) {
        List<CustomResourceDefinition> list;
        FileInputStream is = new FileInputStream(path);
        try {
            list = client.load((InputStream)new ByteArrayInputStream(((InputStream)is).readAllBytes())).items().stream().map(i -> (CustomResourceDefinition)i).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)is).close();
        return list;
    }

    private Stream<Reconciler> reconcilers() {
        return this.reconcilers.stream().map(reconcilerSpec -> reconcilerSpec.reconciler);
    }

    public List<Reconciler> getReconcilers() {
        return this.reconcilers().collect(Collectors.toUnmodifiableList());
    }

    public Reconciler getFirstReconciler() {
        return this.reconcilers().findFirst().orElseThrow();
    }

    public <T extends Reconciler> T getReconcilerOfType(Class<T> type) {
        return (T)this.reconcilers().filter(type::isInstance).map(type::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find a reconciler of type: " + type));
    }

    public RegisteredController getRegisteredControllerForReconcile(Class<? extends Reconciler> type) {
        return this.registeredControllers.get(this.getReconcilerOfType(type));
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    protected void before(ExtensionContext context) {
        super.before(context);
        KubernetesClient kubernetesClient = this.getKubernetesClient();
        for (PortForwardSpec ref : this.portForwards) {
            String podName = ((Pod)((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)kubernetesClient.pods().inNamespace(ref.getNamespace())).withLabel(ref.getLabelKey(), ref.getLabelValue())).list()).getItems().get(0)).getMetadata().getName();
            this.localPortForwards.add(((PodResource)((NonNamespaceOperation)kubernetesClient.pods().inNamespace(ref.getNamespace())).withName(podName)).portForward(ref.getPort(), ref.getLocalPort()));
        }
        this.additionalCustomResourceDefinitions.forEach(this::applyCrd);
        Map<String, CustomResourceDefinition> unappliedCRDs = this.getAdditionalCRDsFromFiles();
        for (ReconcilerSpec ref : this.reconcilers) {
            ControllerConfiguration config = this.operator.getConfigurationService().getConfigurationFor(ref.reconciler);
            ControllerConfigurationOverrider oconfig = ControllerConfigurationOverrider.override((ControllerConfiguration)config);
            Class resourceClass = config.getResourceClass();
            if (Namespaced.class.isAssignableFrom(resourceClass)) {
                oconfig.settingNamespace(this.namespace);
            }
            if (ref.retry != null) {
                oconfig.withRetry(ref.retry);
            }
            if (ref.controllerConfigurationOverrider != null) {
                ref.controllerConfigurationOverrider.accept(oconfig);
            }
            String resourceTypeName = ReconcilerUtils.getResourceTypeName((Class)resourceClass);
            if (CustomResource.class.isAssignableFrom(resourceClass)) {
                if (unappliedCRDs.get(resourceTypeName) != null) {
                    this.applyCrd(resourceTypeName);
                    unappliedCRDs.remove(resourceTypeName);
                } else {
                    this.applyCrd(resourceClass);
                }
            }
            RegisteredController registeredController = this.operator.register(ref.reconciler, oconfig.build());
            this.registeredControllers.put(ref.reconciler, registeredController);
        }
        unappliedCRDs.keySet().forEach(this::applyCrd);
        LOGGER.debug("Starting the operator locally");
        this.operator.start();
    }

    private Map<String, CustomResourceDefinition> getAdditionalCRDsFromFiles() {
        HashMap<String, CustomResourceDefinition> crdMappings = new HashMap<String, CustomResourceDefinition>();
        this.additionalCrds.forEach(p -> {
            List<CustomResourceDefinition> crds = LocallyRunOperatorExtension.parseCrds(p, this.getKubernetesClient());
            crds.forEach(c -> crdMappings.put(c.getMetadata().getName(), (CustomResourceDefinition)c));
        });
        return crdMappings;
    }

    public void applyCrd(Class<? extends CustomResource> crClass) {
        this.applyCrd(ReconcilerUtils.getResourceTypeName(crClass));
    }

    public void applyCrd(String resourceTypeName) {
        LocallyRunOperatorExtension.applyCrd(resourceTypeName, this.getKubernetesClient());
    }

    @Override
    protected void after(ExtensionContext context) {
        super.after(context);
        try {
            this.operator.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (LocalPortForward ref : this.localPortForwards) {
            try {
                ref.close();
            }
            catch (Exception exception) {}
        }
        this.localPortForwards.clear();
    }

    private static class ReconcilerSpec {
        final Reconciler reconciler;
        final Retry retry;
        final Consumer<ControllerConfigurationOverrider> controllerConfigurationOverrider;

        public ReconcilerSpec(Reconciler reconciler, Retry retry) {
            this(reconciler, retry, null);
        }

        public ReconcilerSpec(Reconciler reconciler, Retry retry, Consumer<ControllerConfigurationOverrider> controllerConfigurationOverrider) {
            this.reconciler = reconciler;
            this.retry = retry;
            this.controllerConfigurationOverrider = controllerConfigurationOverrider;
        }
    }

    private static class PortForwardSpec {
        final String namespace;
        final String labelKey;
        final String labelValue;
        final int port;
        final int localPort;

        public PortForwardSpec(String namespace, String labelKey, String labelValue, int port, int localPort) {
            this.namespace = namespace;
            this.labelKey = labelKey;
            this.labelValue = labelValue;
            this.port = port;
            this.localPort = localPort;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getLabelKey() {
            return this.labelKey;
        }

        public String getLabelValue() {
            return this.labelValue;
        }

        public int getPort() {
            return this.port;
        }

        public int getLocalPort() {
            return this.localPort;
        }
    }

    public static class Builder
    extends AbstractOperatorExtension.AbstractBuilder<Builder> {
        private final List<ReconcilerSpec> reconcilers;
        private final List<PortForwardSpec> portForwards;
        private final List<Class<? extends CustomResource>> additionalCustomResourceDefinitions;
        private final Map<String, String> crdMappings;
        private final List<String> additionalCRDs = new ArrayList<String>();
        private KubernetesClient kubernetesClient;

        protected Builder() {
            this.reconcilers = new ArrayList<ReconcilerSpec>();
            this.portForwards = new ArrayList<PortForwardSpec>();
            this.additionalCustomResourceDefinitions = new ArrayList<Class<? extends CustomResource>>();
            this.crdMappings = new HashMap<String, String>();
        }

        public Builder withReconciler(Reconciler value, Consumer<ControllerConfigurationOverrider> configurationOverrider) {
            return this.withReconciler(value, null, configurationOverrider);
        }

        public Builder withReconciler(Reconciler value, Retry retry, Consumer<ControllerConfigurationOverrider> configurationOverrider) {
            this.reconcilers.add(new ReconcilerSpec(value, retry, configurationOverrider));
            return this;
        }

        public Builder withReconciler(Reconciler value) {
            this.reconcilers.add(new ReconcilerSpec(value, null));
            return this;
        }

        public Builder withReconciler(Reconciler value, Retry retry) {
            this.reconcilers.add(new ReconcilerSpec(value, retry));
            return this;
        }

        public Builder withReconciler(Class<? extends Reconciler> value) {
            try {
                this.reconcilers.add(new ReconcilerSpec(value.getConstructor(new Class[0]).newInstance(new Object[0]), null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withPortForward(String namespace, String labelKey, String labelValue, int port, int localPort) {
            this.portForwards.add(new PortForwardSpec(namespace, labelKey, labelValue, port, localPort));
            return this;
        }

        public Builder withKubernetesClient(KubernetesClient kubernetesClient) {
            this.kubernetesClient = kubernetesClient;
            return this;
        }

        public Builder withAdditionalCustomResourceDefinition(Class<? extends CustomResource> customResource) {
            this.additionalCustomResourceDefinitions.add(customResource);
            return this;
        }

        public Builder withAdditionalCRD(String path) {
            this.additionalCRDs.add(path);
            return this;
        }

        public LocallyRunOperatorExtension build() {
            return new LocallyRunOperatorExtension(this.reconcilers, this.infrastructure, this.portForwards, this.additionalCustomResourceDefinitions, this.infrastructureTimeout, this.preserveNamespaceOnError, this.waitForNamespaceDeletion, this.oneNamespacePerClass, this.kubernetesClient, this.configurationServiceOverrider, this.namespaceNameSupplier, this.perClassNamespaceNameSupplier, this.additionalCRDs);
        }
    }
}

