/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.junit;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.RegisteredController;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceOverrider;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ControllerConfigurationOverrider;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.junit.AbstractOperatorExtension;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocallyRunOperatorExtension
extends AbstractOperatorExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocallyRunOperatorExtension.class);
    private final Operator operator;
    private final List<ReconcilerSpec> reconcilers;
    private final List<PortForwardSpec> portForwards;
    private final List<LocalPortForward> localPortForwards;
    private final List<Class<? extends CustomResource>> additionalCustomResourceDefinitions;
    private final Map<Reconciler, RegisteredController> registeredControllers;

    private LocallyRunOperatorExtension(List<ReconcilerSpec> reconcilers, List<HasMetadata> infrastructure, List<PortForwardSpec> portForwards, List<Class<? extends CustomResource>> additionalCustomResourceDefinitions, Duration infrastructureTimeout, boolean preserveNamespaceOnError, boolean waitForNamespaceDeletion, boolean oneNamespacePerClass, KubernetesClient kubernetesClient, Consumer<ConfigurationServiceOverrider> configurationServiceOverrider, Function<ExtensionContext, String> namespaceNameSupplier, Function<ExtensionContext, String> perClassNamespaceNameSupplier) {
        super(infrastructure, infrastructureTimeout, oneNamespacePerClass, preserveNamespaceOnError, waitForNamespaceDeletion, kubernetesClient, namespaceNameSupplier, perClassNamespaceNameSupplier);
        this.reconcilers = reconcilers;
        this.portForwards = portForwards;
        this.localPortForwards = new ArrayList<LocalPortForward>(portForwards.size());
        this.additionalCustomResourceDefinitions = additionalCustomResourceDefinitions;
        this.operator = new Operator(this.getKubernetesClient(), configurationServiceOverrider);
        this.registeredControllers = new HashMap<Reconciler, RegisteredController>();
    }

    public static Builder builder() {
        return new Builder();
    }

    private Stream<Reconciler> reconcilers() {
        return this.reconcilers.stream().map(reconcilerSpec -> reconcilerSpec.reconciler);
    }

    public List<Reconciler> getReconcilers() {
        return this.reconcilers().collect(Collectors.toUnmodifiableList());
    }

    public Reconciler getFirstReconciler() {
        return this.reconcilers().findFirst().orElseThrow();
    }

    public <T extends Reconciler> T getReconcilerOfType(Class<T> type) {
        return (T)this.reconcilers().filter(type::isInstance).map(type::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find a reconciler of type: " + type));
    }

    public RegisteredController getRegisteredControllerForReconcile(Class<? extends Reconciler> type) {
        return this.registeredControllers.get(this.getReconcilerOfType(type));
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    protected void before(ExtensionContext context) {
        super.before(context);
        KubernetesClient kubernetesClient = this.getKubernetesClient();
        for (PortForwardSpec portForwardSpec : this.portForwards) {
            String podName = ((Pod)((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)kubernetesClient.pods().inNamespace(portForwardSpec.getNamespace())).withLabel(portForwardSpec.getLabelKey(), portForwardSpec.getLabelValue())).list()).getItems().get(0)).getMetadata().getName();
            this.localPortForwards.add(((PodResource)((NonNamespaceOperation)kubernetesClient.pods().inNamespace(portForwardSpec.getNamespace())).withName(podName)).portForward(portForwardSpec.getPort(), portForwardSpec.getLocalPort()));
        }
        this.additionalCustomResourceDefinitions.forEach(cr -> this.applyCrd(ReconcilerUtils.getResourceTypeName((Class)cr)));
        for (ReconcilerSpec reconcilerSpec : this.reconcilers) {
            ControllerConfiguration config = this.operator.getConfigurationService().getConfigurationFor(reconcilerSpec.reconciler);
            ControllerConfigurationOverrider oconfig = ControllerConfigurationOverrider.override((ControllerConfiguration)config);
            if (Namespaced.class.isAssignableFrom(config.getResourceClass())) {
                oconfig.settingNamespace(this.namespace);
            }
            if (reconcilerSpec.retry != null) {
                oconfig.withRetry(reconcilerSpec.retry);
            }
            if (reconcilerSpec.controllerConfigurationOverrider != null) {
                reconcilerSpec.controllerConfigurationOverrider.accept(oconfig);
            }
            if (CustomResource.class.isAssignableFrom(config.getResourceClass())) {
                this.applyCrd(config.getResourceTypeName());
            }
            RegisteredController registeredController = this.operator.register(reconcilerSpec.reconciler, oconfig.build());
            this.registeredControllers.put(reconcilerSpec.reconciler, registeredController);
        }
        LOGGER.debug("Starting the operator locally");
        this.operator.start();
    }

    private void applyCrd(String resourceTypeName) {
        LocallyRunOperatorExtension.applyCrd(resourceTypeName, this.getKubernetesClient());
    }

    public static void applyCrd(Class<? extends HasMetadata> resourceClass, KubernetesClient client) {
        LocallyRunOperatorExtension.applyCrd(ReconcilerUtils.getResourceTypeName(resourceClass), client);
    }

    public static void applyCrd(String resourceTypeName, KubernetesClient client) {
        String path = "/META-INF/fabric8/" + resourceTypeName + "-v1.yml";
        try (InputStream is = LocallyRunOperatorExtension.class.getResourceAsStream(path);){
            if (is == null) {
                throw new IllegalStateException("Cannot find CRD at " + path);
            }
            String crdString = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            LOGGER.debug("Applying CRD: {}", (Object)crdString);
            NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable crd = client.load((InputStream)new ByteArrayInputStream(crdString.getBytes()));
            crd.serverSideApply();
            Thread.sleep(2000L);
            LOGGER.debug("Applied CRD with path: {}", (Object)path);
        }
        catch (InterruptedException ex) {
            LOGGER.error("Interrupted.", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot apply CRD yaml: " + path, ex);
        }
    }

    @Override
    protected void after(ExtensionContext context) {
        super.after(context);
        try {
            this.operator.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (LocalPortForward ref : this.localPortForwards) {
            try {
                ref.close();
            }
            catch (Exception exception) {}
        }
        this.localPortForwards.clear();
    }

    private static class ReconcilerSpec {
        final Reconciler reconciler;
        final Retry retry;
        final Consumer<ControllerConfigurationOverrider> controllerConfigurationOverrider;

        public ReconcilerSpec(Reconciler reconciler, Retry retry) {
            this(reconciler, retry, null);
        }

        public ReconcilerSpec(Reconciler reconciler, Retry retry, Consumer<ControllerConfigurationOverrider> controllerConfigurationOverrider) {
            this.reconciler = reconciler;
            this.retry = retry;
            this.controllerConfigurationOverrider = controllerConfigurationOverrider;
        }
    }

    private static class PortForwardSpec {
        final String namespace;
        final String labelKey;
        final String labelValue;
        final int port;
        final int localPort;

        public PortForwardSpec(String namespace, String labelKey, String labelValue, int port, int localPort) {
            this.namespace = namespace;
            this.labelKey = labelKey;
            this.labelValue = labelValue;
            this.port = port;
            this.localPort = localPort;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getLabelKey() {
            return this.labelKey;
        }

        public String getLabelValue() {
            return this.labelValue;
        }

        public int getPort() {
            return this.port;
        }

        public int getLocalPort() {
            return this.localPort;
        }
    }

    public static class Builder
    extends AbstractOperatorExtension.AbstractBuilder<Builder> {
        private final List<ReconcilerSpec> reconcilers = new ArrayList<ReconcilerSpec>();
        private final List<PortForwardSpec> portForwards = new ArrayList<PortForwardSpec>();
        private final List<Class<? extends CustomResource>> additionalCustomResourceDefinitions = new ArrayList<Class<? extends CustomResource>>();
        private KubernetesClient kubernetesClient;

        protected Builder() {
        }

        public Builder withReconciler(Reconciler value, Consumer<ControllerConfigurationOverrider> configurationOverrider) {
            return this.withReconciler(value, null, configurationOverrider);
        }

        public Builder withReconciler(Reconciler value, Retry retry, Consumer<ControllerConfigurationOverrider> configurationOverrider) {
            this.reconcilers.add(new ReconcilerSpec(value, retry, configurationOverrider));
            return this;
        }

        public Builder withReconciler(Reconciler value) {
            this.reconcilers.add(new ReconcilerSpec(value, null));
            return this;
        }

        public Builder withReconciler(Reconciler value, Retry retry) {
            this.reconcilers.add(new ReconcilerSpec(value, retry));
            return this;
        }

        public Builder withReconciler(Class<? extends Reconciler> value) {
            try {
                this.reconcilers.add(new ReconcilerSpec(value.getConstructor(new Class[0]).newInstance(new Object[0]), null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withPortForward(String namespace, String labelKey, String labelValue, int port, int localPort) {
            this.portForwards.add(new PortForwardSpec(namespace, labelKey, labelValue, port, localPort));
            return this;
        }

        public Builder withKubernetesClient(KubernetesClient kubernetesClient) {
            this.kubernetesClient = kubernetesClient;
            return this;
        }

        public Builder withAdditionalCustomResourceDefinition(Class<? extends CustomResource> customResource) {
            this.additionalCustomResourceDefinitions.add(customResource);
            return this;
        }

        public LocallyRunOperatorExtension build() {
            return new LocallyRunOperatorExtension(this.reconcilers, this.infrastructure, this.portForwards, this.additionalCustomResourceDefinitions, this.infrastructureTimeout, this.preserveNamespaceOnError, this.waitForNamespaceDeletion, this.oneNamespacePerClass, this.kubernetesClient, this.configurationServiceOverrider, this.namespaceNameSupplier, this.perClassNamespaceNameSupplier);
        }
    }
}

