/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.junit;

import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionContext;

public class DefaultPerClassNamespaceNameSupplier
implements Function<ExtensionContext, String> {
    public static final int MAX_CLASS_NAME_LENGTH = 57;

    @Override
    public String apply(ExtensionContext context) {
        String className = context.getRequiredTestClass().getSimpleName();
        Object namespace = className.length() > 57 ? className.substring(0, 57) : className;
        namespace = (String)namespace + "-";
        namespace = (String)namespace + UUID.randomUUID().toString().substring(0, 5);
        namespace = KubernetesResourceUtil.sanitizeName((String)namespace).toLowerCase(Locale.US);
        namespace = ((String)namespace).substring(0, Math.min(((String)namespace).length(), 63));
        return namespace;
    }
}

