/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.junit;

import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionContext;

public class DefaultNamespaceNameSupplier
implements Function<ExtensionContext, String> {
    public static final int RANDOM_SUFFIX_LENGTH = 5;
    public static final int DELIMITERS_LENGTH = 2;
    public static final int MAX_NAME_LENGTH_TOGETHER = 56;
    public static final int PART_RESERVED_NAME_LENGTH = 28;
    public static final String DELIMITER = "-";

    @Override
    public String apply(ExtensionContext context) {
        String classPart = context.getRequiredTestClass().getSimpleName();
        String methodPart = context.getRequiredTestMethod().getName();
        if (classPart.length() + methodPart.length() + 2 + 5 > 63) {
            if (classPart.length() > 28) {
                int classPartMaxLength = methodPart.length() > 28 ? 28 : 56 - methodPart.length();
                classPart = classPart.substring(0, Math.min(classPartMaxLength, classPart.length()));
            }
            if (methodPart.length() > 28) {
                int methodPartMaxLength = classPart.length() > 28 ? 28 : 56 - classPart.length();
                methodPart = methodPart.substring(0, Math.min(methodPartMaxLength, methodPart.length()));
            }
        }
        Object namespace = classPart + DELIMITER + methodPart + DELIMITER + UUID.randomUUID().toString().substring(0, 5);
        namespace = KubernetesResourceUtil.sanitizeName((String)namespace).toLowerCase(Locale.US);
        return namespace;
    }
}

