/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.junit;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.Utils;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceOverrider;
import io.javaoperatorsdk.operator.junit.DefaultNamespaceNameSupplier;
import io.javaoperatorsdk.operator.junit.DefaultPerClassNamespaceNameSupplier;
import io.javaoperatorsdk.operator.junit.HasKubernetesClient;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperatorExtension
implements HasKubernetesClient,
BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOperatorExtension.class);
    public static final int MAX_NAMESPACE_NAME_LENGTH = 63;
    public static final int CRD_READY_WAIT = 2000;
    public static final int DEFAULT_NAMESPACE_DELETE_TIMEOUT = 90;
    private final KubernetesClient kubernetesClient;
    protected final List<HasMetadata> infrastructure;
    protected Duration infrastructureTimeout;
    protected final boolean oneNamespacePerClass;
    protected final boolean preserveNamespaceOnError;
    protected final boolean waitForNamespaceDeletion;
    protected final int namespaceDeleteTimeout = 90;
    protected final Function<ExtensionContext, String> namespaceNameSupplier;
    protected final Function<ExtensionContext, String> perClassNamespaceNameSupplier;
    protected String namespace;

    protected AbstractOperatorExtension(List<HasMetadata> infrastructure, Duration infrastructureTimeout, boolean oneNamespacePerClass, boolean preserveNamespaceOnError, boolean waitForNamespaceDeletion, KubernetesClient kubernetesClient, Function<ExtensionContext, String> namespaceNameSupplier, Function<ExtensionContext, String> perClassNamespaceNameSupplier) {
        this.kubernetesClient = kubernetesClient != null ? kubernetesClient : new KubernetesClientBuilder().build();
        this.infrastructure = infrastructure;
        this.infrastructureTimeout = infrastructureTimeout;
        this.oneNamespacePerClass = oneNamespacePerClass;
        this.preserveNamespaceOnError = preserveNamespaceOnError;
        this.waitForNamespaceDeletion = waitForNamespaceDeletion;
        this.namespaceNameSupplier = namespaceNameSupplier;
        this.perClassNamespaceNameSupplier = perClassNamespaceNameSupplier;
    }

    public void beforeAll(ExtensionContext context) {
        this.beforeAllImpl(context);
    }

    public void beforeEach(ExtensionContext context) {
        this.beforeEachImpl(context);
    }

    public void afterAll(ExtensionContext context) {
        this.afterAllImpl(context);
    }

    public void afterEach(ExtensionContext context) {
        this.afterEachImpl(context);
    }

    @Override
    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public <T extends HasMetadata> NonNamespaceOperation<T, KubernetesResourceList<T>, Resource<T>> resources(Class<T> type) {
        return (NonNamespaceOperation)this.kubernetesClient.resources(type).inNamespace(this.namespace);
    }

    public <T extends HasMetadata> T get(Class<T> type, String name) {
        return (T)((HasMetadata)((Resource)((NonNamespaceOperation)this.kubernetesClient.resources(type).inNamespace(this.namespace)).withName(name)).get());
    }

    public <T extends HasMetadata> T create(T resource) {
        return (T)((HasMetadata)this.kubernetesClient.resource(resource).inNamespace(this.namespace).create());
    }

    @Deprecated(forRemoval=true)
    public <T extends HasMetadata> T create(Class<T> type, T resource) {
        return this.create(resource);
    }

    public <T extends HasMetadata> T replace(T resource) {
        return (T)((HasMetadata)this.kubernetesClient.resource(resource).inNamespace(this.namespace).replace());
    }

    @Deprecated(forRemoval=true)
    public <T extends HasMetadata> T replace(Class<T> type, T resource) {
        return this.replace(resource);
    }

    public <T extends HasMetadata> boolean delete(T resource) {
        List res = this.kubernetesClient.resource(resource).inNamespace(this.namespace).delete();
        return res.size() == 1 && ((StatusDetails)res.get(0)).getCauses().isEmpty();
    }

    @Deprecated(forRemoval=true)
    public <T extends HasMetadata> boolean delete(Class<T> type, T resource) {
        return this.delete(resource);
    }

    protected void beforeAllImpl(ExtensionContext context) {
        if (this.oneNamespacePerClass) {
            this.namespace = this.perClassNamespaceNameSupplier.apply(context);
            this.before(context);
        }
    }

    protected void beforeEachImpl(ExtensionContext context) {
        if (!this.oneNamespacePerClass) {
            this.namespace = this.namespaceNameSupplier.apply(context);
            this.before(context);
        }
    }

    protected void before(ExtensionContext context) {
        LOGGER.info("Initializing integration test in namespace {}", (Object)this.namespace);
        ((Resource)this.kubernetesClient.namespaces().resource((Object)((NamespaceBuilder)new NamespaceBuilder().withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(this.namespace)).build())).build())).serverSideApply();
        this.kubernetesClient.resourceList(this.infrastructure).serverSideApply();
        this.kubernetesClient.resourceList(this.infrastructure).waitUntilReady(this.infrastructureTimeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    protected void afterAllImpl(ExtensionContext context) {
        if (this.oneNamespacePerClass) {
            this.after(context);
        }
    }

    protected void afterEachImpl(ExtensionContext context) {
        if (!this.oneNamespacePerClass) {
            this.after(context);
        }
    }

    protected void after(ExtensionContext context) {
        if (this.namespace != null) {
            if (this.preserveNamespaceOnError && context.getExecutionException().isPresent()) {
                LOGGER.info("Preserving namespace {}", (Object)this.namespace);
            } else {
                this.kubernetesClient.resourceList(this.infrastructure).delete();
                this.deleteOperator();
                LOGGER.info("Deleting namespace {} and stopping operator", (Object)this.namespace);
                ((Resource)this.kubernetesClient.namespaces().withName(this.namespace)).delete();
                if (this.waitForNamespaceDeletion) {
                    LOGGER.info("Waiting for namespace {} to be deleted", (Object)this.namespace);
                    Awaitility.await((String)"namespace deleted").pollInterval(50L, TimeUnit.MILLISECONDS).atMost(90L, TimeUnit.SECONDS).until(() -> ((Resource)this.kubernetesClient.namespaces().withName(this.namespace)).get() == null);
                }
            }
        }
    }

    protected void deleteOperator() {
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        protected final List<HasMetadata> infrastructure;
        protected Duration infrastructureTimeout;
        protected boolean preserveNamespaceOnError;
        protected boolean waitForNamespaceDeletion;
        protected boolean oneNamespacePerClass;
        protected int namespaceDeleteTimeout;
        protected Consumer<ConfigurationServiceOverrider> configurationServiceOverrider;
        protected Function<ExtensionContext, String> namespaceNameSupplier = new DefaultNamespaceNameSupplier();
        protected Function<ExtensionContext, String> perClassNamespaceNameSupplier = new DefaultPerClassNamespaceNameSupplier();

        protected AbstractBuilder() {
            this.infrastructure = new ArrayList<HasMetadata>();
            this.infrastructureTimeout = Duration.ofMinutes(1L);
            this.preserveNamespaceOnError = Utils.getSystemPropertyOrEnvVar((String)"josdk.it.preserveNamespaceOnError", (Boolean)false);
            this.waitForNamespaceDeletion = Utils.getSystemPropertyOrEnvVar((String)"josdk.it.waitForNamespaceDeletion", (Boolean)true);
            this.oneNamespacePerClass = Utils.getSystemPropertyOrEnvVar((String)"josdk.it.oneNamespacePerClass", (Boolean)false);
            this.namespaceDeleteTimeout = Utils.getSystemPropertyOrEnvVar((String)"josdk.it.namespaceDeleteTimeout", (int)90);
        }

        public T preserveNamespaceOnError(boolean value) {
            this.preserveNamespaceOnError = value;
            return (T)this;
        }

        public T waitForNamespaceDeletion(boolean value) {
            this.waitForNamespaceDeletion = value;
            return (T)this;
        }

        public T oneNamespacePerClass(boolean value) {
            this.oneNamespacePerClass = value;
            return (T)this;
        }

        public T withConfigurationService(Consumer<ConfigurationServiceOverrider> overrider) {
            this.configurationServiceOverrider = overrider;
            return (T)this;
        }

        public T withInfrastructureTimeout(Duration value) {
            this.infrastructureTimeout = value;
            return (T)this;
        }

        public T withInfrastructure(List<HasMetadata> hm) {
            this.infrastructure.addAll(hm);
            return (T)this;
        }

        public T withInfrastructure(HasMetadata ... hms) {
            this.infrastructure.addAll(Arrays.asList(hms));
            return (T)this;
        }

        public T withNamespaceDeleteTimeout(int timeout) {
            this.namespaceDeleteTimeout = timeout;
            return (T)this;
        }

        public AbstractBuilder<T> withNamespaceNameSupplier(Function<ExtensionContext, String> namespaceNameSupplier) {
            this.namespaceNameSupplier = namespaceNameSupplier;
            return this;
        }

        public AbstractBuilder<T> withPerClassNamespaceNameSupplier(Function<ExtensionContext, String> perClassNamespaceNameSupplier) {
            this.perClassNamespaceNameSupplier = perClassNamespaceNameSupplier;
            return this;
        }
    }
}

