/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.monitoring.micrometer;

import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.RetryInfo;
import io.javaoperatorsdk.operator.processing.GroupVersionKind;
import io.javaoperatorsdk.operator.processing.event.Event;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MicrometerMetrics
implements Metrics {
    private static final String PREFIX = "operator.sdk.";
    private static final String RECONCILIATIONS = "reconciliations.";
    private final MeterRegistry registry;

    public MicrometerMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public <T> T timeControllerExecution(Metrics.ControllerExecution<T> execution) {
        String name = execution.controllerName();
        String execName = "operator.sdk.controllers.execution." + execution.name();
        ResourceID resourceID = execution.resourceID();
        Map metadata = execution.metadata();
        ArrayList<String> tags = new ArrayList<String>(metadata.size() + 4);
        tags.addAll(List.of("controller", name, "resource.name", resourceID.getName(), "resource.namespace", resourceID.getNamespace().orElse(""), "resource.scope", resourceID.getNamespace().isPresent() ? "namespace" : "cluster"));
        GroupVersionKind gvk = (GroupVersionKind)metadata.get("josdk.resource.gvk");
        if (gvk != null) {
            tags.addAll(List.of("resource.group", gvk.group, "resource.version", gvk.version, "resource.kind", gvk.kind));
        }
        Timer timer = Timer.builder((String)execName).tags(tags.toArray(new String[0])).publishPercentiles(new double[]{0.3, 0.5, 0.95}).publishPercentileHistogram().register(this.registry);
        try {
            Object result = timer.record(() -> {
                try {
                    return execution.execute();
                }
                catch (Exception e) {
                    throw new OperatorException((Throwable)e);
                }
            });
            String successType = execution.successTypeName(result);
            this.registry.counter(execName + ".success", new String[]{"controller", name, "type", successType}).increment();
            return (T)result;
        }
        catch (Exception e) {
            String exception = e.getClass().getSimpleName();
            this.registry.counter(execName + ".failure", new String[]{"controller", name, "exception", exception}).increment();
            throw e;
        }
    }

    public void receivedEvent(Event event, Map<String, Object> metadata) {
        this.incrementCounter(event.getRelatedCustomResourceID(), "events.received", metadata, "event", event.getClass().getSimpleName());
    }

    public void cleanupDoneFor(ResourceID resourceID, Map<String, Object> metadata) {
        this.incrementCounter(resourceID, "events.delete", metadata, new String[0]);
    }

    public void reconcileCustomResource(ResourceID resourceID, RetryInfo retryInfoNullable, Map<String, Object> metadata) {
        Optional<RetryInfo> retryInfo = Optional.ofNullable(retryInfoNullable);
        this.incrementCounter(resourceID, "reconciliations.started", metadata, "reconciliations.retries.number", "" + retryInfo.map(RetryInfo::getAttemptCount).orElse(0), "reconciliations.retries.last", "" + retryInfo.map(RetryInfo::isLastAttempt).orElse(true));
    }

    public void finishedReconciliation(ResourceID resourceID, Map<String, Object> metadata) {
        this.incrementCounter(resourceID, "reconciliations.success", metadata, new String[0]);
    }

    public void failedReconciliation(ResourceID resourceID, Exception exception, Map<String, Object> metadata) {
        Throwable cause = exception.getCause();
        if (cause == null) {
            cause = exception;
        } else if (cause instanceof RuntimeException) {
            cause = cause.getCause() != null ? cause.getCause() : cause;
        }
        this.incrementCounter(resourceID, "reconciliations.failed", metadata, "exception", cause.getClass().getSimpleName());
    }

    public <T extends Map<?, ?>> T monitorSizeOf(T map, String name) {
        return (T)this.registry.gaugeMapSize(PREFIX + name + ".size", Collections.emptyList(), map);
    }

    private void incrementCounter(ResourceID id, String counterName, Map<String, Object> metadata, String ... additionalTags) {
        int additionalTagsNb = additionalTags != null && additionalTags.length > 0 ? additionalTags.length : 0;
        int metadataNb = metadata != null ? metadata.size() : 0;
        ArrayList<String> tags = new ArrayList<String>(6 + additionalTagsNb + metadataNb);
        tags.addAll(List.of("name", id.getName(), "namespace", id.getNamespace().orElse(""), "scope", id.getNamespace().isPresent() ? "namespace" : "cluster"));
        if (additionalTagsNb > 0) {
            tags.addAll(List.of(additionalTags));
        }
        if (metadataNb > 0) {
            GroupVersionKind gvk = (GroupVersionKind)metadata.get("josdk.resource.gvk");
            tags.addAll(List.of("group", gvk.group, "version", gvk.version, "kind", gvk.kind));
        }
        this.registry.counter(PREFIX + counterName, tags.toArray(new String[0])).increment();
    }
}

