/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.monitoring.micrometer;

import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.RetryInfo;
import io.javaoperatorsdk.operator.processing.event.Event;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MicrometerMetrics
implements Metrics {
    private static final String PREFIX = "operator.sdk.";
    private static final String RECONCILIATIONS = "reconciliations.";
    private final MeterRegistry registry;

    public MicrometerMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public <T> T timeControllerExecution(Metrics.ControllerExecution<T> execution) {
        String name = execution.controllerName();
        String execName = "operator.sdk.controllers.execution." + execution.name();
        Timer timer = Timer.builder((String)execName).tags(new String[]{"controller", name}).publishPercentiles(new double[]{0.3, 0.5, 0.95}).publishPercentileHistogram().register(this.registry);
        try {
            Object result = timer.record(() -> {
                try {
                    return execution.execute();
                }
                catch (Exception e) {
                    throw new OperatorException((Throwable)e);
                }
            });
            String successType = execution.successTypeName(result);
            this.registry.counter(execName + ".success", new String[]{"controller", name, "type", successType}).increment();
            return (T)result;
        }
        catch (Exception e) {
            String exception = e.getClass().getSimpleName();
            this.registry.counter(execName + ".failure", new String[]{"controller", name, "exception", exception}).increment();
            throw e;
        }
    }

    public void receivedEvent(Event event) {
        this.incrementCounter(event.getRelatedCustomResourceID(), "events.received", "event", event.getClass().getSimpleName());
    }

    public void cleanupDoneFor(ResourceID customResourceUid) {
        this.incrementCounter(customResourceUid, "events.delete", new String[0]);
    }

    public void reconcileCustomResource(ResourceID resourceID, RetryInfo retryInfoNullable) {
        Optional<RetryInfo> retryInfo = Optional.ofNullable(retryInfoNullable);
        this.incrementCounter(resourceID, "reconciliations.started", "reconciliations.retries.number", "" + retryInfo.map(RetryInfo::getAttemptCount).orElse(0), "reconciliations.retries.last", "" + retryInfo.map(RetryInfo::isLastAttempt).orElse(true));
    }

    public void finishedReconciliation(ResourceID resourceID) {
        this.incrementCounter(resourceID, "reconciliations.success", new String[0]);
    }

    public void failedReconciliation(ResourceID resourceID, Exception exception) {
        Throwable cause = exception.getCause();
        if (cause == null) {
            cause = exception;
        } else if (cause instanceof RuntimeException) {
            cause = cause.getCause() != null ? cause.getCause() : cause;
        }
        this.incrementCounter(resourceID, "reconciliations.failed", "exception", cause.getClass().getSimpleName());
    }

    public <T extends Map<?, ?>> T monitorSizeOf(T map, String name) {
        return (T)this.registry.gaugeMapSize(PREFIX + name + ".size", Collections.emptyList(), map);
    }

    private void incrementCounter(ResourceID id, String counterName, String ... additionalTags) {
        List<String> tags = List.of("name", id.getName(), "name", id.getName(), "namespace", id.getNamespace().orElse(""), "scope", id.getNamespace().isPresent() ? "namespace" : "cluster");
        if (additionalTags != null && additionalTags.length > 0) {
            tags = new LinkedList<String>(tags);
            tags.addAll(List.of(additionalTags));
        }
        this.registry.counter(PREFIX + counterName, tags.toArray(new String[0])).increment();
    }
}

