/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.junit;

import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.KubeAPIServer;
import io.javaoperatorsdk.jenvtest.junit.ClientInjectionHandler;
import io.javaoperatorsdk.jenvtest.junit.KubeConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;

public class KubeConfigInjectionHandler
implements ClientInjectionHandler {
    @Override
    public boolean isTargetFieldAvailable(ExtensionContext extensionContext, boolean staticField) {
        return this.getFieldForKubeConfigInjection(extensionContext, staticField).isPresent();
    }

    @Override
    public void inject(ExtensionContext extensionContext, boolean staticField, KubeAPIServer kubeApiServer) {
        Field field = this.getFieldForKubeConfigInjection(extensionContext, staticField).orElseThrow();
        this.setKubeConfigYamlToField(extensionContext, field, kubeApiServer);
    }

    private void setKubeConfigYamlToField(ExtensionContext extensionContext, Field kubeConfigField, KubeAPIServer kubeApiServer) {
        try {
            Object target = extensionContext.getTestInstance().orElseGet(() -> extensionContext.getTestClass().orElseThrow());
            kubeConfigField.setAccessible(true);
            kubeConfigField.set(target, kubeApiServer.getKubeConfigYaml());
        }
        catch (IllegalAccessException e) {
            throw new JenvtestException(e);
        }
    }

    public Optional<Field> getFieldForKubeConfigInjection(ExtensionContext extensionContext, boolean staticField) {
        Class clazz = (Class)extensionContext.getTestClass().orElseThrow();
        List kubeConfigFields = Arrays.stream(clazz.getDeclaredFields()).filter(f -> ((KubeConfig[])f.getAnnotationsByType(KubeConfig.class)).length > 0).collect(Collectors.toList());
        if (kubeConfigFields.isEmpty()) {
            return Optional.empty();
        }
        if (kubeConfigFields.size() > 1) {
            throw new JenvtestException("More fields annotation with @" + KubeConfig.class.getSimpleName() + " annotation");
        }
        Field field = (Field)kubeConfigFields.get(0);
        if (!field.getType().equals(String.class)) {
            throw new JenvtestException("Field annotated with @" + KubeConfig.class.getSimpleName() + " is not a String");
        }
        if (Modifier.isStatic(field.getModifiers()) != staticField) {
            return Optional.empty();
        }
        return Optional.of(field);
    }
}

