/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.binary;

import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.Utils;
import io.javaoperatorsdk.jenvtest.binary.OSInfo;
import io.javaoperatorsdk.jenvtest.binary.repo.BinaryRepo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryDownloader {
    private static final Logger log = LoggerFactory.getLogger(BinaryDownloader.class);
    private static final String OBJECT_TAR_PREFIX = "kubebuilder-tools-";
    private final String jenvtestDir;
    private final BinaryRepo binaryRepo;
    private final OSInfo osInfoProvider;
    private static final Map<String, ReentrantLock> versionLocks = new ConcurrentHashMap<String, ReentrantLock>();

    public BinaryDownloader(String jenvtestDir, OSInfo osInfoProvider) {
        this.jenvtestDir = jenvtestDir;
        this.osInfoProvider = osInfoProvider;
        this.binaryRepo = new BinaryRepo(osInfoProvider);
    }

    BinaryDownloader(String jenvtestDir, BinaryRepo binaryRepo, OSInfo osInfoProvider) {
        this.jenvtestDir = jenvtestDir;
        this.binaryRepo = binaryRepo;
        this.osInfoProvider = osInfoProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File download(String version) {
        ReentrantLock lock = versionLocks.computeIfAbsent(version, v -> new ReentrantLock());
        File dirForVersion = this.dirForVersion(version);
        lock.lock();
        try {
            if (dirForVersion.exists()) {
                File file = dirForVersion;
                return file;
            }
            new File(this.jenvtestDir, "k8s").mkdirs();
            log.info("Downloading binaries with version: {}", (Object)version);
            File tempFile = this.binaryRepo.downloadVersionToTempFile(version);
            File dir = this.createDirForBinaries(version);
            this.extractFiles(tempFile, dir);
            log.debug("Binary downloaded and extracted");
            boolean deleted = tempFile.delete();
            if (!deleted) {
                log.warn("Unable to delete temp file: {}", (Object)tempFile.getPath());
            }
        }
        finally {
            lock.unlock();
        }
        return dirForVersion;
    }

    public File downloadLatest() {
        String latest = this.findLatestVersion();
        return this.download(latest);
    }

    public File downloadLatestWildcard(String wildcardVersion) {
        String latest = this.findLatestOfWildcard(wildcardVersion);
        return this.download(latest);
    }

    private void extractFiles(File tempFile, File dir) {
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(tempFile))));){
            TarArchiveEntry entry = tarIn.getNextTarEntry();
            while (entry != null) {
                File file;
                if (!entry.isDirectory() && !(file = this.extractEntry(entry, dir, tarIn)).setExecutable(true)) {
                    throw new JenvtestException("Cannot make the file executable: " + file.getPath());
                }
                entry = tarIn.getNextTarEntry();
            }
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
    }

    private File extractEntry(TarArchiveEntry entry, File dir, TarArchiveInputStream tarIn) throws IOException {
        File targetFile;
        String name = entry.getName();
        if (name.contains("kubectl")) {
            targetFile = new File(dir, "kubectl");
        } else if (name.contains("kube-apiserver")) {
            targetFile = new File(dir, "kube-apiserver");
        } else if (name.contains("etcd")) {
            targetFile = new File(dir, "etcd");
        } else {
            throw new JenvtestException("Unexpected entry with name: " + entry.getName());
        }
        Files.copy((InputStream)tarIn, targetFile.toPath(), new CopyOption[0]);
        return targetFile;
    }

    private File createDirForBinaries(String version) {
        File dir = this.dirForVersion(version);
        if (!dir.mkdirs()) {
            throw new JenvtestException("Cannot created director: " + dir.getPath());
        }
        return dir;
    }

    private File dirForVersion(String version) {
        return new File(this.jenvtestDir, "k8s" + File.separator + version + Utils.platformSuffix(this.osInfoProvider));
    }

    public String findLatestVersion() {
        List allRelevantVersions = this.listAllRelevantVersions().sorted(Utils.SEMVER_COMPARATOR).collect(Collectors.toList());
        if (allRelevantVersions.isEmpty()) {
            throw new JenvtestException("Cannot find relevant version to download");
        }
        return (String)allRelevantVersions.get(allRelevantVersions.size() - 1);
    }

    public String findLatestOfWildcard(String wildcardVersion) {
        List allRelevantVersions = this.listAllRelevantVersions().filter(v -> v.startsWith(Utils.wildcardToPrefix(wildcardVersion))).sorted(Utils.SEMVER_COMPARATOR).collect(Collectors.toList());
        if (allRelevantVersions.isEmpty()) {
            throw new JenvtestException("Cannot find relevant version to download for wildcard version: " + wildcardVersion);
        }
        return (String)allRelevantVersions.get(allRelevantVersions.size() - 1);
    }

    private Stream<String> listAllRelevantVersions() {
        Stream<String> objects = this.binaryRepo.listObjectNames();
        return objects.filter(o -> o.contains(this.osInfoProvider.getOSName()) && o.contains(this.osInfoProvider.getOSArch())).map(o -> {
            String stripped = o.replace(OBJECT_TAR_PREFIX, "");
            String version = stripped.substring(0, stripped.indexOf("-"));
            if (version.startsWith("v")) {
                version = version.substring(1);
            }
            return version;
        });
    }
}

