/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.process;

import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.KubeAPIServerConfig;
import io.javaoperatorsdk.jenvtest.Utils;
import io.javaoperatorsdk.jenvtest.binary.BinaryManager;
import io.javaoperatorsdk.jenvtest.cert.CertManager;
import io.javaoperatorsdk.jenvtest.process.ProcessReadinessChecker;
import io.javaoperatorsdk.jenvtest.process.UnexpectedProcessStopHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeAPIServerProcess {
    private static final Logger log = LoggerFactory.getLogger(KubeAPIServerProcess.class);
    private static final Logger apiLog = LoggerFactory.getLogger((String)(KubeAPIServerProcess.class.getName() + ".APIServerProcessLogs"));
    public static final String KUBE_API_SERVER = "Kube API Server";
    private final CertManager certManager;
    private final BinaryManager binaryManager;
    private final KubeAPIServerConfig config;
    private volatile Process apiServerProcess;
    private volatile boolean stopped = false;
    private final UnexpectedProcessStopHandler processStopHandler;
    private int apiServerPort;

    public KubeAPIServerProcess(CertManager certManager, BinaryManager binaryManager, UnexpectedProcessStopHandler processStopHandler, KubeAPIServerConfig config) {
        this.certManager = certManager;
        this.binaryManager = binaryManager;
        this.config = config;
        this.processStopHandler = processStopHandler;
    }

    public int startApiServer(int etcdPort) {
        File apiServerBinary = this.binaryManager.binaries().getApiServer();
        try {
            if (!apiServerBinary.exists()) {
                throw new JenvtestException("Missing binary for API Server on path: " + apiServerBinary.getAbsolutePath());
            }
            this.apiServerPort = Utils.findFreePort();
            List<String> command = this.createCommand(apiServerBinary, this.apiServerPort, etcdPort);
            this.apiServerProcess = new ProcessBuilder(command).start();
            Utils.redirectProcessOutputToLogger(this.apiServerProcess.getInputStream(), apiLog);
            Utils.redirectProcessOutputToLogger(this.apiServerProcess.getErrorStream(), apiLog);
            this.apiServerProcess.onExit().thenApply(p -> {
                if (!this.stopped) {
                    this.stopped = true;
                    log.error("API Server process stopped unexpectedly");
                    this.processStopHandler.processStopped((Process)p);
                }
                return null;
            });
            log.debug("Kube API Server started on port: {} using binaries: {}", (Object)this.apiServerPort, (Object)apiServerBinary);
            return this.apiServerPort;
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
    }

    private List<String> createCommand(File apiServerBinary, int apiServerPort, int etcdPort) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(apiServerBinary.getAbsolutePath());
        command.addAll(this.config.getApiServerFlags());
        command.addAll(List.of("--cert-dir", this.config.getJenvtestDir(), "--secure-port", "" + apiServerPort, "--etcd-servers", "http://0.0.0.0:" + etcdPort, "--authorization-mode", "RBAC", "--service-account-issuer", "https://localhost", "--service-account-signing-key-file", this.certManager.getAPIServerKeyPath(), "--service-account-signing-key-file", this.certManager.getAPIServerKeyPath(), "--service-account-key-file", this.certManager.getAPIServerKeyPath(), "--service-account-issuer", this.certManager.getAPIServerCertPath(), "--disable-admission-plugins", "ServiceAccount", "--client-ca-file", this.certManager.getClientCertPath(), "--service-cluster-ip-range", "10.0.0.0/24", "--allow-privileged"));
        return command;
    }

    public void waitUntilReady() {
        ProcessReadinessChecker readinessChecker = new ProcessReadinessChecker();
        int timeout = this.config.getStartupTimeout();
        long startTime = System.currentTimeMillis();
        readinessChecker.waitUntilReady(this.apiServerPort, "readyz", KUBE_API_SERVER, true, timeout);
        int newTimout = (int)((long)timeout - (System.currentTimeMillis() - startTime));
        readinessChecker.waitUntilDefaultNamespaceAvailable(this.apiServerPort, this.binaryManager, this.certManager, this.config, newTimout);
    }

    public void stopApiServer() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.apiServerProcess != null) {
            try {
                this.apiServerProcess.destroyForcibly();
                this.apiServerProcess.waitFor();
            }
            catch (InterruptedException e) {
                throw new JenvtestException(e);
            }
        }
        log.debug("API Server stopped");
    }

    public int getApiServerPort() {
        return this.apiServerPort;
    }
}

