/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.kubeconfig;

import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.binary.BinaryManager;
import io.javaoperatorsdk.jenvtest.cert.CertManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeConfig {
    private static final Logger log = LoggerFactory.getLogger(KubeConfig.class);
    public static final String JENVTEST = "jenvtest";
    private final CertManager certManager;
    private final BinaryManager binaryManager;
    private String previousCurrentContext;

    public KubeConfig(CertManager certManager, BinaryManager binaryManager) {
        this.certManager = certManager;
        this.binaryManager = binaryManager;
    }

    public void updateKubeConfig(int apiServerPort) {
        log.debug("Updating kubeconfig");
        this.previousCurrentContext = this.execWithKubectlConfigAndWait("current-context").trim();
        this.execWithKubectlConfigAndWait("set-cluster", JENVTEST, "--server=https://127.0.0.1:" + apiServerPort, "--certificate-authority=" + this.certManager.getAPIServerCertPath());
        this.execWithKubectlConfigAndWait("set-credentials", JENVTEST, "--client-certificate=" + this.certManager.getClientCertPath(), "--client-key=" + this.certManager.getClientKeyPath());
        this.execWithKubectlConfigAndWait("set-context", JENVTEST, "--cluster=jenvtest", "--namespace=default", "--user=jenvtest");
        this.execWithKubectlConfigAndWait("use-context", JENVTEST);
    }

    public void restoreKubeConfig() {
        log.debug("Cleanig up kubeconfig");
        this.unset("contexts.jenvtest");
        this.unset("clusters.jenvtest");
        this.unset("users.jenvtest");
        this.unset("current-context");
        if (this.previousCurrentContext != null && !this.previousCurrentContext.isEmpty()) {
            this.execWithKubectlConfigAndWait("use-context", this.previousCurrentContext);
        }
    }

    private void unset(String target) {
        this.execWithKubectlConfigAndWait("unset", target);
    }

    public String generateKubeConfigYaml(int apiServerPort) {
        String string;
        block8: {
            InputStream is = KubeConfig.class.getResourceAsStream("/kubeconfig-template.yaml");
            try {
                String template = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                Object[] args = new Object[]{this.certManager.getAPIServerCertPath(), apiServerPort, this.certManager.getClientCertPath(), this.certManager.getClientKeyPath()};
                MessageFormat format = new MessageFormat(template);
                string = format.format(args);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JenvtestException(e);
                }
            }
            is.close();
        }
        return string;
    }

    private String execWithKubectlConfigAndWait(String ... arguments) {
        try {
            String stdout;
            ArrayList<String> args = new ArrayList<String>(arguments.length + 2);
            args.add(this.binaryManager.binaries().getKubectl().getPath());
            args.add("config");
            args.addAll(List.of(arguments));
            Process process = new ProcessBuilder(args).start();
            try (InputStream is = process.getInputStream();){
                stdout = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
            }
            process.waitFor();
            return stdout;
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JenvtestException(e);
        }
    }
}

