/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.binary;

import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.KubeAPIServerConfig;
import io.javaoperatorsdk.jenvtest.Utils;
import io.javaoperatorsdk.jenvtest.binary.Binaries;
import io.javaoperatorsdk.jenvtest.binary.BinaryDownloader;
import io.javaoperatorsdk.jenvtest.binary.OSInfo;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BinaryManager {
    public static final String BINARY_LIST_DIR = "k8s";
    private Binaries binaries;
    private final KubeAPIServerConfig config;
    private final BinaryDownloader downloader;
    private final OSInfo osInfo;

    public BinaryManager(KubeAPIServerConfig config) {
        this.config = config;
        this.osInfo = new OSInfo();
        this.downloader = new BinaryDownloader(config.getJenvtestDir(), this.osInfo);
    }

    public void initAndDownloadIfRequired() {
        File binaryDir;
        Optional<File> maybeBinaryDir = this.findTargetBinariesIfAvailable();
        if (maybeBinaryDir.isEmpty()) {
            if (this.config.isOfflineMode()) {
                throw new JenvtestException("Binaries cannot be found, and download is turned off");
            }
            binaryDir = this.downloadBinary();
        } else {
            binaryDir = maybeBinaryDir.orElseThrow();
        }
        this.initBinariesPojo(binaryDir);
    }

    private File downloadBinary() {
        if (this.config.getApiServerVersion().isEmpty()) {
            return this.downloader.downloadLatest();
        }
        String version = this.config.getApiServerVersion().orElseThrow();
        if (Utils.isWildcardVersion(version)) {
            return this.downloader.downloadLatestWildcard(version);
        }
        return this.downloader.download(version);
    }

    private void initBinariesPojo(File binaryDir) {
        this.binaries = new Binaries(new File(binaryDir, "etcd"), new File(binaryDir, "kube-apiserver"), new File(binaryDir, "kubectl"));
        if (!this.binaries.getApiServer().exists()) {
            throw new JenvtestException("API Server binary not found at path:" + this.binaries.getApiServer().getPath());
        }
        if (!this.binaries.getKubectl().exists()) {
            throw new JenvtestException("Kubectl binary not found at path:" + this.binaries.getKubectl().getPath());
        }
        if (!this.binaries.getEtcd().exists()) {
            throw new JenvtestException("Etcd binary not found at path:" + this.binaries.getEtcd().getPath());
        }
    }

    public Binaries binaries() {
        if (this.binaries == null) {
            throw new JenvtestException("Binaries not found.");
        }
        return this.binaries;
    }

    private Optional<File> findTargetBinariesIfAvailable() {
        String platformSuffix = Utils.platformSuffix(this.osInfo);
        String apiServerVersion = this.config.getApiServerVersion().orElse(null);
        if (apiServerVersion != null) {
            File targetVersionDir;
            if (Utils.isWildcardVersion(apiServerVersion)) {
                Optional<String> targetWildcardVersion = this.findLatestVersionForWildcard(apiServerVersion);
                if (targetWildcardVersion.isEmpty()) {
                    return Optional.empty();
                }
                apiServerVersion = targetWildcardVersion.orElseThrow();
            }
            if ((targetVersionDir = new File(this.config.getJenvtestDir(), BINARY_LIST_DIR + File.separator + apiServerVersion + platformSuffix)).exists()) {
                return Optional.of(targetVersionDir);
            }
            return Optional.empty();
        }
        File binariesListDir = new File(this.config.getJenvtestDir(), BINARY_LIST_DIR);
        List<String> dirVersionList = this.listBinaryDirectories();
        if (dirVersionList.isEmpty()) {
            return Optional.empty();
        }
        String latest = Utils.getLatestVersion(dirVersionList) + platformSuffix;
        return Optional.of(new File(binariesListDir, latest));
    }

    private Optional<String> findLatestVersionForWildcard(String wildcardVersion) {
        String targetPrefix = Utils.wildcardToPrefix(wildcardVersion);
        List<String> dirs = this.listBinaryDirectories();
        List<String> filteredDirs = dirs.stream().filter(d -> d.startsWith(targetPrefix)).collect(Collectors.toList());
        if (filteredDirs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Utils.getLatestVersion(filteredDirs));
    }

    private List<String> listBinaryDirectories() {
        String platformSuffix = Utils.platformSuffix(this.osInfo);
        File binariesListDir = new File(this.config.getJenvtestDir(), BINARY_LIST_DIR);
        if (!binariesListDir.exists()) {
            return Collections.emptyList();
        }
        return Stream.of(binariesListDir.list((dir, name) -> name != null && name.endsWith(platformSuffix))).map(s -> s.substring(0, s.indexOf(platformSuffix))).collect(Collectors.toList());
    }
}

