/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.process;

import io.javaoperatorsdk.jenvtest.CertManager;
import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.KubeAPIServerConfig;
import io.javaoperatorsdk.jenvtest.Utils;
import io.javaoperatorsdk.jenvtest.binary.BinaryManager;
import io.javaoperatorsdk.jenvtest.process.UnexpectedProcessStopHandler;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeAPIServerProcess {
    private static final Logger log = LoggerFactory.getLogger(KubeAPIServerProcess.class);
    private static final Logger apiLog = LoggerFactory.getLogger((String)(KubeAPIServerProcess.class.getName() + ".APIServerProcessLogs"));
    private final CertManager certManager;
    private final BinaryManager binaryManager;
    private final KubeAPIServerConfig config;
    private volatile Process apiServerProcess;
    private volatile boolean stopped = false;
    private final UnexpectedProcessStopHandler processStopHandler;

    public KubeAPIServerProcess(CertManager certManager, BinaryManager binaryManager, UnexpectedProcessStopHandler processStopHandler, KubeAPIServerConfig config) {
        this.certManager = certManager;
        this.binaryManager = binaryManager;
        this.config = config;
        this.processStopHandler = processStopHandler;
    }

    public void startApiServer() {
        File apiServerBinary = this.binaryManager.binaries().getApiServer();
        try {
            if (!apiServerBinary.exists()) {
                throw new JenvtestException("Missing binary for API Server on path: " + apiServerBinary.getAbsolutePath());
            }
            this.apiServerProcess = new ProcessBuilder(apiServerBinary.getAbsolutePath(), "--cert-dir", this.config.getJenvtestDir(), "--etcd-servers", "http://0.0.0.0:2379", "--authorization-mode", "RBAC", "--service-account-issuer", "https://localhost", "--service-account-signing-key-file", this.certManager.getAPIServerKeyPath(), "--service-account-signing-key-file", this.certManager.getAPIServerKeyPath(), "--service-account-key-file", this.certManager.getAPIServerKeyPath(), "--service-account-issuer", this.certManager.getAPIServerCertPath(), "--disable-admission-plugins", "ServiceAccount", "--client-ca-file", this.certManager.getClientCertPath(), "--service-cluster-ip-range", "10.0.0.0/24", "--allow-privileged").start();
            Utils.redirectProcessOutputToLogger(this.apiServerProcess.getInputStream(), apiLog);
            Utils.redirectProcessOutputToLogger(this.apiServerProcess.getErrorStream(), apiLog);
            this.apiServerProcess.onExit().thenApply(p -> {
                if (!this.stopped) {
                    this.stopped = true;
                    log.error("API Server process stopped unexpectedly");
                    this.processStopHandler.processStopped((Process)p);
                }
                return null;
            });
            log.debug("API Server started");
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
    }

    public void waitUntilDefaultNamespaceCreated() {
        try {
            AtomicBoolean started = new AtomicBoolean(false);
            Process proc = new ProcessBuilder(this.binaryManager.binaries().getKubectl().getPath(), "get", "ns", "--watch").start();
            Thread procWaiter = new Thread(() -> {
                try (Scanner sc = new Scanner(proc.getInputStream());){
                    while (sc.hasNextLine()) {
                        String line = sc.nextLine();
                        if (!line.contains("default")) continue;
                        started.set(true);
                        return;
                    }
                }
            });
            procWaiter.start();
            procWaiter.join(10000L);
            if (!started.get()) {
                throw new JenvtestException("API Server did not start properly");
            }
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JenvtestException(e);
        }
    }

    public void stopApiServer() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.apiServerProcess != null) {
            this.apiServerProcess.destroyForcibly();
        }
        log.debug("API Server stopped");
    }
}

