/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.jenvtest.process;

import io.javaoperatorsdk.jenvtest.JenvtestException;
import io.javaoperatorsdk.jenvtest.Utils;
import io.javaoperatorsdk.jenvtest.binary.BinaryManager;
import io.javaoperatorsdk.jenvtest.process.UnexpectedProcessStopHandler;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdProcess {
    private static final Logger log = LoggerFactory.getLogger(EtcdProcess.class);
    private static final Logger etcdLog = LoggerFactory.getLogger((String)(EtcdProcess.class.getName() + ".EtcdProcessLogs"));
    private final BinaryManager binaryManager;
    private volatile Process etcdProcess;
    private volatile boolean stopped = false;
    private final UnexpectedProcessStopHandler processStopHandler;

    public EtcdProcess(BinaryManager binaryManager, UnexpectedProcessStopHandler processStopHandler) {
        this.binaryManager = binaryManager;
        this.processStopHandler = processStopHandler;
    }

    public void startEtcd() {
        File etcdBinary = this.binaryManager.binaries().getEtcd();
        try {
            if (!etcdBinary.exists()) {
                throw new JenvtestException("Missing binary for etcd on path: " + etcdBinary.getAbsolutePath());
            }
            this.etcdProcess = new ProcessBuilder(etcdBinary.getAbsolutePath(), "--listen-client-urls=http://0.0.0.0:2379", "--advertise-client-urls=http://0.0.0.0:2379").start();
            Utils.redirectProcessOutputToLogger(this.etcdProcess.getInputStream(), etcdLog);
            Utils.redirectProcessOutputToLogger(this.etcdProcess.getErrorStream(), etcdLog);
            this.etcdProcess.onExit().thenApply(p -> {
                if (!this.stopped) {
                    this.stopped = true;
                    log.error("etcd process stopped unexpectedly");
                    this.processStopHandler.processStopped((Process)p);
                }
                return null;
            });
            log.debug("etcd started");
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
    }

    public void cleanEtcdData() {
        try {
            FileUtils.deleteDirectory((File)new File("default.etcd"));
        }
        catch (IOException e) {
            throw new JenvtestException(e);
        }
    }

    public void stopEtcd() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.etcdProcess != null) {
            this.etcdProcess.destroy();
        }
        log.debug("etcd stopped");
    }
}

