/*
 * Decompiled with CFR 0.152.
 */
package io.janstenpickle.trace4cats.strackdriver.oauth;

import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import io.circe.parser.package$;
import io.janstenpickle.trace4cats.strackdriver.oauth.GoogleAccountParser$JsonGoogleServiceAccount$;
import io.janstenpickle.trace4cats.strackdriver.oauth.GoogleServiceAccount;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.util.Either;

public final class GoogleAccountParser$ {
    public static final GoogleAccountParser$ MODULE$ = new GoogleAccountParser$();
    private static final Pattern privateKeyPattern = Pattern.compile("(?m)(?s)^---*BEGIN.*---*$(.*)^---*END.*---*$.*");
    private static volatile byte bitmap$init$0 = (byte)(bitmap$init$0 | 2);

    public final Either<Throwable, GoogleServiceAccount> parse(Path path) {
        return EitherObjectOps$.MODULE$.catchNonFatal$extension(package.either$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Function0 & Serializable)() -> Files.readString(path)).flatMap((Function1 & Serializable)string -> package$.MODULE$.parse(string).flatMap((Function1 & Serializable)json -> json.as(GoogleAccountParser$JsonGoogleServiceAccount$.MODULE$.codec()).flatMap((Function1 & Serializable)serviceAccount -> EitherObjectOps$.MODULE$.catchNonFatal$extension(package.either$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Function0 & Serializable)() -> {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(MODULE$.loadPem(serviceAccount.privateKey()));
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return new GoogleServiceAccount(serviceAccount.clientEmail(), (RSAPrivateKey)kf.generatePrivate(spec));
        }))));
    }

    private byte[] loadPem(String pem) {
        String encoded = privateKeyPattern.matcher(pem).replaceFirst("$1");
        return Base64.getMimeDecoder().decode(encoded);
    }

    private GoogleAccountParser$() {
    }
}

