/*
 * Decompiled with CFR 0.152.
 */
package io.janstenpickle.trace4cats.stackdriver.oauth;

import cats.FlatMap;
import cats.effect.Sync;
import cats.syntax.package;
import io.circe.parser.package$;
import io.janstenpickle.trace4cats.stackdriver.oauth.GoogleAccountParser$JsonGoogleServiceAccount$;
import io.janstenpickle.trace4cats.stackdriver.oauth.GoogleServiceAccount;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;

public final class GoogleAccountParser$ {
    public static final GoogleAccountParser$ MODULE$ = new GoogleAccountParser$();
    private static final Pattern privateKeyPattern = Pattern.compile("(?m)(?s)^---*BEGIN.*---*$(.*)^---*END.*---*$.*");
    private static volatile byte bitmap$init$0 = (byte)(bitmap$init$0 | 2);

    public final <F> F parse(Path path, Sync<F> F) {
        return (F)package.flatMap$.MODULE$.toFlatMapOps(F.delay((Function0 & Serializable)() -> new String(Files.readAllBytes(path))), F).flatMap((Function1 & Serializable)string -> package.flatMap$.MODULE$.toFlatMapOps(F.fromEither(package$.MODULE$.parse(string)), (FlatMap)F).flatMap((Function1 & Serializable)json -> package.flatMap$.MODULE$.toFlatMapOps(F.fromEither(json.as(GoogleAccountParser$JsonGoogleServiceAccount$.MODULE$.codec())), (FlatMap)F).flatMap((Function1 & Serializable)serviceAccount -> F.delay((Function0 & Serializable)() -> {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(MODULE$.loadPem(serviceAccount.privateKey()));
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return new GoogleServiceAccount(serviceAccount.clientEmail(), (RSAPrivateKey)kf.generatePrivate(spec));
        }))));
    }

    private byte[] loadPem(String pem) {
        String encoded = privateKeyPattern.matcher(pem).replaceFirst("$1");
        return Base64.getMimeDecoder().decode(encoded);
    }

    private GoogleAccountParser$() {
    }
}

