/*
 * Decompiled with CFR 0.152.
 */
package io.janstenpickle.trace4cats.strackdriver.oauth;

import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import io.circe.parser.package$;
import io.janstenpickle.trace4cats.strackdriver.oauth.GoogleAccountParser$JsonGoogleServiceAccount$;
import io.janstenpickle.trace4cats.strackdriver.oauth.GoogleServiceAccount;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.util.Either;

public final class GoogleAccountParser$ {
    public static GoogleAccountParser$ MODULE$;
    private final Pattern privateKeyPattern;
    private volatile byte bitmap$init$0;

    static {
        new GoogleAccountParser$();
    }

    public final Either<Throwable, GoogleServiceAccount> parse(Path path) {
        return EitherObjectOps$.MODULE$.catchNonFatal$extension(package.either$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Function0 & java.io.Serializable & Serializable)() -> Files.readString(path)).flatMap((Function1 & java.io.Serializable & Serializable)string -> package$.MODULE$.parse(string).flatMap((Function1 & java.io.Serializable & Serializable)json -> json.as(GoogleAccountParser$JsonGoogleServiceAccount$.MODULE$.codec()).flatMap((Function1 & java.io.Serializable & Serializable)serviceAccount -> EitherObjectOps$.MODULE$.catchNonFatal$extension(package.either$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Function0 & java.io.Serializable & Serializable)() -> {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(MODULE$.loadPem(serviceAccount.privateKey()));
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return new GoogleServiceAccount(serviceAccount.clientEmail(), (RSAPrivateKey)kf.generatePrivate(spec));
        }))));
    }

    private byte[] loadPem(String pem) {
        String encoded = this.privateKeyPattern.matcher(pem).replaceFirst("$1");
        return Base64.getMimeDecoder().decode(encoded);
    }

    private GoogleAccountParser$() {
        MODULE$ = this;
        this.privateKeyPattern = Pattern.compile("(?m)(?s)^---*BEGIN.*---*$(.*)^---*END.*---*$.*");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

